/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.graph.path;

import gr.forth.ics.graph.InspectableGraph;
import gr.forth.ics.graph.Node;
import gr.forth.ics.graph.path.ExpansionFront;
import gr.forth.ics.graph.path.Explorer;
import gr.forth.ics.graph.path.Path;
import gr.forth.ics.graph.path.PathAccumulator;
import gr.forth.ics.graph.path.PathFilter;
import gr.forth.ics.graph.path.Traversal;
import gr.forth.ics.graph.path.Visitor;
import gr.forth.ics.util.Args;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphTraversal {
    private final InspectableGraph graph;
    private final ExpansionFront expansionFront;
    private final List<PathFilter> filters;
    private final PathAccumulator pathAccumulator;
    private Visitor visitor;
    private Explorer explorer;

    public GraphTraversal(InspectableGraph graph, ExpansionFront expansionFront) {
        this(graph, expansionFront, new PathFilter[0]);
    }

    public GraphTraversal(InspectableGraph graph, ExpansionFront expansionFront, PathFilter ... filters) {
        this(graph, expansionFront, Arrays.asList(filters));
    }

    public GraphTraversal(InspectableGraph graph, ExpansionFront expansionFront, Collection<PathFilter> filters) {
        Args.notNull(graph, expansionFront);
        Args.doesNotContainNull(filters);
        this.graph = graph;
        this.expansionFront = expansionFront;
        this.filters = new ArrayList<PathFilter>(filters);
        this.pathAccumulator = new PathAccumulator(){

            public void addPath(Path path) {
                if (GraphTraversal.this.accepted(path)) {
                    GraphTraversal.this.expansionFront.addPath(path);
                }
            }
        };
        this.explorer = Explorer.newDefaultExplorer();
    }

    public void setExplorer(Explorer explorer) {
        Args.notNull((Object)explorer);
        this.explorer = explorer;
    }

    public Explorer getExplorer() {
        return this.explorer;
    }

    private void initFilters(Path rootPath) {
        for (PathFilter f : this.filters) {
            f.init(rootPath);
        }
    }

    private void endFilters() {
        for (PathFilter f : this.filters) {
            f.end();
        }
    }

    private boolean accepted(Path path) {
        for (PathFilter f : this.filters) {
            if (f.accept(path)) continue;
            return false;
        }
        return true;
    }

    public void traverse(Node root, Visitor visitor) {
        Args.notNull("Null visitor", (Object)visitor);
        this.visitor = visitor;
        Args.isTrue("Starting node not contained in graph", this.graph.containsNode(root));
        Path rootPath = root.asPath();
        this.initFilters(rootPath);
        this.expansionFront.reset();
        this.expansionFront.addPath(rootPath);
        this.expansionFront.nextRound();
        block4: while (this.expansionFront.hasNext()) {
            Path next = this.expansionFront.next();
            Traversal command = visitor.visit(next);
            if (command == null) {
                command = Traversal.CONTINUE;
            }
            switch (command) {
                case IGNORE: {
                    this.expansionFront.nextRound();
                    continue block4;
                }
                case EXIT: {
                    break block4;
                }
                default: {
                    this.explorer.explore(this.graph, next, this.pathAccumulator);
                    this.expansionFront.nextRound();
                    continue block4;
                }
            }
        }
        this.endFilters();
        this.visitor = null;
    }
}

