/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.graph.path;

import gr.forth.ics.graph.Tuple;
import gr.forth.ics.graph.path.Path;

public abstract class PathFilter {
    protected void init(Path initialPath) {
    }

    public abstract boolean accept(Path var1);

    protected void end() {
    }

    public static PathFilter hamilton() {
        return new NoDuplicateFilter(){

            public boolean accept(Path path) {
                return this.acceptAndMark(path.tailNode());
            }
        };
    }

    public static PathFilter euler() {
        return new NoDuplicateFilter(){

            public boolean accept(Path path) {
                if (path.size() == 0) {
                    return true;
                }
                return this.acceptAndMark(path.tailEdge());
            }
        };
    }

    private static abstract class NoDuplicateFilter
    extends PathFilter {
        private Object marked;

        private NoDuplicateFilter() {
        }

        protected void init(Path initialPath) {
            this.marked = new Object();
        }

        protected void end() {
            this.marked = null;
        }

        protected boolean acceptAndMark(Tuple tuple) {
            if (tuple.has(this.marked)) {
                return false;
            }
            tuple.putWeakly(this.marked, null);
            return true;
        }
    }
}

