/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.graph.util;

import gr.forth.ics.graph.Direction;
import gr.forth.ics.graph.Edge;
import gr.forth.ics.graph.Graph;
import gr.forth.ics.graph.Node;
import gr.forth.ics.graph.concrete.PrimaryGraph;
import gr.forth.ics.graph.concrete.SecondaryGraph;
import gr.forth.ics.graph.util.GraphDecorator;
import gr.forth.ics.util.Args;
import gr.forth.ics.util.ExtendedIterable;
import gr.forth.ics.util.Factory;
import gr.forth.ics.util.SerializableObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FoldingGraph
extends GraphDecorator {
    private final Object SUBGRAPH = new SerializableObject();
    private final Object REAL_EDGE = new SerializableObject();
    private final Object PARENT = new SerializableObject();
    private final Object KIDS = new SerializableObject();
    private final Factory<Graph> graphFactory;
    private final Graph graph;

    public FoldingGraph(Graph graph) {
        this(graph, true);
    }

    public FoldingGraph(Graph graph, boolean usePrimaries) {
        super(graph);
        this.graph = graph;
        this.graphFactory = usePrimaries ? new Factory<Graph>(){

            @Override
            public Graph create(Object ignored) {
                return new PrimaryGraph();
            }
        } : new Factory<Graph>(){

            @Override
            public Graph create(Object ignored) {
                return new SecondaryGraph();
            }
        };
    }

    public FoldingGraph(Graph graph, Factory<Graph> graphFactory) {
        super(graph);
        Args.notNull(graphFactory);
        this.graph = graph;
        this.graphFactory = graphFactory;
    }

    public Node fold() {
        return this.fold(Collections.<Node>emptyList());
    }

    public Node fold(Node ... nodes) {
        Args.notNull(nodes);
        return this.fold(Arrays.asList(nodes));
    }

    public Node fold(Iterable<Node> nodes) {
        Args.notNull(nodes);
        Set<Node> importedNodes = ExtendedIterable.wrap(nodes).drainToSet();
        Node folder = this.graph.newNode();
        Graph subgraph = this.graphFactory.create(null);
        folder.putWeakly(this.PARENT, null);
        Collection<Node> kids = this.getKids(folder);
        for (Node n : importedNodes) {
            n.putWeakly(this.PARENT, folder);
            if (!this.isFolder(n)) continue;
            kids.add(n);
        }
        folder.putWeakly(this.SUBGRAPH, subgraph);
        Collection<Edge> interedges = subgraph.importGraph(this.graph, importedNodes);
        for (Edge interedge : interedges) {
            Edge syntheticEdge = this.graph.newEdge(subgraph.containsNode(interedge.n1()) ? folder : interedge.n1(), subgraph.containsNode(interedge.n2()) ? folder : interedge.n2());
            syntheticEdge.putWeakly(this.REAL_EDGE, this.getRealEdge(interedge));
        }
        return folder;
    }

    public boolean isSyntheticEdge(Edge e) {
        if (e == null) {
            return false;
        }
        return e.has(this.REAL_EDGE);
    }

    public Edge getRealEdge(Edge e) {
        Args.notNull((Object)e);
        if (!this.isSyntheticEdge(e)) {
            return e;
        }
        return (Edge)e.get(this.REAL_EDGE);
    }

    public boolean isFolder(Node node) {
        return node.has(this.SUBGRAPH);
    }

    public Graph viewFolder(Node folder) {
        if (folder == null) {
            return this.graph;
        }
        this.checkFolder(folder);
        return (Graph)folder.get(this.SUBGRAPH);
    }

    public void unfold(Node folder) {
        this.checkFolder(folder);
        Graph subgraph = folder.getGraph(this.SUBGRAPH);
        Node parent = folder.getNode(this.PARENT);
        Graph parentGraph = parent != null ? parent.getGraph(this.SUBGRAPH) : this.graph;
        Set<Edge> syntheticEdges = parentGraph.edges(folder).drainToSet();
        List importedNodes = subgraph.nodes().drainToList();
        parentGraph.removeEdges(syntheticEdges);
        parentGraph.importGraph(subgraph);
        folder.remove(this.SUBGRAPH);
        parentGraph.removeNode(folder);
        for (Edge syntheticEdge : syntheticEdges) {
            if (!this.isSyntheticEdge(syntheticEdge)) continue;
            Direction direction = syntheticEdge.n1() == folder ? Direction.OUT : Direction.IN;
            Edge realEdge = this.getRealEdge(syntheticEdge);
            Node searchNode = direction == Direction.OUT ? realEdge.n1() : realEdge.n2();
            Node constantNode = direction == Direction.OUT ? syntheticEdge.n2() : syntheticEdge.n1();
            Node unfoldedParent = searchNode.getNode(this.PARENT);
            while (unfoldedParent != folder) {
                searchNode = unfoldedParent;
                unfoldedParent = searchNode.getNode(this.PARENT);
            }
            if (!parentGraph.containsNode(searchNode)) continue;
            if (realEdge.isIncident(searchNode) && realEdge.isIncident(constantNode)) {
                parentGraph.reinsertEdge(realEdge);
                continue;
            }
            Edge newEdge = direction == Direction.OUT ? parentGraph.newEdge(searchNode, constantNode) : parentGraph.newEdge(constantNode, searchNode);
            newEdge.putWeakly(this.REAL_EDGE, realEdge);
        }
        Collection<Node> kids = this.getKids(folder);
        if (parent == null) {
            for (Node kid : kids) {
                kid.remove(this.PARENT);
            }
        } else {
            for (Node kid : kids) {
                if (!this.isFolder(kid)) continue;
                kid.putWeakly(this.PARENT, parent);
            }
        }
        if (parent != null) {
            this.getKids(parent).remove(folder);
        }
        for (Node importedNode : importedNodes) {
            importedNode.putWeakly(this.PARENT, parent);
        }
    }

    public Node getParent(Node node) {
        Args.notNull((Object)node);
        return node.getNode(this.PARENT);
    }

    private void checkFolder(Node folder) {
        if (!this.isFolder(folder)) {
            throw new IllegalArgumentException("Not a folder node");
        }
    }

    private Collection<Node> getKids(Node parent) {
        HashSet kids = (HashSet)parent.get(this.KIDS);
        if (kids == null) {
            kids = new HashSet();
            parent.putWeakly(this.KIDS, kids);
        }
        return kids;
    }
}

