/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.graph.util;

import gr.forth.ics.graph.Direction;
import gr.forth.ics.graph.Edge;
import gr.forth.ics.graph.Graph;
import gr.forth.ics.graph.InspectableGraph;
import gr.forth.ics.graph.Node;
import gr.forth.ics.util.Args;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphCloner {
    private final boolean copyData;
    private final Direction nodeMapDirection;
    private final Direction edgeMapDirection;
    private Map<Node, Node> nodeMap;
    private Map<Edge, Edge> edgeMap;

    public GraphCloner(boolean copyData, Direction nodeMapDirection, Direction edgeMapDirection) {
        this.copyData = copyData;
        this.nodeMapDirection = nodeMapDirection;
        this.edgeMapDirection = edgeMapDirection;
    }

    public Graph copy(InspectableGraph source, Graph copy) {
        Args.notNull(source, copy);
        this.edgeMap = this.edgeMapDirection != null ? new HashMap<Edge, Edge>() : null;
        this.nodeMap = new HashMap<Node, Node>();
        for (Node n : source.nodes()) {
            Node cn = copy.newNode();
            if (this.copyData) {
                n.copyInto(cn);
            }
            this.nodeMap.put(n, cn);
            if (this.nodeMapDirection == null || !this.nodeMapDirection.isIn()) continue;
            this.nodeMap.put(cn, n);
        }
        for (Edge e : source.edges()) {
            Node cn1 = this.nodeMap.get(e.n1());
            Node cn2 = this.nodeMap.get(e.n2());
            Edge ce = copy.newEdge(cn1, cn2);
            if (this.copyData) {
                e.copyInto(ce);
            }
            if (this.edgeMapDirection == null) continue;
            if (this.edgeMapDirection.isOut()) {
                this.edgeMap.put(e, ce);
            }
            if (!this.edgeMapDirection.isIn()) continue;
            this.edgeMap.put(ce, e);
        }
        if (this.nodeMapDirection == null) {
            this.nodeMap = null;
        }
        return copy;
    }

    public Map<Node, Node> getNodeMap() {
        return this.nodeMap;
    }

    public Map<Edge, Edge> getEdgeMap() {
        return this.edgeMap;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GraphMapper {
        private final Map<Node, Node> nodeMap;
        private final Map<Edge, Edge> edgeMap;

        private GraphMapper(Map<Node, Node> nodeMap, Map<Edge, Edge> edgeMap) {
            this.nodeMap = Collections.unmodifiableMap(nodeMap);
            this.edgeMap = Collections.unmodifiableMap(edgeMap);
        }

        public Map<Node, Node> getNodeMap() {
            return this.nodeMap;
        }

        public Map<Edge, Edge> getEdgeMap() {
            return this.edgeMap;
        }
    }
}

