/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.graph.util;

import gr.forth.ics.graph.Edge;
import gr.forth.ics.graph.Graph;
import gr.forth.ics.graph.Node;
import gr.forth.ics.graph.util.InspectableGraphDecorator;
import gr.forth.ics.util.Args;
import java.io.Serializable;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphDecorator
extends InspectableGraphDecorator
implements Graph,
Serializable {
    private final Graph graph;

    public GraphDecorator(Graph graph) {
        super(graph);
        this.graph = graph;
    }

    @Override
    public Graph getDelegateGraph() {
        return this.graph;
    }

    @Override
    public Edge newEdge(Node node1, Node node2) {
        return this.newEdge(node1, node2, null);
    }

    @Override
    public Edge newEdge(Node node1, Node node2, Object value) {
        return this.graph.newEdge(node1, node2, value);
    }

    @Override
    public boolean removeEdge(Edge edge) {
        return this.graph.removeEdge(edge);
    }

    @Override
    public int removeEdges(Iterable<Edge> edges) {
        if (edges == null) {
            return 0;
        }
        int count = 0;
        for (Edge e : edges) {
            if (!this.removeEdge(e)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int removeAllEdges() {
        return this.removeEdges(this.edges());
    }

    @Override
    public Node newNode() {
        return this.newNode(null);
    }

    @Override
    public Node newNode(Object value) {
        return this.graph.newNode(value);
    }

    @Override
    public Node[] newNodes(int count) {
        Args.gte(count, 0);
        Node[] n = new Node[count];
        for (int i = 0; i < n.length; ++i) {
            n[i] = this.newNode(null);
        }
        return n;
    }

    @Override
    public Node[] newNodes(Object ... values) {
        Node[] n = new Node[values.length];
        for (int i = 0; i < n.length; ++i) {
            n[i] = this.newNode(values[i]);
        }
        return n;
    }

    @Override
    public boolean removeNode(Node node) {
        return this.graph.removeNode(node);
    }

    @Override
    public int removeNodes(Iterable<Node> nodes) {
        if (nodes == null) {
            return 0;
        }
        int count = 0;
        for (Node n : nodes) {
            if (!this.removeNode(n)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int removeAllNodes() {
        return this.removeNodes(this.nodes());
    }

    @Override
    public boolean isPrimary() {
        return this.graph.isPrimary();
    }

    @Override
    public boolean reinsertNode(Node n) {
        return this.graph.reinsertNode(n);
    }

    @Override
    public boolean reinsertEdge(Edge e) {
        return this.graph.reinsertEdge(e);
    }

    @Override
    public Edge invertEdge(Edge e) {
        return this.graph.invertEdge(e);
    }

    @Override
    public Edge updateEdge(Edge e, Node n1, Node n2) {
        return this.graph.updateEdge(e, n1, n2);
    }

    @Override
    public void importGraph(Graph g) {
        this.graph.importGraph(g);
    }

    @Override
    public Collection<Edge> importGraph(Graph g, Iterable<Node> nodes) {
        return this.graph.importGraph(g, nodes);
    }

    @Override
    public Edge[] split(Edge e) {
        return this.graph.split(e);
    }

    @Override
    public Edge[] split(Edge e, Object innerNodeValue) {
        return this.graph.split(e, innerNodeValue);
    }

    @Override
    public Edge merge(Edge e1, Edge e2) {
        return this.graph.merge(e1, e2);
    }

    @Override
    public Graph.OrderManager getOrderManager() {
        final Graph.OrderManager om = this.graph.getOrderManager();
        return new Graph.OrderManager(){

            public void moveNodeToFront(Node node) {
                om.moveNodeToFront(node);
            }

            public void moveNodeToBack(Node node) {
                om.moveNodeToBack(node);
            }

            public void moveNodeBefore(Node node, Node beforeWhat) {
                om.moveNodeBefore(node, beforeWhat);
            }

            public void moveNodeAfter(Node node, Node afterWhat) {
                om.moveNodeAfter(node, afterWhat);
            }

            public void moveEdgeToFront(Edge edge, boolean onSourceNode) {
                om.moveEdgeToFront(edge, onSourceNode);
            }

            public void moveEdgeToBack(Edge edge, boolean onSourceNode) {
                om.moveEdgeToBack(edge, onSourceNode);
            }

            public void moveEdgeBefore(Edge edge, boolean onSourceNode, Edge beforeWhat) {
                om.moveEdgeBefore(edge, onSourceNode, beforeWhat);
            }

            public void moveEdgeAfter(Edge edge, boolean onSourceNode, Edge afterWhat) {
                om.moveEdgeAfter(edge, onSourceNode, afterWhat);
            }
        };
    }
}

