/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.util;

import gr.forth.ics.util.IteratorRemoveStrategy;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCompoundIterator<E>
implements Iterator<E> {
    private Iterator<E> currentIterator;
    private IteratorRemoveStrategy<E> removeStrategy;
    protected E last;

    protected abstract Iterator<E> nextIterator();

    protected abstract boolean hasNextIterator();

    public AbstractCompoundIterator() {
        this(null);
    }

    public AbstractCompoundIterator(IteratorRemoveStrategy<E> removeStrategy) {
        this.removeStrategy = removeStrategy;
    }

    private void proceed() {
        if (this.currentIterator == null) {
            if (this.hasNextIterator()) {
                this.currentIterator = this.nextIterator();
            } else {
                return;
            }
        }
        if (!this.currentIterator.hasNext()) {
            this.currentIterator = null;
            while (this.hasNextIterator()) {
                this.currentIterator = this.nextIterator();
                if (this.currentIterator.hasNext()) {
                    return;
                }
                this.currentIterator = null;
            }
        }
    }

    @Override
    public boolean hasNext() {
        this.proceed();
        return this.currentIterator != null;
    }

    @Override
    public E next() {
        this.proceed();
        this.last = this.currentIterator.next();
        return this.last;
    }

    @Override
    public void remove() {
        this.currentIterator.remove();
        if (this.removeStrategy != null) {
            this.removeStrategy.removed(this.last);
        }
    }
}

