/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.util;

import java.util.Collections;
import java.util.ListIterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCompoundListIterator<E>
implements ListIterator<E> {
    private ListIterator<E> currentIterator = Collections.emptyList().listIterator();
    private int index = 0;
    protected E last;

    protected abstract ListIterator<E> nextIterator();

    protected abstract boolean hasNextIterator();

    protected abstract ListIterator<E> previousIterator();

    protected abstract boolean hasPreviousIterator();

    private void proceedForward() {
        while (!this.currentIterator.hasNext()) {
            if (this.hasNextIterator()) {
                this.currentIterator = this.nextIterator();
                continue;
            }
            return;
        }
    }

    private void proceedBackward() {
        while (!this.currentIterator.hasPrevious()) {
            if (this.hasPreviousIterator()) {
                this.currentIterator = this.previousIterator();
                continue;
            }
            return;
        }
    }

    @Override
    public boolean hasNext() {
        this.proceedForward();
        return this.currentIterator.hasNext();
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.proceedForward();
        E next = this.currentIterator.next();
        this.last = next;
        ++this.index;
        return next;
    }

    @Override
    public boolean hasPrevious() {
        this.proceedBackward();
        return this.currentIterator.hasPrevious();
    }

    @Override
    public E previous() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        E prev = this.currentIterator.previous();
        this.last = prev;
        --this.index;
        return prev;
    }

    @Override
    public int previousIndex() {
        return this.index - 1;
    }

    @Override
    public int nextIndex() {
        return this.index;
    }

    @Override
    public void set(E o) {
        this.currentIterator.set(o);
        this.last = null;
    }

    @Override
    public void remove() {
        this.currentIterator.remove();
        this.last = null;
    }

    @Override
    public void add(E o) {
        this.currentIterator.add(o);
        this.last = null;
    }
}

