/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.util;

import gr.forth.ics.util.Args;
import gr.forth.ics.util.Filter;
import gr.forth.ics.util.FilteringIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedIterable<E>
implements Iterable<E> {
    private final Iterable<E> iter;
    private final int expectedSize;
    protected List<Filter<? super E>> filters;
    private static final ExtendedIterable EMPTY = new ExtendedIterable(Collections.EMPTY_LIST);

    protected ExtendedIterable() {
        this(-1);
    }

    protected ExtendedIterable(int expectedSize) {
        this.iter = new Iterable<E>(){

            @Override
            public Iterator<E> iterator() {
                return ExtendedIterable.this.iterator();
            }
        };
        this.expectedSize = expectedSize;
    }

    public ExtendedIterable(Iterable<E> iter) {
        this(iter, -1);
    }

    public ExtendedIterable(Iterable<E> iter, int expectedSize) {
        Args.notNull(iter);
        this.iter = iter;
        this.expectedSize = expectedSize;
    }

    public int size() {
        int size = 0;
        for (E e : this) {
            ++size;
        }
        return size;
    }

    @Override
    public Iterator<E> iterator() {
        if (this.filters == null || this.filters.isEmpty()) {
            return this.iter.iterator();
        }
        return new FilteringIterator<E>(this.iter.iterator()){

            @Override
            protected boolean accept(E element) {
                for (Filter filter : ExtendedIterable.this.filters) {
                    if (filter.accept(element)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public Collection<E> drainTo(Collection<E> col) {
        Args.notNull(col);
        for (E e : this) {
            col.add(e);
        }
        return col;
    }

    public Set<E> drainTo(Set<E> set) {
        this.drainTo((Collection<E>)set);
        return set;
    }

    public List<E> drainTo(List<E> list) {
        this.drainTo((Collection<E>)list);
        return list;
    }

    public Set<E> drainToSet() {
        return this.drainTo(new LinkedHashSet());
    }

    public List<E> drainToList() {
        ArrayList list = this.expectedSize > 0 ? new ArrayList(this.expectedSize) : new ArrayList();
        return this.drainTo(list);
    }

    public ExtendedIterable<E> filter(Filter<? super E> filter) {
        Args.notNull(filter);
        if (this.filters == null) {
            this.filters = new ArrayList<Filter<? super E>>();
        }
        this.filters.add(filter);
        return this;
    }

    public ExtendedIterable<E> filter(List<Filter<? super E>> filters) {
        Args.notNull(filters);
        for (Filter<E> filter : filters) {
            this.filter(filter);
        }
        return this;
    }

    public String toString() {
        return this.drainToList().toString();
    }

    public static <K> ExtendedIterable<K> wrap(Iterable<K> iter) {
        if (iter instanceof ExtendedIterable) {
            return (ExtendedIterable)iter;
        }
        Args.notNull(iter);
        return new ExtendedIterable<K>(iter);
    }

    public static <E> Collection<E> drainTo(Iterator<? extends E> iter, Collection<E> col) {
        Args.notNull(col);
        if (iter != null) {
            while (iter.hasNext()) {
                col.add(iter.next());
            }
        }
        return col;
    }

    public static <E> Set<E> drainTo(Iterator<? extends E> iter, Set<E> set) {
        ExtendedIterable.drainTo(iter, set);
        return set;
    }

    public static <E> List<E> drainTo(Iterator<? extends E> iter, List<E> list) {
        ExtendedIterable.drainTo(iter, list);
        return list;
    }

    public static <E> Set<E> drainToSet(Iterator<? extends E> iter) {
        return ExtendedIterable.drainTo(iter, new LinkedHashSet());
    }

    public static <E> List<E> drainToList(Iterator<? extends E> iter) {
        return ExtendedIterable.drainTo(iter, new ArrayList());
    }

    public static <E> ExtendedIterable<E> empty() {
        return EMPTY;
    }
}

