/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.util;

import gr.forth.ics.util.Accessor;
import gr.forth.ics.util.Args;
import java.io.Serializable;
import java.util.AbstractSequentialList;
import java.util.ListIterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastLinkedList<E>
extends AbstractSequentialList<E>
implements Serializable {
    private static final long serialVersionUID = -5460960741591122089L;
    private int size;
    private ListCell<E> head;
    private ListCell<E> tail;
    private boolean consumed;

    public FastLinkedList() {
    }

    public FastLinkedList(Iterable<? extends E> elements) {
        Args.notNull(elements);
        for (E e : elements) {
            this.addLast(e);
        }
    }

    public boolean isConsumed() {
        return this.consumed;
    }

    @Override
    public boolean add(E element) {
        this.addLast(element);
        return true;
    }

    private void markConsumed() {
        this.consumed = true;
        this.size = 0;
        this.tail = null;
        this.head = null;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public E getFirst() {
        this.checkExisting(this.head);
        return this.head.value;
    }

    @Override
    public E getLast() {
        this.checkExisting(this.tail);
        return this.tail.value;
    }

    private void checkExisting(ListCell<E> cell) {
        if (cell == null) {
            throw new NoSuchElementException();
        }
    }

    private AccessorImpl<E> checkOwnedAccessor(Accessor<E> accessor) {
        if (accessor == null) {
            throw new IllegalArgumentException("Null accessor");
        }
        AccessorImpl accessorImpl = (AccessorImpl)accessor;
        if (!accessorImpl.belongsTo(this)) {
            throw new IllegalArgumentException("This accessor does not belong to this list");
        }
        return accessorImpl;
    }

    public Accessor<E> addFirst(E value) {
        this.checkNotConsumed();
        ++this.size;
        ListCell<E> cell = new ListCell<E>(value);
        cell.next = this.head;
        if (this.head != null) {
            this.head.prev = cell;
        }
        this.head = cell;
        if (this.tail == null) {
            this.tail = cell;
        }
        return new AccessorImpl<E>(cell, this);
    }

    public Accessor<E> addLast(E value) {
        this.checkNotConsumed();
        ++this.size;
        ListCell<E> newCell = new ListCell<E>(value);
        newCell.prev = this.tail;
        if (this.tail != null) {
            this.tail.next = newCell;
        }
        this.tail = newCell;
        if (this.head == null) {
            this.head = newCell;
        }
        return new AccessorImpl<E>(newCell, this);
    }

    private Accessor<E> addAfter(AccessorImpl<E> previous, E value) {
        this.checkNotConsumed();
        ++this.size;
        ListCell previousCell = previous.cell;
        ListCell nextCell = previousCell.next;
        ListCell<E> newCell = new ListCell<E>(value);
        previousCell.next = newCell;
        if (nextCell != null) {
            nextCell.prev = newCell;
        }
        newCell.next = nextCell;
        newCell.prev = previousCell;
        if (this.tail == previousCell) {
            this.tail = newCell;
        }
        return new AccessorImpl<E>(newCell, this);
    }

    private Accessor<E> addBefore(AccessorImpl<E> next, E value) {
        this.checkNotConsumed();
        ++this.size;
        ListCell nextCell = next.cell;
        ListCell previousCell = nextCell.prev;
        ListCell<E> newCell = new ListCell<E>(value);
        nextCell.prev = newCell;
        if (previousCell != null) {
            previousCell.next = newCell;
        }
        newCell.prev = previousCell;
        newCell.next = nextCell;
        if (this.head == nextCell) {
            this.head = newCell;
        }
        return new AccessorImpl<E>(newCell, this);
    }

    private void checkNotConsumed() {
        if (this.consumed) {
            FastLinkedList.throwIllegalStateException();
        }
    }

    private static void throwIllegalStateException() {
        throw new IllegalStateException("This list has been appended to another one, and thus has been marked as empty and unmodifiable, and should be thrown away");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E removeFirst() {
        this.checkExisting(this.head);
        --this.size;
        if (this.head == this.tail) {
            this.tail = null;
            try {
                Object e = this.head.value;
                return e;
            }
            finally {
                this.head = null;
            }
        }
        try {
            Object e = this.head.value;
            return e;
        }
        finally {
            this.head.next.prev = null;
            this.head = this.head.next;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E removeLast() {
        this.checkExisting(this.tail);
        --this.size;
        if (this.head == this.tail) {
            this.head = null;
            try {
                Object e = this.tail.value;
                return e;
            }
            finally {
                this.tail = null;
            }
        }
        try {
            Object e = this.tail.value;
            return e;
        }
        finally {
            this.tail.prev.next = null;
            this.tail = this.tail.prev;
        }
    }

    public void append(FastLinkedList<E> list) {
        this.checkNotConsumed();
        if (list.isEmpty()) {
            return;
        }
        if (this.isEmpty()) {
            this.head = list.head;
            this.tail = list.tail;
        } else {
            this.tail.next = list.head;
            list.head.prev = this.tail;
            this.tail = list.tail;
        }
        this.size += list.size();
        super.markConsumed();
    }

    public boolean ownsAccessor(Accessor<E> accessor) {
        if (accessor == null || !(accessor instanceof AccessorImpl)) {
            return false;
        }
        AccessorImpl ref = (AccessorImpl)accessor;
        return ref.belongsTo(this);
    }

    private void removeCell(ListCell<E> cell) {
        if (cell.prev != null) {
            cell.prev.next = cell.next;
        }
        if (cell.next != null) {
            cell.next.prev = cell.prev;
        }
        if (this.head == cell) {
            this.head = cell.next;
        }
        if (this.tail == cell) {
            this.tail = cell.prev;
        }
        cell.isDeleted = true;
        cell.value = null;
        --this.size;
    }

    public Accessor<E> accessorFor(E element) {
        ListCell<E> curr = this.head;
        while (curr != null) {
            if (element == null ? curr.value == null : element.equals(curr.value)) {
                return new AccessorImpl<E>(curr, this);
            }
            curr = curr.next;
        }
        return null;
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        if (this.isConsumed()) {
            return new ConsumedIterator();
        }
        return new ListIteratorImpl(index);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ListCell<E>
    implements Serializable {
        boolean isDeleted;
        ListCell<E> prev;
        ListCell<E> next;
        E value;

        ListCell(E value) {
            this.value = value;
        }

        public String toString() {
            return (this.prev == null ? "null" : this.prev.value.toString()) + "<--" + (this.value == null ? "null" : this.value.toString()) + "-->" + (this.next == null ? "null" : this.next.value.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AccessorImpl<E>
    implements Accessor<E>,
    Serializable {
        ListCell<E> cell;
        FastLinkedList<E> owner;

        AccessorImpl(ListCell<E> cell, FastLinkedList<E> owner) {
            this.cell = cell;
            this.owner = owner;
        }

        boolean belongsTo(FastLinkedList seq) {
            return this.owner == seq;
        }

        private void checkOwner() {
            if (this.owner == null) {
                throw new NoSuchElementException();
            }
        }

        void invalidate() {
            this.owner = null;
        }

        public String toString() {
            return this.cell.toString() + "," + (this.owner != null ? "valid" : "invalid");
        }

        @Override
        public boolean remove() {
            if (this.cell.isDeleted) {
                return false;
            }
            ((FastLinkedList)this.owner).removeCell(this.cell);
            this.invalidate();
            return true;
        }

        @Override
        public E get() {
            this.checkOwner();
            return this.cell.value;
        }

        @Override
        public boolean isRemoved() {
            return this.cell.isDeleted;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E set(E newValue) {
            try {
                Object e = this.cell.value;
                return e;
            }
            finally {
                this.cell.value = newValue;
            }
        }

        @Override
        public Accessor<E> addAfter(E value) {
            this.checkOwner();
            return ((FastLinkedList)this.owner).addAfter(this, value);
        }

        @Override
        public Accessor<E> addBefore(E value) {
            this.checkOwner();
            return ((FastLinkedList)this.owner).addBefore(this, value);
        }

        @Override
        public void moveAfter(Accessor<E> afterWhat) {
            this.checkOwner();
            AccessorImpl r = ((FastLinkedList)this.owner).checkOwnedAccessor(afterWhat);
            if (r.cell == this.cell) {
                return;
            }
            Object value = this.cell.value;
            FastLinkedList<E> owner = this.owner;
            this.remove();
            this.update(r.addAfter(value), owner);
        }

        @Override
        public void moveBefore(Accessor<E> beforeWhat) {
            this.checkOwner();
            AccessorImpl r = ((FastLinkedList)this.owner).checkOwnedAccessor(beforeWhat);
            if (r.cell == this.cell) {
                return;
            }
            Object value = this.cell.value;
            FastLinkedList<E> owner = this.owner;
            this.remove();
            this.update(r.addBefore(value), owner);
        }

        @Override
        public void moveToBack() {
            this.checkOwner();
            Object value = this.cell.value;
            FastLinkedList owner = this.owner;
            this.remove();
            this.update(owner.addLast(value), owner);
        }

        @Override
        public void moveToFront() {
            this.checkOwner();
            Object value = this.cell.value;
            FastLinkedList owner = this.owner;
            this.remove();
            this.update(owner.addFirst(value), owner);
        }

        @Override
        public Accessor<E> next() {
            this.checkOwner();
            if (this.cell.next == null) {
                throw new NoSuchElementException();
            }
            return new AccessorImpl(this.cell.next, this.owner);
        }

        @Override
        public Accessor<E> previous() {
            this.checkOwner();
            if (this.cell.prev == null) {
                throw new NoSuchElementException();
            }
            return new AccessorImpl(this.cell.prev, this.owner);
        }

        @Override
        public ListIterator<E> listIterator() {
            this.checkOwner();
            FastLinkedList<E> fastLinkedList = this.owner;
            fastLinkedList.getClass();
            return fastLinkedList.new ListIteratorImpl(this);
        }

        private void update(Accessor<E> valid, FastLinkedList<E> owner) {
            this.update((AccessorImpl)valid, owner);
        }

        private void update(AccessorImpl<E> copyFrom, FastLinkedList<E> owner) {
            this.owner = owner;
            this.cell = copyFrom.cell;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ListIteratorImpl
    implements ListIterator<E> {
        private ListCell<E> next;
        private ListCell<E> prev;
        private ListCell<E> last;
        private final boolean isIndexValid;
        private int index;

        ListIteratorImpl(int offset) {
            if (offset < 0 || offset > FastLinkedList.this.size) {
                throw new NoSuchElementException();
            }
            this.isIndexValid = true;
            this.index = offset;
            if (offset <= FastLinkedList.this.size / 2) {
                this.next = FastLinkedList.this.head;
                while (offset > 0) {
                    this.prev = this.next;
                    this.next = this.next.next;
                    --offset;
                }
            } else {
                this.prev = FastLinkedList.this.tail;
                for (offset = FastLinkedList.this.size - offset; offset > 0; --offset) {
                    this.next = this.prev;
                    this.prev = this.prev.prev;
                }
            }
        }

        ListIteratorImpl(Accessor<E> ref) {
            AccessorImpl reference = FastLinkedList.this.checkOwnedAccessor(ref);
            this.last = null;
            this.prev = reference.cell;
            this.next = this.prev.next;
            this.isIndexValid = false;
        }

        @Override
        public void add(E obj) {
            this.last = null;
            ++this.index;
            FastLinkedList.this.size++;
            ListCell newCell = new ListCell(obj);
            newCell.next = this.next;
            newCell.prev = this.prev;
            if (this.prev == null) {
                FastLinkedList.this.head = newCell;
            } else {
                this.prev.next = newCell;
            }
            this.prev = newCell;
            if (this.next == null) {
                FastLinkedList.this.tail = newCell;
            } else {
                this.next.prev = newCell;
            }
        }

        private void proceedForward() {
            while (this.next != null && this.next.isDeleted) {
                this.prev = this.next;
                this.next = this.next.next;
            }
        }

        private void proceedBackward() {
            while (this.prev != null && this.prev.isDeleted) {
                this.next = this.prev;
                this.prev = this.prev.prev;
            }
        }

        @Override
        public boolean hasNext() {
            this.proceedForward();
            return this.next != null;
        }

        @Override
        public boolean hasPrevious() {
            this.proceedBackward();
            return this.prev != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                Object e = this.next.value;
                return e;
            }
            finally {
                ++this.index;
                this.last = this.next;
                this.prev = this.next;
                this.next = this.next.next;
            }
        }

        @Override
        public int nextIndex() {
            return this.index;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            try {
                Object e = this.prev.value;
                return e;
            }
            finally {
                --this.index;
                this.last = this.prev;
                this.next = this.prev;
                this.prev = this.prev.prev;
            }
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void remove() {
            if (this.last == null || this.last.isDeleted) {
                throw new IllegalStateException();
            }
            --this.index;
            FastLinkedList.this.size--;
            this.last.isDeleted = true;
            this.prev = this.last.prev;
            this.next = this.last.next;
            if (this.prev != null) {
                this.prev.next = this.last.next;
            } else {
                FastLinkedList.this.head = this.next;
            }
            if (this.next != null) {
                this.next.prev = this.last.prev;
            } else {
                FastLinkedList.this.tail = this.prev;
            }
            this.last = null;
        }

        @Override
        public void set(E element) {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            this.last.value = element;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConsumedIterator<E>
    implements ListIterator<E> {
        private ConsumedIterator() {
        }

        @Override
        public void add(E e) {
            FastLinkedList.throwIllegalStateException();
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public boolean hasPrevious() {
            return false;
        }

        @Override
        public E next() {
            throw new NoSuchElementException();
        }

        @Override
        public int nextIndex() {
            return 0;
        }

        @Override
        public E previous() {
            throw new NoSuchElementException();
        }

        @Override
        public int previousIndex() {
            return -1;
        }

        @Override
        public void remove() {
            throw new NoSuchElementException();
        }

        @Override
        public void set(E e) {
            throw new NoSuchElementException();
        }
    }
}

