/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.util;

import gr.forth.ics.util.Args;
import gr.forth.ics.util.Filter;
import java.util.ListIterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteringListIterator<E>
implements ListIterator<E> {
    private final Filter<? super E> filter;
    private final ListIterator<E> listIterator;
    private int index;
    private int offset;
    private E elementToReturn;
    private Accessed accessed = Accessed.NONE;

    public FilteringListIterator(ListIterator<E> listIterator, Filter<? super E> filter) {
        this(listIterator, filter, 0);
    }

    public FilteringListIterator(ListIterator<E> listIterator, Filter<? super E> filter, int index) {
        Args.notNull(listIterator);
        Args.notNull(filter);
        this.listIterator = listIterator;
        this.filter = filter;
        this.index = index;
    }

    @Override
    public void add(E e) {
        this.moveBack();
        this.listIterator.add(e);
        ++this.index;
        this.accessed = Accessed.NONE;
    }

    @Override
    public boolean hasNext() {
        E element;
        if (this.elementToReturn != null && this.offset > 0) {
            return true;
        }
        this.elementToReturn = null;
        while (this.offset < 0) {
            this.listIterator.next();
            ++this.offset;
        }
        do {
            if (!this.listIterator.hasNext()) {
                return false;
            }
            element = this.listIterator.next();
            ++this.offset;
        } while (!this.filter.accept(element));
        this.elementToReturn = element;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            E e = this.elementToReturn;
            return e;
        }
        finally {
            this.offset = 0;
            this.accessed = Accessed.PREVIOUS;
            this.elementToReturn = null;
            ++this.index;
        }
    }

    @Override
    public boolean hasPrevious() {
        E element;
        if (this.elementToReturn != null && this.offset < 0) {
            return true;
        }
        this.elementToReturn = null;
        while (this.offset > 0) {
            this.listIterator.previous();
            --this.offset;
        }
        do {
            if (!this.listIterator.hasPrevious()) {
                return false;
            }
            element = this.listIterator.previous();
            --this.offset;
        } while (!this.filter.accept(element));
        this.elementToReturn = element;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E previous() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        try {
            E e = this.elementToReturn;
            return e;
        }
        finally {
            this.offset = 0;
            this.accessed = Accessed.NEXT;
            this.elementToReturn = null;
            --this.index;
        }
    }

    @Override
    public int nextIndex() {
        return this.index;
    }

    @Override
    public int previousIndex() {
        return this.index - 1;
    }

    @Override
    public void remove() {
        this.moveBack();
        this.accessed.moveForward(this.listIterator);
        if (this.accessed == Accessed.PREVIOUS) {
            --this.index;
        }
        this.listIterator.remove();
        this.accessed = Accessed.NONE;
        this.elementToReturn = null;
    }

    @Override
    public void set(E e) {
        this.moveBack();
        this.accessed.moveBackAndForth(this.listIterator);
        this.listIterator.set(e);
    }

    private void moveBack() {
        while (this.offset > 0) {
            this.listIterator.previous();
            --this.offset;
        }
        while (this.offset < 0) {
            this.listIterator.next();
            ++this.offset;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Accessed {
        NONE(false){

            @Override
            void moveForward(ListIterator<?> listIterator) {
                throw new IllegalStateException();
            }

            @Override
            void moveBackward(ListIterator<?> listIterator) {
                throw new IllegalStateException();
            }
        }
        ,
        NEXT(true){

            @Override
            void moveForward(ListIterator<?> listIterator) {
                listIterator.next();
            }

            @Override
            void moveBackward(ListIterator<?> listIterator) {
                listIterator.previous();
            }
        }
        ,
        PREVIOUS(true){

            @Override
            void moveForward(ListIterator<?> listIterator) {
                listIterator.previous();
            }

            @Override
            void moveBackward(ListIterator<?> listIterator) {
                listIterator.next();
            }
        };

        final boolean exists;

        private Accessed(boolean accessed) {
            this.exists = accessed;
        }

        abstract void moveForward(ListIterator<?> var1);

        abstract void moveBackward(ListIterator<?> var1);

        void moveBackAndForth(ListIterator<?> listIterator) {
            this.moveForward(listIterator);
            this.moveBackward(listIterator);
        }
    }
}

