/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Partition<E> {
    private Partition<?> parent;
    private int rank;
    private final E value;

    private Partition(E value) {
        this.value = value;
        this.parent = this;
    }

    public static <E> Partition<E> singleton(E value) {
        return new Partition<E>(value);
    }

    public E value() {
        return this.value;
    }

    public Partition<?> merge(Partition<?> other) {
        Partition<?> root1 = other.find();
        Partition<?> root2 = this.find();
        if (root1.rank < root2.rank) {
            root1.parent = root2;
            return root2;
        }
        if (root1.rank > root2.rank) {
            root2.parent = root1;
            return root1;
        }
        root2.parent = root1;
        ++root1.rank;
        return root1;
    }

    public Partition<?> find() {
        Partition<?> current = this;
        Partition<?> last = this;
        while (current.parent != current) {
            last.parent = current.parent;
            last = current;
            current = current.parent;
        }
        return current;
    }

    public static boolean areMerged(Partition<?> partition1, Partition<?> partition2) {
        return partition1.find() == partition2.find();
    }
}

