/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.util;

import gr.forth.ics.util.Args;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandomChooser<T> {
    private final double totalProb;
    private final List<Double> probs;
    private final List<T> choices;
    private final Random random;

    private RandomChooser(double totalProb, List<Double> probs, List<T> events, Random random) {
        this.totalProb = totalProb;
        this.probs = new ArrayList<Double>(probs);
        this.choices = new ArrayList<T>(events);
        this.random = random;
    }

    public T choose() {
        double next = this.random.nextDouble() * this.totalProb;
        for (int i = 0; i < this.probs.size(); ++i) {
            if (!((next -= this.probs.get(i).doubleValue()) < 0.0)) continue;
            return this.choices.get(i);
        }
        return this.choices.get(this.choices.size() - 1);
    }

    public static <T> RandomChooserBuilder<T> newInstance() {
        return new RandomChooserBuilder();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RandomChooserBuilder<T> {
        private double totalProb;
        private final List<Double> probs = new ArrayList<Double>();
        private final List<T> events = new ArrayList<T>();
        private Random random = new Random(0L);

        public RandomChooserBuilder<T> choice(double prob, T choice) {
            Args.gte(prob, 0.0);
            Args.notNull(choice);
            this.probs.add(prob);
            this.events.add(choice);
            this.totalProb += prob;
            return this;
        }

        public RandomChooserBuilder<T> setRandom(Random random) {
            this.random = random;
            return this;
        }

        public RandomChooser<T> build() {
            return new RandomChooser(this.totalProb, this.probs, this.events, this.random);
        }
    }
}

