/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.swkm.model2;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Maps;
import gr.forth.ics.graph.Graph;
import gr.forth.ics.graph.Node;
import gr.forth.ics.graph.concrete.PrimaryGraph;
import gr.forth.ics.swkm.model2.Model;
import gr.forth.ics.swkm.model2.RdfNode;
import gr.forth.ics.swkm.model2.RdfType;
import gr.forth.ics.swkm.model2.Resource;
import gr.forth.ics.swkm.model2.Triple;
import gr.forth.ics.swkm.model2.Uri;
import gr.forth.ics.swkm.vocabulary.Rdf;
import gr.forth.ics.swkm.vocabulary.RdfSchema;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphUtils {
    public static RdfGraph toGraph(Model model, Uri ... properties) {
        return GraphUtils.toGraph(model, (Predicate<Triple>)Predicates.alwaysTrue(), properties);
    }

    public static RdfGraph toGraph(Model model, Predicate<Triple> tripleFilter, Uri ... properties) {
        HashMap map = Maps.newHashMap();
        PrimaryGraph graph = new PrimaryGraph();
        for (Uri property : properties) {
            for (Triple t : model.triples().p(property).fetch()) {
                if (!tripleFilter.apply((Object)t)) continue;
                Node subject = GraphUtils.getOrCreateMapped(t.subject(), (Graph)graph, map);
                Node object = GraphUtils.getOrCreateMapped(t.object(), (Graph)graph, map);
                graph.newEdge(subject, object, (Object)t);
            }
        }
        return new RdfGraph((Graph)graph, map);
    }

    static Graph classesAndInstancesGraph(Model model) {
        return GraphUtils.toGraph(model, RdfSchema.SUBCLASSOF, Rdf.TYPE).graph();
    }

    static Graph propertiesAndInstancesGraph(Model model) {
        HashMap propertiesMap = Maps.newHashMap();
        HashMap instancesMap = Maps.newHashMap();
        PrimaryGraph graph = new PrimaryGraph();
        Resource subPropertyOf = model.mapResource(RdfSchema.SUBPROPERTYOF);
        for (RdfNode node : model.findNodes(RdfType.PROPERTY)) {
            Resource property = (Resource)node;
            Node propertyNode = GraphUtils.getOrCreateMapped(node, (Graph)graph, propertiesMap);
            for (Triple triple : model.triples().p(property).fetch()) {
                Pair<RdfNode> instance = new Pair<RdfNode>(triple.subject(), triple.object());
                Node instanceNode = GraphUtils.getOrCreateMapped(instance, (Graph)graph, instancesMap);
                graph.newEdge(instanceNode, propertyNode, (Object)triple);
            }
            for (Triple triple : model.triples().s(property).p(subPropertyOf).fetch()) {
                Node superPropertyNode = GraphUtils.getOrCreateMapped(triple.object(), (Graph)graph, propertiesMap);
                graph.newEdge(propertyNode, superPropertyNode, (Object)triple);
            }
        }
        return graph;
    }

    private static <T> Node getOrCreateMapped(T key, Graph graph, Map<T, Node> map) {
        Node node = map.get(key);
        if (node == null) {
            node = graph.newNode(key);
            map.put(key, node);
        }
        return node;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RdfGraph {
        private final Graph graph;
        private final Map<RdfNode, Node> map;

        public RdfGraph(Graph graph, Map<RdfNode, Node> map) {
            this.graph = graph;
            this.map = map;
        }

        public Graph graph() {
            return this.graph;
        }

        public Map<RdfNode, Node> nodeMap() {
            return this.map;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Pair<E> {
        private final E one;
        private final E two;

        Pair(E one, E two) {
            this.one = one;
            this.two = two;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Pair other = (Pair)obj;
            if (this.one != other.one) {
                return false;
            }
            return this.two == other.two;
        }

        public int hashCode() {
            int hash = 5;
            hash = 37 * hash + this.one.hashCode();
            hash = 37 * hash + this.two.hashCode();
            return hash;
        }

        public String toString() {
            return "[" + this.one + ", " + this.two + "]";
        }
    }
}

