/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.swkm.model2;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import gr.forth.ics.graph.Edge;
import gr.forth.ics.graph.Graph;
import gr.forth.ics.graph.InspectableGraph;
import gr.forth.ics.graph.Node;
import gr.forth.ics.graph.algo.transitivity.Closure;
import gr.forth.ics.graph.algo.transitivity.PathFinder;
import gr.forth.ics.graph.algo.transitivity.SuccessorSetFactory;
import gr.forth.ics.graph.algo.transitivity.Transitivity;
import gr.forth.ics.graph.event.EdgeListener;
import gr.forth.ics.graph.event.EmptyGraphListener;
import gr.forth.ics.graph.event.GraphEvent;
import gr.forth.ics.swkm.model2.GraphUtils;
import gr.forth.ics.swkm.model2.Model;
import gr.forth.ics.swkm.model2.ModelImpl;
import gr.forth.ics.swkm.model2.ObjectNode;
import gr.forth.ics.swkm.model2.RdfNode;
import gr.forth.ics.swkm.model2.Resource;
import gr.forth.ics.swkm.model2.Triple;
import gr.forth.ics.swkm.model2.Uri;
import gr.forth.ics.swkm.vocabulary.Rdf;
import gr.forth.ics.swkm.vocabulary.RdfSchema;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Inference {
    private static final Function<Edge, Triple> edgeToTriple = new Function<Edge, Triple>(){

        public Triple apply(Edge edge) {
            return (Triple)edge.getValue();
        }
    };

    public static void reduce(Model model) {
        ArrayList<Triple> triplesToRemove = new ArrayList<Triple>();
        Graph subClassGraph = GraphUtils.classesAndInstancesGraph(model);
        LabelingPathFinder pathFinder = ((ModelImpl)model).getLabelManager().areLabelsAvailable() ? new LabelingPathFinder(model) : null;
        Iterables.addAll(triplesToRemove, Inference.reduce(subClassGraph, pathFinder != null ? pathFinder : Transitivity.acyclicClosure((InspectableGraph)subClassGraph, (SuccessorSetFactory)SuccessorSetFactory.intervalBased((InspectableGraph)subClassGraph))));
        Graph subPropertyGraph = GraphUtils.propertiesAndInstancesGraph(model);
        pathFinder = ((ModelImpl)model).getLabelManager().areLabelsAvailable() ? new LabelingPathFinder(model) : null;
        Iterables.addAll(triplesToRemove, Inference.reduce(subPropertyGraph, pathFinder != null ? pathFinder : Transitivity.acyclicClosure((InspectableGraph)subPropertyGraph, (SuccessorSetFactory)SuccessorSetFactory.intervalBased((InspectableGraph)subPropertyGraph))));
        model.delete(triplesToRemove);
    }

    private static Iterable<Triple> reduce(Graph graph, PathFinder pathFinder) {
        final ArrayList removedEdges = new ArrayList();
        EmptyGraphListener listener = new EmptyGraphListener(){

            public void edgeRemoved(GraphEvent e) {
                removedEdges.add(e.getEdge());
            }
        };
        graph.addEdgeListener((EdgeListener)listener);
        Transitivity.acyclicReduction((Graph)graph, (PathFinder)pathFinder);
        graph.removeEdgeListener((EdgeListener)listener);
        return Iterables.transform(removedEdges, edgeToTriple);
    }

    public static void closure(Model model) {
        Graph g = GraphUtils.toGraph(model, RdfSchema.SUBCLASSOF).graph();
        Closure closure = Transitivity.acyclicClosure((InspectableGraph)g, (SuccessorSetFactory)SuccessorSetFactory.intervalBased((InspectableGraph)g));
        Inference.materializeSubsumptionInference(g, closure, model, RdfSchema.SUBCLASSOF);
        Inference.materializeTypeInference(g, model, closure);
        g = GraphUtils.toGraph(model, RdfSchema.SUBPROPERTYOF).graph();
        closure = Transitivity.acyclicClosure((InspectableGraph)g, (SuccessorSetFactory)SuccessorSetFactory.intervalBased((InspectableGraph)g));
        Inference.materializeSubsumptionInference(g, closure, model, RdfSchema.SUBPROPERTYOF);
        Inference.materializePropertyInstanceInference(g, model, closure);
    }

    private static void materializePropertyInstanceInference(Graph g, Model model, Closure closure) {
        for (Node n1 : g.nodes()) {
            Resource property = (Resource)n1.getValue();
            for (Triple triple : model.triples().p(property).fetch()) {
                for (Node propAnc : closure.successorsOf(n1)) {
                    ObjectNode subj = triple.subject();
                    RdfNode obj = triple.object();
                    model.add().s(subj).p((Resource)propAnc.getValue()).o(obj);
                }
            }
        }
    }

    private static void materializeSubsumptionInference(Graph g, Closure closure, Model model, Uri property) {
        Resource p = model.mapResource(property);
        for (Node n1 : g.nodes()) {
            Resource rdfNodeSub = (Resource)n1.getValue();
            for (Node n2 : closure.successorsOf(n1)) {
                Resource rdfNodeObj = (Resource)n2.getValue();
                model.add().s(rdfNodeSub).p(p).o(rdfNodeObj);
            }
        }
    }

    private static void materializeTypeInference(Graph g, Model model, Closure closure) {
        Resource p = model.mapResource(Rdf.TYPE);
        for (Node n : g.nodes()) {
            Resource node = (Resource)n.getValue();
            for (ObjectNode instance : model.triples().p(p).o(node).fetch().subjects()) {
                for (Node anc : closure.successorsOf(n)) {
                    model.add().s(instance).p(p).o((RdfNode)anc.getValue());
                }
            }
        }
    }

    private static class LabelingPathFinder
    implements PathFinder {
        private final Model model;

        LabelingPathFinder(Model model) {
            this.model = model;
        }

        public boolean pathExists(Node n1, Node n2) {
            RdfNode node1 = (RdfNode)n1.getValue();
            RdfNode node2 = (RdfNode)n2.getValue();
            return node1.asInheritable().isDescendantOf(node2.asInheritable());
        }
    }
}

