/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.swkm.model2;

import com.google.common.base.Objects;
import gr.forth.ics.swkm.model2.Uri;
import gr.forth.ics.swkm.model2.XmlDatatypeUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.Assert;

public class Literal {
    private final String value;
    private final String lang;
    private final Uri type;
    private static final Pattern literalPattern = Pattern.compile("\\s*\"(.*?)\"(?:(?:@(.*))|(?:\\^\\^(.*)))?", 32);

    Literal(String value, String lang, Uri type) {
        Assert.notNull((Object)value, (String)"value");
        Assert.isTrue((lang == null || type == null ? 1 : 0) != 0, (String)"Cannot set both lang and type");
        this.value = value;
        this.lang = lang;
        this.type = type;
    }

    public String getValue() {
        return this.value;
    }

    public boolean hasLanguage() {
        return this.lang != null;
    }

    public String getLanguage() {
        return this.lang;
    }

    public boolean hasType() {
        return this.type != null;
    }

    public Uri getType() {
        return this.type;
    }

    public boolean validateCharacters() {
        int i;
        for (i = 0; i < this.value.length(); ++i) {
            if (Literal.validateCharacter(this.value.charAt(i))) continue;
            return false;
        }
        if (this.lang != null) {
            for (i = 0; i < this.lang.length(); ++i) {
                if (Literal.validateCharacter(this.lang.charAt(i))) continue;
                return false;
            }
        }
        if (this.type != null) {
            return this.type.validateCharacters();
        }
        return true;
    }

    private static boolean validateCharacter(char c) {
        if (c >= '\u0010' && c <= '\uffff') {
            return true;
        }
        return c == '\t';
    }

    public String toString() {
        if (this.hasLanguage()) {
            return "\"" + this.value + "\"@" + this.getLanguage();
        }
        if (this.hasType()) {
            return "\"" + this.value + "\"^^" + this.getType();
        }
        return "\"" + this.value + "\"";
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.value, this.lang, this.type});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Literal)) {
            return false;
        }
        Literal other = (Literal)obj;
        return this.value.equals(other.value) && Objects.equal((Object)this.lang, (Object)other.lang) && Objects.equal((Object)this.type, (Object)other.type);
    }

    public static Literal parse(String literal) {
        Assert.notNull((Object)literal);
        Matcher m = literalPattern.matcher(literal);
        if (!m.find()) {
            throw new LiteralFormatException("Unparsable literal: [" + literal + "], expected forms: \"value\" or \"value\"@lang or " + "\"value\"^^type");
        }
        String value = m.group(1);
        String lang = m.group(2);
        String type = m.group(3);
        return Literal.newLiteral(value, lang, type);
    }

    public static Literal tryParse(String literal) {
        if (literal == null) {
            return null;
        }
        Matcher m = literalPattern.matcher(literal);
        if (m.matches()) {
            String value = m.group(1);
            String lang = m.group(2);
            String type = m.group(3);
            return Literal.newLiteral(value, lang, type);
        }
        return null;
    }

    private static Literal newLiteral(String value, String lang, String type) {
        return new Literal(value, lang, type != null ? Uri.parse(type) : null);
    }

    public static Literal create(String value) {
        Assert.notNull((Object)value);
        return new Literal(value, null, null);
    }

    public static Literal createWithLanguage(String value, String lang) {
        Assert.notNull((Object)value);
        return new Literal(value, lang, null);
    }

    public static Literal createWithType(String value, Uri type) {
        Assert.notNull((Object)value);
        return new Literal(value, null, type);
    }

    public boolean isValid() {
        if (this.type == null) {
            return true;
        }
        return XmlDatatypeUtil.isValidValue(this.value, this.type);
    }

    public static class LiteralFormatException
    extends RuntimeException {
        public LiteralFormatException(Throwable cause) {
            super(cause);
        }

        public LiteralFormatException(String message, Throwable cause) {
            super(message, cause);
        }

        public LiteralFormatException(String message) {
            super(message);
        }

        public LiteralFormatException() {
        }
    }
}

