/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.swkm.model2;

import com.google.common.base.Preconditions;
import gr.forth.ics.swkm.model2.Model;
import gr.forth.ics.swkm.model2.ModelImpl;
import gr.forth.ics.swkm.model2.Uri;
import gr.forth.ics.swkm.model2.index.ModelIndexer;
import gr.forth.ics.swkm.model2.index.ModelIndexers;
import gr.forth.ics.swkm.vocabulary.RdfSuite;

public class ModelBuilder {
    private final ModelIndexer index;
    private Uri defaultUri = RdfSuite.DEFAULT_GRAPH_URI;

    private ModelBuilder(ModelIndexer index) {
        this.index = index;
    }

    public static ModelBuilder newSparse() {
        return new ModelBuilder(ModelIndexers.createNodeListsModelIndexer());
    }

    public static ModelBuilder newRefImpl() {
        return new ModelBuilder(ModelIndexers.createReferenceImplementation());
    }

    public static ModelBuilder newMultimaps() {
        return new ModelBuilder(ModelIndexers.createMultimapsModelIndexer());
    }

    public static ModelBuilder newTrees() {
        return new ModelBuilder(ModelIndexers.createTreeMapModelIndexer());
    }

    public ModelBuilder setDefaultUri(Uri defaultUri) {
        this.defaultUri = (Uri)Preconditions.checkNotNull((Object)defaultUri);
        return this;
    }

    public Model build() {
        return new ModelImpl(this.index, this.defaultUri);
    }
}

