/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.swkm.model2;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import gr.forth.ics.swkm.model2.BlankNode;
import gr.forth.ics.swkm.model2.BlankNodeImpl;
import gr.forth.ics.swkm.model2.Literal;
import gr.forth.ics.swkm.model2.LiteralNode;
import gr.forth.ics.swkm.model2.LiteralNodeImpl;
import gr.forth.ics.swkm.model2.Model;
import gr.forth.ics.swkm.model2.NodeTypingEngine;
import gr.forth.ics.swkm.model2.ObjectNode;
import gr.forth.ics.swkm.model2.ObjectNodeImpl;
import gr.forth.ics.swkm.model2.RdfNode;
import gr.forth.ics.swkm.model2.RdfNodeImpl;
import gr.forth.ics.swkm.model2.RdfType;
import gr.forth.ics.swkm.model2.Resource;
import gr.forth.ics.swkm.model2.ResourceImpl;
import gr.forth.ics.swkm.model2.Triple;
import gr.forth.ics.swkm.model2.TripleImpl;
import gr.forth.ics.swkm.model2.Triples;
import gr.forth.ics.swkm.model2.Uri;
import gr.forth.ics.swkm.model2.event.RdfNodeListener;
import gr.forth.ics.swkm.model2.event.TripleListener;
import gr.forth.ics.swkm.model2.event.TypeChange;
import gr.forth.ics.swkm.model2.index.ModelIndexer;
import gr.forth.ics.swkm.model2.index.ModelView;
import gr.forth.ics.swkm.model2.index.ObjectViewSupport;
import gr.forth.ics.swkm.model2.index.TripleDeletionListener;
import gr.forth.ics.swkm.model2.labels.LabelManager;
import gr.forth.ics.swkm.model2.labels.LabelManagers;
import gr.forth.ics.swkm.model2.labels.Labelers;
import gr.forth.ics.swkm.model2.labels.PredefinedLabels;
import gr.forth.ics.swkm.vocabulary.Rdf;
import gr.forth.ics.swkm.vocabulary.RdfSchema;
import gr.forth.ics.swkm.vocabulary.RdfSuite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelImpl
implements Model {
    private final Map<Literal, LiteralNodeImpl> literals = new MapMaker().weakValues().makeMap();
    private final Map<Uri, ResourceImpl> resources = new MapMaker().weakValues().makeMap();
    private final Map<String, BlankNodeImpl> blankNodes = new MapMaker().weakValues().makeMap();
    private final Map<Set<ResourceImpl>, Set<ResourceImpl>> usedGraphsCombinations;
    private final RdfNodeListenerSupport rdfNodeListenerSupport = new RdfNodeListenerSupport();
    private final TripleListenerSupport tripleListenerSupport = new TripleListenerSupport();
    private final ModelIndexer indexer;
    private final ObjectViewSupport objectViewSupport;
    private final Resource defaultNamedGraph;
    private LabelManager labelManager;
    private static final Predicate<RdfNode> isActiveNode = new Predicate<RdfNode>(){

        public boolean apply(RdfNode node) {
            return node.hasTriples();
        }
    };

    ModelImpl(ModelIndexer indexer) {
        this(indexer, RdfSuite.DEFAULT_GRAPH_URI);
    }

    ModelImpl(ModelIndexer indexer, Uri defaultNamedGraphUri) {
        this.indexer = (ModelIndexer)Preconditions.checkNotNull((Object)indexer);
        this.defaultNamedGraph = this.mapResource((Uri)Preconditions.checkNotNull((Object)defaultNamedGraphUri));
        indexer.setModelView(new ModelViewImpl());
        indexer.setModel(this);
        this.objectViewSupport = indexer.objectViewSupport();
        this.labelManager = new LabelManagers.NonIncrementalMainMemoryManager(this, Labelers.newDefault());
        this.usedGraphsCombinations = new HashMap<Set<ResourceImpl>, Set<ResourceImpl>>();
    }

    @Override
    public Resource defaultNamedGraph() {
        return this.defaultNamedGraph;
    }

    final ObjectViewSupport objectViewSupport() {
        return this.objectViewSupport;
    }

    void handleTypeChange(RdfNodeImpl node, RdfType oldType, List<TypeChange> stack) {
        TypeChange typeChange = stack.isEmpty() ? null : stack.get(stack.size() - 1);
        node.setIndex(this.indexer.indexFor(node, typeChange));
        if (node.type() == oldType) {
            return;
        }
        this.rdfNodeListenerSupport.fireTypeChange(node, oldType, stack);
    }

    @Override
    public boolean delete(Triple triple) {
        return this.deleteTriple((TripleImpl)triple, true);
    }

    @Override
    public boolean delete(Iterable<Triple> triplesToRemove) {
        return this.deleteTriples(triplesToRemove, true);
    }

    private boolean deleteTriples(Iterable<Triple> triplesToRemove, boolean notifyIndexer) {
        boolean changed = false;
        for (Triple triple : triplesToRemove) {
            changed |= this.deleteTriple((TripleImpl)triple, notifyIndexer);
        }
        return changed;
    }

    private boolean deleteTriple(TripleImpl t, boolean notifyIndexer) {
        if (notifyIndexer && !this.indexer.containsTriple(t)) {
            return false;
        }
        this.decrementCounters(t);
        Set<ResourceImpl> graphs = t.namedGraphs;
        t.namedGraphs = Collections.emptySet();
        for (ResourceImpl namedGraph : graphs) {
            namedGraph.decrementCounter();
            this.tripleListenerSupport.fireTripleDeletion(namedGraph, t);
        }
        if (notifyIndexer) {
            this.indexer.delete(t);
        }
        this.labelManager.tripleDeleted(t);
        return true;
    }

    @Override
    public void retypeNodes() {
        ArrayList allResources = Lists.newArrayListWithCapacity((int)(this.blankNodes.size() + this.resources.size()));
        for (ObjectNodeImpl objectNode : Iterables.concat(this.blankNodes.values(), this.resources.values())) {
            if (objectNode.hasConstantType() || !objectNode.hasTriples()) continue;
            allResources.add(objectNode);
            objectNode.clearType();
        }
        for (ObjectNodeImpl resource : allResources) {
            resource.reclassify();
        }
    }

    @Override
    public Model.AddContext add() {
        return new TripleBuilder();
    }

    @Override
    public Triple add(Resource namedGraph, ObjectNode subject, Resource predicate, RdfNode object) {
        if (namedGraph == null) {
            namedGraph = this.mapResource(RdfSuite.DEFAULT_GRAPH_URI);
        }
        return this.addQuad(namedGraph, subject, predicate, object);
    }

    TripleImpl addQuad(Resource namedGraph, ObjectNode subject, Resource predicate, RdfNode object) {
        TripleImpl triple = this.getOrCreateTriple(subject, predicate, object);
        ResourceImpl ng = (ResourceImpl)namedGraph;
        NodeTypingEngine.makeNamedGraph(ng, triple);
        if (triple.namedGraphs.contains(ng)) {
            return triple;
        }
        this.incrementCounters(ng, triple);
        this.addNamedGraph(ng, triple);
        this.indexer.add(namedGraph, triple);
        this.tripleListenerSupport.fireTripleAddition(namedGraph, triple);
        triple.inferTypesOfParts();
        this.labelManager.tripleAdded(triple);
        return triple;
    }

    private void addNamedGraph(ResourceImpl ng, TripleImpl triple) {
        this.updateNamedGraph(true, ng, triple);
    }

    private void removeNamedGraph(ResourceImpl ng, TripleImpl triple) {
        this.updateNamedGraph(false, ng, triple);
        ng.decrementCounter();
    }

    private void updateNamedGraph(boolean add, ResourceImpl ng, TripleImpl triple) {
        HashSet<ResourceImpl> namedGraphs = new HashSet<ResourceImpl>(triple.namedGraphs);
        if (add) {
            namedGraphs.add(ng);
        } else {
            namedGraphs.remove(ng);
        }
        Set<ResourceImpl> usedSet = this.usedGraphsCombinations.get(namedGraphs);
        if (usedSet == null) {
            this.usedGraphsCombinations.put(namedGraphs, namedGraphs);
            usedSet = namedGraphs;
        }
        triple.namedGraphs = usedSet;
    }

    private TripleImpl getOrCreateTriple(ObjectNode subject, Resource predicate, RdfNode object) {
        this.checkOwned(subject, true);
        this.checkOwned(predicate, true);
        this.checkOwned(object, true);
        Iterator<Triple> iterator = this.indexer.findTriples(null, subject, predicate, object).iterator();
        return iterator.hasNext() ? (TripleImpl)iterator.next() : new TripleImpl((ObjectNodeImpl)subject, (ResourceImpl)predicate, (RdfNodeImpl)object);
    }

    @Override
    public LiteralNode mapLiteral(Literal literal) {
        Assert.notNull((Object)literal);
        LiteralNodeImpl literalNode = this.literals.get(literal);
        if (literalNode == null) {
            literalNode = new LiteralNodeImpl(this, literal);
            this.handleTypeChange(literalNode, RdfType.UNKNOWN, Collections.<TypeChange>emptyList());
            this.literals.put(literal, literalNode);
        }
        return literalNode;
    }

    @Override
    public LiteralNode mapLiteral(String literal) {
        return this.mapLiteral(Literal.parse(literal));
    }

    @Override
    public BlankNode mapBlankNode(String id) {
        Assert.notNull((Object)id);
        BlankNodeImpl blankNode = this.blankNodes.get(id);
        if (blankNode == null) {
            blankNode = new BlankNodeImpl(this, id);
            this.handleTypeChange(blankNode, RdfType.UNKNOWN, Collections.<TypeChange>emptyList());
            this.blankNodes.put(id, blankNode);
        }
        return blankNode;
    }

    @Override
    public Resource mapResource(Uri uri) {
        Assert.notNull((Object)uri);
        ResourceImpl resource = this.resources.get(uri);
        if (resource == null) {
            resource = new ResourceImpl(this, uri);
            this.handleTypeChange(resource, RdfType.UNKNOWN, Collections.<TypeChange>emptyList());
            this.resources.put(uri, resource);
        }
        return resource;
    }

    @Override
    public Resource mapResource(String uri) {
        return this.mapResource(Uri.parse(uri));
    }

    @Override
    public ObjectNode mapObjectNode(String uriOrId) {
        Uri uri = Uri.tryParse(uriOrId);
        if (uri == null) {
            return this.mapBlankNode(uriOrId);
        }
        ObjectNode node = this.resources.get(uri);
        if (node != null) {
            return node;
        }
        node = this.blankNodes.get(uriOrId);
        if (node != null) {
            return node;
        }
        return this.mapResource(uri);
    }

    @Override
    public RdfNode map(String uriOrIdOrLiteral) {
        Literal literal = Literal.tryParse(uriOrIdOrLiteral);
        if (literal != null) {
            return this.mapLiteral(literal);
        }
        return this.mapObjectNode(uriOrIdOrLiteral);
    }

    private boolean checkOwned(RdfNode node, boolean throwException) {
        if (node == null) {
            if (!throwException) {
                return false;
            }
            throw new IllegalArgumentException("null");
        }
        if (node.owner() != this) {
            if (!throwException) {
                return false;
            }
            throw new IllegalArgumentException("Object [" + node + "] is not owned by this " + Model.class.getSimpleName());
        }
        return true;
    }

    @Override
    public Model.QueryBuilder triples() {
        return new QueryBuilderImpl();
    }

    @Override
    public Iterable<RdfNode> findNodes(RdfType type) {
        return this.indexer.find((RdfType)((Object)Preconditions.checkNotNull((Object)((Object)type))));
    }

    @Override
    public Iterable<RdfNode> findNodes(RdfType ... types) {
        LinkedList iterables = Lists.newLinkedList();
        for (RdfType type : types) {
            iterables.add(this.findNodes(type));
        }
        return Iterables.concat((Iterable)iterables);
    }

    @Override
    public Iterable<Resource> findNodes(Uri namespace, RdfType type) {
        return this.indexer.findInNamespace((RdfType)((Object)Preconditions.checkNotNull((Object)((Object)type))), (Uri)Preconditions.checkNotNull((Object)namespace));
    }

    @Override
    public Iterable<Resource> findNodes(Uri namespace, RdfType ... types) {
        LinkedList iterables = Lists.newLinkedList();
        for (RdfType type : types) {
            iterables.add(this.findNodes(namespace, type));
        }
        return Iterables.concat((Iterable)iterables);
    }

    @Override
    public Iterable<Resource> namedGraphs() {
        return this.indexer.find(RdfType.NAMED_GRAPH);
    }

    @Override
    public Iterable<Resource> resources() {
        return Iterables.filter(this.resources.values(), isActiveNode);
    }

    @Override
    public Iterable<LiteralNode> literals() {
        return Iterables.filter(this.literals.values(), isActiveNode);
    }

    @Override
    public Iterable<BlankNode> blankNodes() {
        return Iterables.filter(this.blankNodes.values(), isActiveNode);
    }

    @Override
    public Set<Uri> namespaces() {
        return this.indexer.namespaces();
    }

    @Override
    public boolean isInferable(ObjectNode s, Resource p, RdfNode o) {
        this.checkOwned(s, true);
        this.checkOwned(p, true);
        this.checkOwned(o, true);
        if (this.triples().s(s).p(p).o(o).fetch().iterator().hasNext()) {
            return true;
        }
        if (p.is(RdfSchema.SUBCLASSOF) || p.is(RdfSchema.SUBPROPERTYOF)) {
            return s.asInheritable().isDescendantOf(o);
        }
        if (p.is(Rdf.TYPE)) {
            for (RdfNode type : this.triples().s(s).p(p).fetch().objects()) {
                if (!type.asInheritable().isDescendantOf(o)) continue;
                return true;
            }
        } else {
            for (Resource predicate : this.triples().s(s).o(o).fetch().predicates()) {
                if (!predicate.asInheritable().isDescendantOf(p)) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(512);
        for (Triple t : this.triples().fetch()) {
            sb.append(t).append("\n");
        }
        return sb.toString();
    }

    private void incrementCounters(ResourceImpl namedGraph, TripleImpl triple) {
        namedGraph.incrementCounter();
        triple.subject().incrementCounter();
        triple.predicate().incrementCounter();
        triple.object().incrementCounter();
    }

    private void decrementCounters(TripleImpl triple) {
        triple.subject().decrementCounter();
        triple.predicate().decrementCounter();
        triple.object().decrementCounter();
    }

    void onDeletedNode(RdfNodeImpl node) {
        this.rdfNodeListenerSupport.fireNodeDeletion(node);
    }

    void onAddedNode(RdfNodeImpl node) {
        this.rdfNodeListenerSupport.fireNodeAddition(node);
    }

    @Override
    public void setLabelManager(LabelManager labelManager) {
        if (labelManager == null) {
            throw new NullPointerException();
        }
        if (labelManager.getTargetModel() != this) {
            throw new IllegalArgumentException("The specified label manager does not target this model");
        }
        this.labelManager = labelManager;
    }

    LabelManager getLabelManager() {
        return this.labelManager;
    }

    @Override
    public void updateLabels() {
        this.labelManager.updateLabels(PredefinedLabels.swkmPredefinedLabels());
    }

    @Override
    public void updateLabels(PredefinedLabels predefinedLabels) {
        this.labelManager.updateLabels(PredefinedLabels.swkmPredefinedLabels().merge(predefinedLabels));
    }

    @Override
    public void addRdfNodeListener(RdfNodeListener rdfNodeListener) {
        this.rdfNodeListenerSupport.addRdfNodeListener(rdfNodeListener);
    }

    @Override
    public void removeRdfNodeListener(RdfNodeListener rdfNodeListener) {
        this.rdfNodeListenerSupport.removeRdfNodeListener(rdfNodeListener);
    }

    @Override
    public void addTripleListener(TripleListener tripleListener) {
        this.tripleListenerSupport.addTripleListener(tripleListener);
    }

    @Override
    public void removeTripleListener(TripleListener tripleListener) {
        this.tripleListenerSupport.removeTripleListener(tripleListener);
    }

    @Override
    public int tripleCount() {
        return this.indexer.tripleCount();
    }

    private static class TripleListenerSupport {
        private final List<TripleListener> listeners = new ArrayList<TripleListener>(0);

        private TripleListenerSupport() {
        }

        private void addTripleListener(TripleListener typeListener) {
            this.listeners.add((TripleListener)Preconditions.checkNotNull((Object)typeListener));
        }

        private void removeTripleListener(TripleListener typeListener) {
            this.listeners.remove(typeListener);
        }

        void fireTripleAddition(Resource namedGraph, Triple triple) {
            for (TripleListener listener : this.listeners) {
                listener.onTripleAddition(namedGraph, triple);
            }
        }

        void fireTripleDeletion(Resource namedGraph, Triple triple) {
            for (TripleListener listener : this.listeners) {
                listener.onTripleDeletion(namedGraph, triple);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RdfNodeListenerSupport {
        private final List<RdfNodeListener> listeners = new ArrayList<RdfNodeListener>(0);

        private RdfNodeListenerSupport() {
        }

        private void addRdfNodeListener(RdfNodeListener typeListener) {
            this.listeners.add((RdfNodeListener)Preconditions.checkNotNull((Object)typeListener));
        }

        private void removeRdfNodeListener(RdfNodeListener typeListener) {
            this.listeners.remove(typeListener);
        }

        void fireTypeChange(RdfNode node, RdfType oldType, List<TypeChange> stack) {
            for (RdfNodeListener listener : this.listeners) {
                listener.onTypeChange(node, oldType, stack);
            }
        }

        void fireNodeDeletion(RdfNode node) {
            for (RdfNodeListener listener : this.listeners) {
                listener.onNodeDeletion(node);
            }
        }

        void fireNodeAddition(RdfNode node) {
            for (RdfNodeListener listener : this.listeners) {
                listener.onNodeAddition(node);
            }
        }
    }

    private class TripleBuilder
    implements Model.AddContext,
    Model.AddSubject,
    Model.AddPredicate,
    Model.AddObject {
        private Resource namedGraph;
        private ObjectNode subject;
        private Resource predicate;
        private RdfNode object;

        private TripleBuilder() {
        }

        public Model.AddSubject g(Resource namedGraph) {
            ModelImpl.this.checkOwned(namedGraph, true);
            this.namedGraph = namedGraph;
            return this;
        }

        public Model.AddSubject g(Uri uri) {
            return this.g(ModelImpl.this.mapResource(uri));
        }

        public Model.AddSubject g(String uri) {
            return this.g(ModelImpl.this.mapResource(Uri.parse(uri)));
        }

        public Model.AddPredicate s(ObjectNode subject) {
            ModelImpl.this.checkOwned(subject, true);
            this.subject = subject;
            return this;
        }

        public Model.AddPredicate s(Uri uri) {
            return this.s(ModelImpl.this.mapResource(uri));
        }

        public Model.AddPredicate s(String uriOrId) {
            return this.s(ModelImpl.this.mapObjectNode(uriOrId));
        }

        public Model.AddObject p(Resource predicate) {
            ModelImpl.this.checkOwned(predicate, true);
            this.predicate = predicate;
            return this;
        }

        public Model.AddObject p(Uri uri) {
            return this.p(ModelImpl.this.mapResource(uri));
        }

        public Model.AddObject p(String uri) {
            return this.p(ModelImpl.this.mapResource(Uri.parse(uri)));
        }

        public Triple o(RdfNode object) {
            ModelImpl.this.checkOwned(object, true);
            this.object = object;
            return ModelImpl.this.add(this.namedGraph, this.subject, this.predicate, object);
        }

        public Triple o(Uri uri) {
            return this.o(ModelImpl.this.mapResource(uri));
        }

        public Triple o(Literal literal) {
            return this.o(ModelImpl.this.mapLiteral(literal));
        }

        public Triple o(String uriOrIdOrLiteral) {
            return this.o(ModelImpl.this.map(uriOrIdOrLiteral));
        }

        public Resource newClass(String classUri) throws Uri.UriFormatException {
            return (Resource)this.s(classUri).p(RdfSchema.SUBCLASSOF).o(RdfSchema.RESOURCE).subject();
        }

        public Resource newClass(Uri classUri) {
            return (Resource)this.s(classUri).p(RdfSchema.SUBCLASSOF).o(RdfSchema.RESOURCE).subject();
        }

        public Resource newMetaclass(String metaclassUri) throws Uri.UriFormatException {
            return (Resource)this.s(metaclassUri).p(RdfSchema.SUBCLASSOF).o(RdfSchema.CLASS).subject();
        }

        public Resource newMetaclass(Uri metaclassUri) {
            return (Resource)this.s(metaclassUri).p(RdfSchema.SUBCLASSOF).o(RdfSchema.CLASS).subject();
        }

        public Resource newProperty(String propertyUri) throws Uri.UriFormatException {
            return (Resource)this.s(propertyUri).p(Rdf.TYPE).o(Rdf.PROPERTY).subject();
        }

        public Resource newProperty(Uri propertyUri) {
            return (Resource)this.s(propertyUri).p(Rdf.TYPE).o(Rdf.PROPERTY).subject();
        }

        public Resource newMetaproperty(String metapropertyUri) throws Uri.UriFormatException {
            return (Resource)this.s(metapropertyUri).p(RdfSchema.SUBPROPERTYOF).o(Rdf.PROPERTY).subject();
        }

        public Resource newMetaproperty(Uri metapropertyUri) {
            return (Resource)this.s(metapropertyUri).p(RdfSchema.SUBPROPERTYOF).o(Rdf.PROPERTY).subject();
        }

        public Resource newIndividual(String individualUri) throws Uri.UriFormatException {
            return (Resource)this.s(ModelImpl.this.mapResource(individualUri)).p(Rdf.TYPE).o(RdfSchema.RESOURCE).subject();
        }

        public Resource newIndividual(Uri individualUri) {
            return (Resource)this.s(individualUri).p(Rdf.TYPE).o(RdfSchema.RESOURCE).subject();
        }

        public Resource newNamedGraph(String namedGraphUri) throws Uri.UriFormatException {
            return (Resource)this.s(namedGraphUri).p(Rdf.TYPE).o(RdfSuite.GRAPH).subject();
        }

        public Resource newNamedGraph(Uri namedGraphUri) {
            return (Resource)this.s(namedGraphUri).p(Rdf.TYPE).o(RdfSuite.GRAPH).subject();
        }

        public Resource newAlt(String altUri) throws Uri.UriFormatException {
            return (Resource)this.s(ModelImpl.this.mapResource(altUri)).p(Rdf.TYPE).o(Rdf.ALT).subject();
        }

        public Resource newAlt(Uri altUri) {
            return (Resource)this.s(altUri).p(Rdf.TYPE).o(Rdf.ALT).subject();
        }

        public Resource newBag(String bagUri) throws Uri.UriFormatException {
            return (Resource)this.s(ModelImpl.this.mapResource(bagUri)).p(Rdf.TYPE).o(Rdf.BAG).subject();
        }

        public Resource newBag(Uri bagUri) {
            return (Resource)this.s(bagUri).p(Rdf.TYPE).o(Rdf.BAG).subject();
        }

        public Resource newSeq(String seqUri) throws Uri.UriFormatException {
            return (Resource)this.s(ModelImpl.this.mapResource(seqUri)).p(Rdf.TYPE).o(Rdf.SEQ).subject();
        }

        public Resource newSeq(Uri seqUri) {
            return (Resource)this.s(seqUri).p(Rdf.TYPE).o(Rdf.SEQ).subject();
        }

        public Resource newStatement(String statementUri) throws Uri.UriFormatException {
            return (Resource)this.s(ModelImpl.this.mapResource(statementUri)).p(Rdf.TYPE).o(Rdf.STATEMENT).subject();
        }

        public Resource newStatement(Uri statementUri) {
            return (Resource)this.s(statementUri).p(Rdf.TYPE).o(Rdf.STATEMENT).subject();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ModelViewImpl
    implements ModelView {
        private ModelViewImpl() {
        }

        @Override
        public Iterable<LiteralNode> allLiterals() {
            return Collections.unmodifiableCollection(ModelImpl.this.literals.values());
        }

        @Override
        public Iterable<Resource> allResources() {
            return Collections.unmodifiableCollection(ModelImpl.this.resources.values());
        }

        @Override
        public Iterable<BlankNode> allBlankNodes() {
            return Collections.unmodifiableCollection(ModelImpl.this.blankNodes.values());
        }
    }

    private class QueryBuilderImpl
    implements Model.QueryBuilder {
        private boolean hasGraph = false;
        private Resource namedGraph;
        private boolean hasSubject = false;
        private ObjectNode subject;
        private boolean hasPredicate = false;
        private Resource predicate;
        private boolean hasObject = false;
        private RdfNode object;

        private QueryBuilderImpl() {
        }

        private void checkGraphAndSet(Resource namedGraph) {
            if (this.hasGraph) {
                throw new IllegalStateException("Named graph has already been set");
            }
            ModelImpl.this.checkOwned(namedGraph, true);
            this.hasGraph = true;
            this.namedGraph = namedGraph;
        }

        private void checkSubjectAndSet(ObjectNode subject) {
            if (this.hasSubject) {
                throw new IllegalStateException("Subject has already been set");
            }
            ModelImpl.this.checkOwned(subject, true);
            this.hasSubject = true;
            this.subject = subject;
        }

        private void checkPredicateAndSet(Resource predicate) {
            if (this.hasPredicate) {
                throw new IllegalStateException("Predicate has already been set");
            }
            ModelImpl.this.checkOwned(predicate, true);
            this.hasPredicate = true;
            this.predicate = predicate;
        }

        private void checkObjectAndSet(RdfNode object) {
            if (this.hasObject) {
                throw new IllegalStateException("Object has already been set");
            }
            ModelImpl.this.checkOwned(object, true);
            this.hasObject = true;
            this.object = object;
        }

        public Model.QueryBuilder g(String namedGraph) {
            if (namedGraph == null) {
                this.g(ModelImpl.this.defaultNamedGraph());
            }
            return this.g(ModelImpl.this.mapResource(Uri.parse(namedGraph)));
        }

        public Model.QueryBuilder g(Uri namedGraph) {
            if (namedGraph == null) {
                this.g(ModelImpl.this.defaultNamedGraph());
            }
            return this.g(ModelImpl.this.mapResource(namedGraph));
        }

        public Model.QueryBuilder g(Resource namedGraph) {
            if (namedGraph == null) {
                this.namedGraph = ModelImpl.this.defaultNamedGraph();
            }
            this.checkGraphAndSet(namedGraph);
            return this;
        }

        public Model.QueryBuilder s(String uriOrId) {
            return this.s(ModelImpl.this.mapObjectNode(uriOrId));
        }

        public Model.QueryBuilder s(Uri uri) {
            return this.s(ModelImpl.this.mapResource(uri));
        }

        public Model.QueryBuilder s(ObjectNode node) {
            Assert.notNull((Object)node);
            this.checkSubjectAndSet(node);
            return this;
        }

        public Model.QueryBuilder p(String uri) {
            return this.p(ModelImpl.this.mapResource(Uri.parse(uri)));
        }

        public Model.QueryBuilder p(Uri uri) {
            return this.p(ModelImpl.this.mapResource(uri));
        }

        public Model.QueryBuilder p(Resource node) {
            Assert.notNull((Object)node);
            this.checkPredicateAndSet(node);
            return this;
        }

        public Model.QueryBuilder o(String uriOrIdOrLiteral) {
            return this.o(ModelImpl.this.map(uriOrIdOrLiteral));
        }

        public Model.QueryBuilder o(Uri uri) {
            return this.o(ModelImpl.this.mapResource(uri));
        }

        public Model.QueryBuilder o(Literal literal) {
            return this.o(ModelImpl.this.mapLiteral(literal));
        }

        public Model.QueryBuilder o(RdfNode node) {
            Assert.notNull((Object)node);
            this.checkObjectAndSet(node);
            return this;
        }

        public Triples fetch() {
            return new Triples(ModelImpl.this.indexer.findTriples(this.namedGraph, this.subject, this.predicate, this.object));
        }

        public boolean delete() {
            final ArrayList toDelete = new ArrayList();
            final ArrayList toDeleteAndNotifyIndexer = new ArrayList();
            final boolean[] changed = new boolean[1];
            ModelImpl.this.indexer.deleteTriples(this.namedGraph, this.subject, this.predicate, this.object, new TripleDeletionListener(){

                public void tripleDeleted(Triple triple) {
                    toDelete.add(triple);
                    changed[0] = true;
                }

                public void tripleRemovedFromNamedGraph(Resource namedGraph, Triple triple) {
                    ModelImpl.this.removeNamedGraph((ResourceImpl)namedGraph, (TripleImpl)triple);
                    ModelImpl.this.tripleListenerSupport.fireTripleDeletion(namedGraph, triple);
                    if (triple.graphs().isEmpty()) {
                        toDeleteAndNotifyIndexer.add(triple);
                    }
                    changed[0] = true;
                }
            });
            ModelImpl.this.deleteTriples(toDelete, false);
            ModelImpl.this.deleteTriples(toDeleteAndNotifyIndexer, true);
            return changed[0];
        }
    }
}

