/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.swkm.model2;

import gr.forth.ics.swkm.model2.ObjectNodeImpl;
import gr.forth.ics.swkm.model2.RdfType;
import gr.forth.ics.swkm.model2.ResourceImpl;
import gr.forth.ics.swkm.model2.TripleImpl;
import gr.forth.ics.swkm.model2.Uri;
import gr.forth.ics.swkm.vocabulary.Rdf;
import gr.forth.ics.swkm.vocabulary.RdfSchema;
import gr.forth.ics.swkm.vocabulary.RdfSuite;
import gr.forth.ics.swkm.vocabulary.XmlSchema;

class NodeTypingEngine {
    private NodeTypingEngine() {
    }

    static TypeState unknown() {
        return Unknown.INSTANCE;
    }

    static void makeIndividual(ObjectNodeImpl node, TripleImpl cause) {
        node.changeType(IndividualImpl.INSTANCE, cause);
    }

    static void makeClass(ObjectNodeImpl node, TripleImpl cause) {
        node.changeType(ClassImpl.INSTANCE, cause);
    }

    static void makeMetaclass(ObjectNodeImpl node, TripleImpl cause) {
        node.changeType(MetaClassImpl.INSTANCE, cause);
    }

    static void makeMetaproperty(ObjectNodeImpl node, TripleImpl cause) {
        node.changeType(MetaPropertyImpl.INSTANCE, cause);
    }

    static void makeProperty(ObjectNodeImpl node, TripleImpl cause) {
        node.changeType(PropertyImpl.INSTANCE, cause);
    }

    static void makeStatement(ObjectNodeImpl node, TripleImpl cause) {
        node.changeType(StatementImpl.INSTANCE, cause);
    }

    static void makeAlt(ObjectNodeImpl node, TripleImpl cause) {
        node.changeType(AltImpl.INSTANCE, cause);
    }

    static void makeSeq(ObjectNodeImpl node, TripleImpl cause) {
        node.changeType(SeqImpl.INSTANCE, cause);
    }

    static void makeBag(ObjectNodeImpl node, TripleImpl cause) {
        node.changeType(BagImpl.INSTANCE, cause);
    }

    static void makeNamedGraph(ObjectNodeImpl node, TripleImpl cause) {
        node.changeType(NamedGraphImpl.INSTANCE, cause);
    }

    static void makeInvalid(ObjectNodeImpl node, TripleImpl cause) {
        node.changeType(null, cause);
    }

    static TypeState defaultTypeFor(Uri uri) {
        if (uri.hasEqualNamespace(RdfSchema.NAMESPACE)) {
            if (uri.equals(RdfSchema.RESOURCE)) {
                return new Rdfs_Resource();
            }
            if (uri.equals(RdfSchema.SUBCLASSOF)) {
                return new Rdf_SubClassOf();
            }
            if (uri.equals(RdfSchema.SUBPROPERTYOF)) {
                return new Rdf_SubPropertyOf();
            }
            if (uri.equals(RdfSchema.DOMAIN)) {
                return new Rdf_Domain();
            }
            if (uri.equals(RdfSchema.RANGE)) {
                return new Rdf_Range();
            }
            return NodeTypingEngine.inferTypeFromNamingConvention(uri);
        }
        if (uri.hasEqualNamespace(Rdf.NAMESPACE)) {
            if (uri.equals(Rdf.TYPE)) {
                return new Rdf_Type();
            }
            if (uri.equals(Rdf.PROPERTY)) {
                return new ConstantTypeImpl("rdf:Property", RdfType.METAPROPERTY);
            }
            if (uri.equals(Rdf.SUBJECT)) {
                return new Rdf_Subject();
            }
            if (uri.equals(Rdf.PREDICATE)) {
                return new Rdf_Predicate();
            }
            if (uri.equals(Rdf.OBJECT)) {
                return new Rdf_Object();
            }
            return NodeTypingEngine.inferTypeFromNamingConvention(uri);
        }
        if (uri.hasEqualNamespace(XmlSchema.NAMESPACE)) {
            return XmlType.INSTANCE;
        }
        if (uri.hasEqualNamespace(RdfSuite.NAMESPACE)) {
            if (uri.equals(RdfSuite.GRAPH) || uri.equals(RdfSuite.THESAURUS) || uri.equals(RdfSuite.ENUMERATION)) {
                return new ConstantTypeImpl(uri.toString(), RdfType.CLASS);
            }
            if (uri.equals(RdfSuite.CLASS) || uri.equals(RdfSuite.METACLASS)) {
                return new ConstantTypeImpl(uri.toString(), RdfType.METACLASS);
            }
        }
        return NodeTypingEngine.unknown();
    }

    private static TypeState inferTypeFromNamingConvention(Uri uri) {
        boolean isCapital = Character.isUpperCase(uri.getLocalName().charAt(0));
        return new ConstantTypeImpl(uri.toString(), isCapital ? RdfType.METACLASS : RdfType.METAPROPERTY);
    }

    static class XmlType
    extends ConstantTypeImpl {
        static final XmlType INSTANCE = new XmlType();

        XmlType() {
            super("xml_type", RdfType.XML_TYPE);
        }
    }

    static class Rdfs_Resource
    extends ConstantTypeImpl {
        Rdfs_Resource() {
            super("rdfs:Resource", RdfType.CLASS);
        }
    }

    static class Rdf_Object
    extends ConstantTypeImpl {
        Rdf_Object() {
            super("rdf:object", RdfType.PROPERTY);
        }

        void feedPredicateTriple(TripleImpl triple) {
            ObjectNodeImpl subject = triple.subject();
            if (!subject.type().isStatement()) {
                NodeTypingEngine.makeStatement(subject, triple);
            }
        }
    }

    static class Rdf_Predicate
    extends ConstantTypeImpl {
        Rdf_Predicate() {
            super("rdf:predicate", RdfType.PROPERTY);
        }

        void feedPredicateTriple(TripleImpl triple) {
            ObjectNodeImpl subject = triple.subject();
            if (!subject.type().isStatement()) {
                NodeTypingEngine.makeStatement(subject, triple);
            }
        }
    }

    static class Rdf_Subject
    extends ConstantTypeImpl {
        Rdf_Subject() {
            super("rdf:subject", RdfType.PROPERTY);
        }

        void feedPredicateTriple(TripleImpl triple) {
            ObjectNodeImpl subject = triple.subject();
            if (!subject.type().isStatement()) {
                NodeTypingEngine.makeStatement(subject, triple);
            }
        }
    }

    static class Rdf_Range
    extends ConstantTypeImpl {
        Rdf_Range() {
            super("rdfs:range", RdfType.PROPERTY);
        }

        void feedPredicateTriple(TripleImpl triple) {
            Rdf_Domain.handlePredicateTriple(triple);
        }
    }

    static class Rdf_Domain
    extends ConstantTypeImpl {
        Rdf_Domain() {
            super("rdfs:domain", RdfType.PROPERTY);
        }

        void feedPredicateTriple(TripleImpl triple) {
            Rdf_Domain.handlePredicateTriple(triple);
        }

        static void handlePredicateTriple(TripleImpl triple) {
            ObjectNodeImpl subject = triple.subject();
            ObjectNodeImpl object = triple.getObjectResource();
            RdfType subjectType = subject.type();
            RdfType objectType = object.type();
            if (!subjectType.isProperty()) {
                NodeTypingEngine.makeProperty(subject, triple);
            }
            if (!(objectType.isClass() || objectType.isMetaclass() || objectType.isMetaproperty() || objectType.isXmlType())) {
                NodeTypingEngine.makeClass(object, triple);
            }
        }
    }

    static class Rdf_Type
    extends ConstantTypeImpl {
        public Rdf_Type() {
            super("rdf:type", RdfType.PROPERTY);
        }

        void feedPredicateTriple(TripleImpl triple) {
            ObjectNodeImpl subject = triple.subject();
            ObjectNodeImpl object = triple.getObjectResource();
            RdfType subjectType = subject.type();
            RdfType objectType = object.type();
            if (object.hasConstantType()) {
                if (object.is(RdfSchema.CLASS)) {
                    if (subjectType.isMetaclass() || subjectType.isMetaproperty()) {
                        return;
                    }
                    NodeTypingEngine.makeClass(subject, triple);
                    return;
                }
                if (object.is(Rdf.PROPERTY)) {
                    NodeTypingEngine.makeProperty(subject, triple);
                    return;
                }
                if (object.is(Rdf.STATEMENT)) {
                    NodeTypingEngine.makeStatement(subject, triple);
                    return;
                }
                if (object.is(Rdf.ALT)) {
                    NodeTypingEngine.makeAlt(subject, triple);
                    return;
                }
                if (object.is(Rdf.BAG)) {
                    NodeTypingEngine.makeBag(subject, triple);
                    return;
                }
                if (object.is(Rdf.SEQ)) {
                    NodeTypingEngine.makeSeq(subject, triple);
                    return;
                }
                if (object.is(RdfSchema.RESOURCE)) {
                    NodeTypingEngine.makeIndividual(subject, triple);
                    return;
                }
                if (object.is(RdfSuite.GRAPH)) {
                    NodeTypingEngine.makeNamedGraph(subject, triple);
                    return;
                }
            }
            if (subject.is(RdfSchema.CLASS)) {
                NodeTypingEngine.makeClass(subject, triple);
            } else if (objectType.isMetaproperty()) {
                NodeTypingEngine.makeProperty(subject, triple);
            } else if (subjectType.isMetaclass()) {
                NodeTypingEngine.makeMetaclass(object, triple);
            } else if (subjectType.isClass()) {
                NodeTypingEngine.makeMetaclass(object, triple);
            } else if (subjectType.isProperty()) {
                NodeTypingEngine.makeMetaproperty(object, triple);
            } else if (subjectType.isNamedGraph()) {
                if (!object.is(RdfSuite.GRAPH)) {
                    NodeTypingEngine.makeInvalid(subject, triple);
                }
            } else if (objectType.isClass()) {
                NodeTypingEngine.makeIndividual(subject, triple);
            } else if (objectType.isMetaclass()) {
                NodeTypingEngine.makeClass(subject, triple);
            } else if (subjectType.isIndividual()) {
                NodeTypingEngine.makeClass(object, triple);
            } else if (subjectType.isUnknown()) {
                NodeTypingEngine.makeIndividual(subject, triple);
                if (object.type().isUnknown() || object.type().isIndividual()) {
                    NodeTypingEngine.makeClass(object, triple);
                }
            } else {
                NodeTypingEngine.makeInvalid(subject, triple);
            }
        }
    }

    static class Rdf_SubPropertyOf
    extends ConstantTypeImpl {
        public Rdf_SubPropertyOf() {
            super("rdfs:subPropertyOf", RdfType.PROPERTY);
        }

        void feedPredicateTriple(TripleImpl triple) {
            ObjectNodeImpl subject = triple.subject();
            ObjectNodeImpl object = triple.getObjectResource();
            RdfType subjectType = subject.type();
            RdfType objectType = object.type();
            if (!objectType.isProperty()) {
                NodeTypingEngine.makeProperty(object, triple);
                objectType = object.type();
            }
            if (!subjectType.isProperty()) {
                NodeTypingEngine.makeProperty(subject, triple);
            }
            if (!objectType.isProperty()) {
                NodeTypingEngine.makeProperty(object, triple);
            }
        }
    }

    static class Rdf_SubClassOf
    extends ConstantTypeImpl {
        public Rdf_SubClassOf() {
            super("rdfs:subClassOf", RdfType.PROPERTY);
        }

        void feedPredicateTriple(TripleImpl triple) {
            ObjectNodeImpl subject = triple.subject();
            ObjectNodeImpl object = triple.getObjectResource();
            RdfType subjectType = subject.type();
            RdfType objectType = object.type();
            if (object.is(RdfSchema.CLASS)) {
                NodeTypingEngine.makeMetaclass(subject, triple);
            } else if (object.is(Rdf.PROPERTY)) {
                NodeTypingEngine.makeMetaproperty(subject, triple);
            } else if (object.is(RdfSchema.RESOURCE)) {
                NodeTypingEngine.makeClass(subject, triple);
            } else if (subjectType.isMetaproperty()) {
                NodeTypingEngine.makeMetaproperty(object, triple);
            } else if (objectType.isMetaproperty()) {
                NodeTypingEngine.makeMetaproperty(subject, triple);
            } else if (subjectType.isMetaclass()) {
                NodeTypingEngine.makeMetaclass(object, triple);
            } else if (objectType.isMetaclass()) {
                NodeTypingEngine.makeMetaclass(subject, triple);
            } else if (subjectType.isClass()) {
                NodeTypingEngine.makeClass(object, triple);
            } else {
                NodeTypingEngine.makeClass(subject, triple);
            }
        }
    }

    static class ConstantTypeImpl
    extends TypeState {
        private final String description;
        private final RdfType type;

        ConstantTypeImpl(String description, RdfType type) {
            this.description = description;
            this.type = type;
        }

        public String getDescription() {
            return this.description;
        }

        boolean isTransitionValid(RdfType nextType) {
            return false;
        }

        final boolean validateTransitionTo(RdfType nextType) {
            return false;
        }

        boolean isConstant() {
            return true;
        }

        public RdfType getTypeState() {
            return this.type;
        }
    }

    static class NamedGraphImpl
    extends TypeState {
        static final NamedGraphImpl INSTANCE = new NamedGraphImpl();

        NamedGraphImpl() {
        }

        public String getDescription() {
            return "namedGraph";
        }

        public RdfType getTypeState() {
            return RdfType.NAMED_GRAPH;
        }

        boolean validateTransitionTo(RdfType nextType) {
            return false;
        }
    }

    static class SeqImpl
    extends TypeState {
        static final SeqImpl INSTANCE = new SeqImpl();

        SeqImpl() {
        }

        public String getDescription() {
            return "seq";
        }

        public RdfType getTypeState() {
            return RdfType.SEQ;
        }

        boolean validateTransitionTo(RdfType nextType) {
            return false;
        }
    }

    static class BagImpl
    extends TypeState {
        static final BagImpl INSTANCE = new BagImpl();

        BagImpl() {
        }

        public String getDescription() {
            return "bag";
        }

        public RdfType getTypeState() {
            return RdfType.BAG;
        }

        boolean validateTransitionTo(RdfType nextType) {
            return false;
        }
    }

    static class AltImpl
    extends TypeState {
        static final AltImpl INSTANCE = new AltImpl();

        AltImpl() {
        }

        public String getDescription() {
            return "alt";
        }

        public RdfType getTypeState() {
            return RdfType.ALT;
        }

        boolean validateTransitionTo(RdfType nextType) {
            return false;
        }
    }

    static class StatementImpl
    extends TypeState {
        static final StatementImpl INSTANCE = new StatementImpl();

        StatementImpl() {
        }

        public String getDescription() {
            return "statement";
        }

        public RdfType getTypeState() {
            return RdfType.STATEMENT;
        }

        boolean validateTransitionTo(RdfType nextType) {
            return false;
        }
    }

    static class MetaPropertyImpl
    extends TypeState {
        static final MetaPropertyImpl INSTANCE = new MetaPropertyImpl();

        MetaPropertyImpl() {
        }

        public String getDescription() {
            return "metaproperty";
        }

        public RdfType getTypeState() {
            return RdfType.METAPROPERTY;
        }

        boolean validateTransitionTo(RdfType nextType) {
            return false;
        }
    }

    static class MetaClassImpl
    extends TypeState {
        static final MetaClassImpl INSTANCE = new MetaClassImpl();

        MetaClassImpl() {
        }

        public String getDescription() {
            return "metaclass";
        }

        public RdfType getTypeState() {
            return RdfType.METACLASS;
        }

        boolean validateTransitionTo(RdfType nextType) {
            return nextType.isMetaproperty();
        }
    }

    static class IndividualImpl
    extends TypeState {
        static final IndividualImpl INSTANCE = new IndividualImpl();

        IndividualImpl() {
        }

        public String getDescription() {
            return "individual";
        }

        public RdfType getTypeState() {
            return RdfType.INDIVIDUAL;
        }

        boolean validateTransitionTo(RdfType nextType) {
            return nextType.isClass() || nextType.isMetaclass() || nextType.isProperty() || nextType.isMetaproperty() || nextType.isStatement() || nextType.isContainer() || nextType.isNamedGraph();
        }
    }

    static class PropertyImpl
    extends TypeState {
        static final PropertyImpl INSTANCE = new PropertyImpl();

        PropertyImpl() {
        }

        public String getDescription() {
            return "property";
        }

        public RdfType getTypeState() {
            return RdfType.PROPERTY;
        }

        boolean validateTransitionTo(RdfType nextType) {
            return nextType.isMetaproperty();
        }
    }

    static class ClassImpl
    extends TypeState {
        static final ClassImpl INSTANCE = new ClassImpl();

        ClassImpl() {
        }

        public String getDescription() {
            return "class";
        }

        public RdfType getTypeState() {
            return RdfType.CLASS;
        }

        boolean validateTransitionTo(RdfType nextType) {
            return nextType.isMetaclass() || nextType.isMetaproperty() || nextType.isProperty();
        }
    }

    static class Unknown
    extends TypeState {
        static final Unknown INSTANCE = new Unknown();

        Unknown() {
        }

        public String getDescription() {
            return "unknown";
        }

        public RdfType getTypeState() {
            return RdfType.UNKNOWN;
        }

        boolean validateTransitionTo(RdfType nextType) {
            return true;
        }
    }

    static abstract class TypeState {
        TypeState() {
        }

        abstract RdfType getTypeState();

        void feedPredicateTriple(TripleImpl triple) {
            ResourceImpl predicate = triple.predicate();
            RdfType predicateType = predicate.type();
            if (!predicateType.isProperty() && !predicateType.isMetaproperty()) {
                NodeTypingEngine.makeProperty(predicate, triple);
            }
            if (triple.subject().type().isUnknown()) {
                NodeTypingEngine.makeIndividual(triple.subject(), triple);
            }
            if (triple.object().type().isUnknown()) {
                NodeTypingEngine.makeIndividual(triple.getObjectResource(), triple);
            }
        }

        boolean isConstant() {
            return false;
        }

        boolean isTransitionValid(RdfType nextType) {
            if (nextType == null) {
                return false;
            }
            return this.validateTransitionTo(nextType);
        }

        abstract boolean validateTransitionTo(RdfType var1);

        public String toString() {
            return this.getDescription();
        }

        public String getDescription() {
            return this.getTypeState().toString();
        }

        public boolean equals(Object o) {
            return o instanceof TypeState && ((TypeState)o).getTypeState() == this.getTypeState();
        }

        public int hashCode() {
            return this.getTypeState().hashCode();
        }
    }
}

