/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.swkm.model2;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import gr.forth.ics.swkm.model2.ModelImpl;
import gr.forth.ics.swkm.model2.NodeTypingEngine;
import gr.forth.ics.swkm.model2.ObjectNode;
import gr.forth.ics.swkm.model2.RdfNodeImpl;
import gr.forth.ics.swkm.model2.RdfType;
import gr.forth.ics.swkm.model2.Triple;
import gr.forth.ics.swkm.model2.TripleImpl;
import gr.forth.ics.swkm.model2.Triples;
import gr.forth.ics.swkm.model2.event.TypeChange;
import gr.forth.ics.swkm.model2.validation.ValidationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ObjectNodeImpl
extends RdfNodeImpl
implements ObjectNode {
    private NodeTypingEngine.TypeState type;
    private static final ThreadLocal<List<TypeChange>> changeStack = new ThreadLocal<List<TypeChange>>(){

        @Override
        protected List<TypeChange> initialValue() {
            return new ArrayList<TypeChange>();
        }
    };

    ObjectNodeImpl(ModelImpl owner, NodeTypingEngine.TypeState type) {
        super(owner);
        this.type = type;
    }

    @Override
    public boolean isObjectNode() {
        return true;
    }

    final void feedPredicateTriple(TripleImpl triple) {
        this.type.feedPredicateTriple(triple);
    }

    @Override
    public final boolean hasConstantType() {
        return this.type.isConstant();
    }

    void clearType() {
        NodeTypingEngine.TypeState oldType = this.type;
        this.type = NodeTypingEngine.unknown();
        this.owner.handleTypeChange(this, oldType.getTypeState(), Collections.<TypeChange>emptyList());
    }

    protected boolean isTransitionValid(RdfType newType) {
        return this.type == null || this.type.isTransitionValid(newType) || this.type.getTypeState() == newType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void changeType(NodeTypingEngine.TypeState type, TripleImpl cause) {
        NodeTypingEngine.TypeState oldType = this.type;
        if (oldType != null && oldType.equals(type)) {
            return;
        }
        List<TypeChange> stack = changeStack.get();
        stack.add(new TypeChangeImpl(this, oldType, type, cause));
        try {
            if (type == null || !this.isTransitionValid(type.getTypeState())) {
                throw new ValidationException(this.buildStackMessage());
            }
            this.type = type;
            this.owner.handleTypeChange(this, oldType.getTypeState(), Collections.unmodifiableList(stack));
            this.propagateChangeToDependants();
        }
        finally {
            stack.remove(stack.size() - 1);
            if (stack.isEmpty()) {
                changeStack.remove();
            }
        }
    }

    private Iterable<TripleImpl> relatedTriples() {
        if (this.type.isConstant()) {
            return Iterables.emptyIterable();
        }
        Iterable result = Iterables.concat((Iterable)this.owner.triples().s(this).fetch(), (Iterable)this.owner.triples().o(this).fetch());
        return result;
    }

    Collection<ObjectNodeImpl> getRelatedResources() {
        HashSet dependentResources = Sets.newHashSet();
        for (TripleImpl triple : this.relatedTriples()) {
            Iterables.addAll((Collection)dependentResources, triple.nonLiterals());
        }
        dependentResources.remove(this);
        return dependentResources;
    }

    private String buildStackMessage() {
        List<TypeChange> stack = changeStack.get();
        StringBuilder sb = new StringBuilder();
        ListIterator<TypeChange> iterator = stack.listIterator(stack.size());
        sb.append("Invalid type change:\n  ").append(iterator.previous());
        while (iterator.hasPrevious()) {
            TypeChange change = iterator.previous();
            sb.append("\n    caused by ").append(change);
        }
        return sb.toString();
    }

    private void propagateChangeToDependants() {
        for (ObjectNodeImpl dependant : this.findDependants()) {
            dependant.reclassify();
        }
    }

    private Set<ObjectNodeImpl> findDependants() {
        HashSet dependants = Sets.newHashSet();
        for (TripleImpl triple : this.relatedTriples()) {
            for (ObjectNodeImpl r : triple.nonLiterals()) {
                if (r.type.isConstant()) continue;
                dependants.add(r);
            }
        }
        dependants.add(this);
        return dependants;
    }

    void reclassify() {
        for (TripleImpl triple : this.relatedTriples()) {
            triple.inferTypesOfParts();
        }
    }

    @Override
    public RdfType type() {
        return this.type.getTypeState();
    }

    public String toString() {
        return this.getIdentifier();
    }

    @Override
    public Triples subjectTriples() {
        return this.owner().triples().s(this).fetch();
    }

    @Override
    public abstract String getIdentifier();

    private static class TypeChangeImpl
    implements TypeChange {
        final ObjectNodeImpl node;
        final NodeTypingEngine.TypeState oldType;
        final NodeTypingEngine.TypeState newType;
        final TripleImpl cause;

        TypeChangeImpl(ObjectNodeImpl node, NodeTypingEngine.TypeState oldType, NodeTypingEngine.TypeState newType, TripleImpl cause) {
            this.node = node;
            this.oldType = oldType;
            this.newType = newType;
            this.cause = cause;
        }

        public String toString() {
            return this.node + " changing from " + this.oldType + " to " + this.newType + (this.cause == null ? " due to unknown reason " : " due to triple: " + this.cause.toStringWithTypes());
        }

        public ObjectNode node() {
            return this.node;
        }

        public RdfType oldType() {
            return this.oldType.getTypeState();
        }

        public Triple changeCause() {
            return this.cause;
        }
    }
}

