/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.swkm.model2;

import com.google.common.base.Join;
import gr.forth.ics.swkm.model2.Model;
import gr.forth.ics.swkm.model2.ModelImpl;
import gr.forth.ics.swkm.model2.ObjectNode;
import gr.forth.ics.swkm.model2.RdfNode;
import gr.forth.ics.swkm.model2.RdfType;
import gr.forth.ics.swkm.model2.Resource;
import gr.forth.ics.swkm.model2.Transitively;
import gr.forth.ics.swkm.model2.Triples;
import gr.forth.ics.swkm.model2.index.Index;
import gr.forth.ics.swkm.model2.labels.LabelManager;
import gr.forth.ics.swkm.model2.views.ClassView;
import gr.forth.ics.swkm.model2.views.ContainerView;
import gr.forth.ics.swkm.model2.views.IndividualView;
import gr.forth.ics.swkm.model2.views.Inheritable;
import gr.forth.ics.swkm.model2.views.MetaclassView;
import gr.forth.ics.swkm.model2.views.MetapropertyView;
import gr.forth.ics.swkm.model2.views.PropertyView;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class RdfNodeImpl
implements RdfNode,
ClassView,
PropertyView,
MetaclassView,
MetapropertyView,
IndividualView,
ContainerView {
    private Index index;
    final ModelImpl owner;
    private int tripleCounter;

    RdfNodeImpl(ModelImpl owner) {
        Assert.notNull((Object)owner, (String)"owner");
        this.owner = owner;
    }

    @Override
    public Model owner() {
        return this.owner;
    }

    @Override
    public boolean hasTriples() {
        return this.tripleCounter > 0;
    }

    @Override
    public boolean isResource() {
        return false;
    }

    @Override
    public boolean isBlankNode() {
        return false;
    }

    @Override
    public boolean isLiteral() {
        return false;
    }

    @Override
    public boolean isObjectNode() {
        return this instanceof ObjectNode;
    }

    void setIndex(Index index) {
        this.index = index;
    }

    @Override
    public Index getIndex() {
        return this.index;
    }

    @Override
    public Triples subjectTriples() {
        return Triples.empty();
    }

    @Override
    public Triples predicateTriples() {
        return Triples.empty();
    }

    @Override
    public Triples objectTriples() {
        return this.owner().triples().o(this).fetch();
    }

    @Override
    public ClassView asClass() {
        this.checkType(RdfType.CLASS);
        return this;
    }

    @Override
    public PropertyView asProperty() {
        this.checkType(RdfType.PROPERTY);
        return this;
    }

    @Override
    public MetaclassView asMetaclass() {
        this.checkType(RdfType.METACLASS);
        return this;
    }

    @Override
    public MetapropertyView asMetaproperty() {
        this.checkType(RdfType.METAPROPERTY);
        return this;
    }

    @Override
    public Inheritable asInheritable() {
        this.checkInheritable();
        return this;
    }

    @Override
    public IndividualView asIndividual() {
        this.checkType(RdfType.INDIVIDUAL);
        return this;
    }

    @Override
    public ContainerView asContainer() {
        this.checkContainer();
        return this;
    }

    private void checkType(RdfType type) {
        if (this.type() != type) {
            throw new IllegalStateException("This functionality is only applicable to nodes of type " + (Object)((Object)type) + " but this node: " + this + " is a type of: " + (Object)((Object)this.type()));
        }
    }

    private void checkInheritable() {
        if (!this.type().isSchema() && !this.type().isXmlType()) {
            throw new IllegalStateException("This functionality is only applicable to nodes of some inheritable type  but this node: " + this + " is a type of: " + (Object)((Object)this.type()));
        }
    }

    private void checkContainer() {
        if (!this.type().isContainer()) {
            throw new IllegalStateException("This functionality is only applicable to nodes of container type  but this node: " + this + " is a type of: " + (Object)((Object)this.type()));
        }
    }

    @Override
    public Inheritable leastCommonAncestorWith(RdfNode inheritable) {
        if (this.type() != inheritable.type()) {
            return null;
        }
        throw new UnsupportedOperationException("Implement least common ancestor");
    }

    @Override
    public boolean isAncestorOf(RdfNode resource) {
        LabelManager labelManager = this.owner.getLabelManager();
        Resource first = (Resource)((Object)this);
        Resource second = (Resource)resource;
        if (labelManager.areLabelsAvailable()) {
            return labelManager.isFirstAncestorOfSecond(first, second);
        }
        return this.owner.objectViewSupport().isFirstAncestorOfSecond(first, second);
    }

    @Override
    public boolean isDescendantOf(RdfNode resource) {
        return ((Inheritable)resource).isAncestorOf(this);
    }

    @Override
    public Iterable<PropertyView> domainOf() {
        this.checkType(RdfType.CLASS);
        Iterable<? extends RdfNode> results = this.owner.objectViewSupport().findPropertiesWithDomain((Resource)((Object)this));
        return results;
    }

    @Override
    public Iterable<PropertyView> rangeOf() {
        this.checkType(RdfType.CLASS);
        Iterable<? extends RdfNode> results = this.owner.objectViewSupport().findPropertiesWithRange((Resource)((Object)this));
        return results;
    }

    @Override
    public Iterable<IndividualView> instances() {
        this.checkType(RdfType.CLASS);
        Iterable<? extends RdfNode> results = this.owner.objectViewSupport().findIndividuals((Resource)((Object)this));
        return results;
    }

    @Override
    public Iterable<ClassView> subClasses(Transitively transitively) {
        this.checkType(RdfType.CLASS);
        Iterable<? extends RdfNode> results = this.owner.objectViewSupport().findDescendants((Resource)((Object)this), transitively);
        return results;
    }

    @Override
    public Iterable<ClassView> superClasses(Transitively transitively) {
        this.checkType(RdfType.CLASS);
        Iterable<? extends RdfNode> results = this.owner.objectViewSupport().findAncestors((Resource)((Object)this), transitively);
        return results;
    }

    @Override
    public Iterable<MetaclassView> typeOf() {
        this.checkType(RdfType.CLASS);
        Iterable<? extends RdfNode> results = this.owner.objectViewSupport().findMetaclassesOfClass((Resource)((Object)this));
        return results;
    }

    @Override
    public Triples propertyInstances() {
        this.checkType(RdfType.PROPERTY);
        return this.owner.objectViewSupport().findPropertyInstances((Resource)((Object)this));
    }

    @Override
    public Iterable<Inheritable> domains() {
        this.checkType(RdfType.PROPERTY);
        Iterable<? extends RdfNode> results = this.owner.objectViewSupport().findDomainsOfProperty((Resource)((Object)this));
        return results;
    }

    @Override
    public Iterable<Inheritable> ranges() {
        this.checkType(RdfType.PROPERTY);
        Iterable<? extends RdfNode> results = this.owner.objectViewSupport().findRangesOfProperty((Resource)((Object)this));
        return results;
    }

    @Override
    public Iterable<PropertyView> subProperties(Transitively transitively) {
        this.checkType(RdfType.PROPERTY);
        Iterable<? extends RdfNode> results = this.owner.objectViewSupport().findDescendants((Resource)((Object)this), transitively);
        return results;
    }

    @Override
    public Iterable<PropertyView> superProperties(Transitively transitively) {
        this.checkType(RdfType.PROPERTY);
        Iterable<? extends RdfNode> results = this.owner.objectViewSupport().findAncestors((Resource)((Object)this), transitively);
        return results;
    }

    @Override
    public Iterable<ClassView> classes() {
        this.checkType(RdfType.METACLASS);
        Iterable<? extends RdfNode> results = this.owner.objectViewSupport().findClassesOfMetaclass((Resource)((Object)this));
        return results;
    }

    @Override
    public Iterable<MetaclassView> subMetaclasses(Transitively transitively) {
        this.checkType(RdfType.METACLASS);
        Iterable<? extends RdfNode> results = this.owner.objectViewSupport().findDescendants((Resource)((Object)this), transitively);
        return results;
    }

    @Override
    public Iterable<MetaclassView> superMetaclasses(Transitively transitively) {
        this.checkType(RdfType.METACLASS);
        Iterable<? extends RdfNode> results = this.owner.objectViewSupport().findAncestors((Resource)((Object)this), transitively);
        return results;
    }

    @Override
    public Iterable<PropertyView> properties() {
        this.checkType(RdfType.METAPROPERTY);
        Iterable<? extends RdfNode> results = this.owner.objectViewSupport().findPropertiesOfMetaproperty((Resource)((Object)this));
        return results;
    }

    @Override
    public Iterable<MetapropertyView> subMetaproperties(Transitively transitively) {
        this.checkType(RdfType.METAPROPERTY);
        Iterable<? extends RdfNode> results = this.owner.objectViewSupport().findDescendants((Resource)((Object)this), transitively);
        return results;
    }

    @Override
    public Iterable<MetapropertyView> superMetaproperties(Transitively transitively) {
        this.checkType(RdfType.METAPROPERTY);
        Iterable<? extends RdfNode> results = this.owner.objectViewSupport().findAncestors((Resource)((Object)this), transitively);
        return results;
    }

    @Override
    public Iterable<ClassView> types() {
        this.checkType(RdfType.INDIVIDUAL);
        Iterable<? extends RdfNode> results = this.owner.objectViewSupport().findClassesOfIndividual((ObjectNode)((Object)this));
        return results;
    }

    @Override
    public Iterable<RdfNode> getMembers() {
        this.checkContainer();
        Iterable<RdfNode> results = this.owner.objectViewSupport().findMembersOfContainer((ObjectNode)((Object)this));
        return results;
    }

    @Override
    public Iterable<? extends Inheritable> ancestors(Transitively transitively) {
        switch (this.type()) {
            case CLASS: {
                return this.superClasses(transitively);
            }
            case METACLASS: {
                return this.superMetaclasses(transitively);
            }
            case PROPERTY: {
                return this.superProperties(transitively);
            }
            case METAPROPERTY: {
                return this.superMetaproperties(transitively);
            }
        }
        throw new NotMemberOfHierarchyException(this);
    }

    @Override
    public Iterable<? extends Inheritable> descendants(Transitively transitively) {
        switch (this.type()) {
            case CLASS: {
                return this.subClasses(transitively);
            }
            case METACLASS: {
                return this.subMetaclasses(transitively);
            }
            case PROPERTY: {
                return this.subProperties(transitively);
            }
            case METAPROPERTY: {
                return this.subMetaproperties(transitively);
            }
        }
        throw new NotMemberOfHierarchyException(this);
    }

    @Override
    public boolean isClass() {
        return this.type().isClass();
    }

    @Override
    public boolean isMetaclass() {
        return this.type().isMetaclass();
    }

    @Override
    public boolean isProperty() {
        return this.type().isProperty();
    }

    @Override
    public boolean isMetaproperty() {
        return this.type().isMetaproperty();
    }

    void incrementCounter() {
        ++this.tripleCounter;
        if (this.tripleCounter == 1) {
            this.owner.onAddedNode(this);
        }
    }

    void decrementCounter() {
        --this.tripleCounter;
        if (this.tripleCounter == 0) {
            this.owner.onDeletedNode(this);
        }
    }

    private static class NotMemberOfHierarchyException
    extends IllegalStateException {
        NotMemberOfHierarchyException(RdfNodeImpl node) {
            super("This node: " + node + " is of type: " + (Object)((Object)node.type()) + ", but this operation " + "is applicable only for types: " + "[" + Join.join((String)",", (Object)((Object)RdfType.CLASS), (Object[])new Object[]{RdfType.PROPERTY, RdfType.METACLASS, RdfType.METAPROPERTY}) + "]");
        }
    }
}

