/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.swkm.model2;

import gr.forth.ics.swkm.model2.Model;
import gr.forth.ics.swkm.model2.ObjectNode;
import gr.forth.ics.swkm.model2.RdfNode;
import gr.forth.ics.swkm.model2.Resource;
import gr.forth.ics.swkm.model2.Triple;
import gr.forth.ics.swkm.vocabulary.Rdf;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reifier {
    private Reifier() {
    }

    public static void includeReifiedTriples(Model model, Collection<Triple> reifiedStatements) throws IllegalReifiedStatementException {
        for (ObjectNode node : model.triples().p(Rdf.TYPE).o(Rdf.STATEMENT).fetch().subjects()) {
            Iterable<RdfNode> subjects = model.triples().s(node).p(Rdf.SUBJECT).fetch().objects();
            Iterable<RdfNode> predicates = model.triples().s(node).p(Rdf.PREDICATE).fetch().objects();
            Iterable<RdfNode> objects = model.triples().s(node).p(Rdf.OBJECT).fetch().objects();
            for (RdfNode subject : subjects) {
                for (RdfNode predicate : predicates) {
                    for (RdfNode object : objects) {
                        if (!subject.isObjectNode()) {
                            throw new IllegalReifiedStatementException("Subject is not an ObjectNode", subject, predicate, object);
                        }
                        if (!predicate.isResource()) {
                            throw new IllegalReifiedStatementException("Predicate is not a Resource", subject, predicate, object);
                        }
                        Triple reifiedTriple = model.add(null, (ObjectNode)subject, (Resource)predicate, object);
                        if (reifiedStatements == null) continue;
                        reifiedStatements.add(reifiedTriple);
                    }
                }
            }
        }
    }

    public static class IllegalReifiedStatementException
    extends RuntimeException {
        public IllegalReifiedStatementException(String message, RdfNode subject, RdfNode predicate, RdfNode object) {
            super("Reified statement: [" + subject + ", " + predicate + "," + object + "] is illegal. " + message);
        }
    }
}

