/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.swkm.model2;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Transitively {
    YES{

        @Override
        public <T> Set<T> collect(T initialElement, Function<? super T, ? extends Iterable<? extends T>> function) {
            HashSet set = Sets.newHashSet();
            LinkedList unvisitedElements = Lists.newLinkedList();
            unvisitedElements.add(initialElement);
            while (!unvisitedElements.isEmpty()) {
                Object element = unvisitedElements.removeFirst();
                Iterable nextElements = (Iterable)function.apply(element);
                if (nextElements == null) continue;
                for (Object next : nextElements) {
                    if (set.contains(next)) continue;
                    set.add(next);
                    unvisitedElements.addLast(next);
                }
            }
            return set;
        }
    }
    ,
    NO{

        @Override
        public <T> Set<T> collect(T initialElement, Function<? super T, ? extends Iterable<? extends T>> function) {
            Iterable elements = (Iterable)function.apply(initialElement);
            if (elements instanceof Set) {
                Set set = (Set)elements;
                return Collections.unmodifiableSet(set);
            }
            if (elements == null) {
                return Collections.emptySet();
            }
            return ImmutableSet.copyOf((Iterable)elements);
        }
    };


    public abstract <T> Set<T> collect(T var1, Function<? super T, ? extends Iterable<? extends T>> var2);
}

