/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.swkm.model2;

import com.google.common.base.Function;
import com.google.common.base.Join;
import com.google.common.collect.Iterables;
import gr.forth.ics.swkm.model2.ObjectNode;
import gr.forth.ics.swkm.model2.RdfNode;
import gr.forth.ics.swkm.model2.Resource;
import gr.forth.ics.swkm.model2.Triple;
import java.util.Collections;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Triples
implements Iterable<Triple> {
    private static final Triples empty = new Triples(Collections.<Triple>emptyList());
    private final Iterable<Triple> triples;

    public Triples(Iterable<Triple> triples) {
        if (triples == null) {
            throw new NullPointerException();
        }
        this.triples = triples;
    }

    public Iterable<ObjectNode> subjects() {
        return Iterables.transform(this.triples, (Function)new Function<Triple, ObjectNode>(){

            public ObjectNode apply(Triple triple) {
                return triple.subject();
            }
        });
    }

    public Iterable<Resource> predicates() {
        return Iterables.transform(this.triples, (Function)new Function<Triple, Resource>(){

            public Resource apply(Triple triple) {
                return triple.predicate();
            }
        });
    }

    public Iterable<RdfNode> objects() {
        return Iterables.transform(this.triples, (Function)new Function<Triple, RdfNode>(){

            public RdfNode apply(Triple triple) {
                return triple.object();
            }
        });
    }

    @Override
    public Iterator<Triple> iterator() {
        return this.triples.iterator();
    }

    public String toString() {
        return Join.join((String)"\n", (Iterable)this);
    }

    public static Triples empty() {
        return empty;
    }

    public static Triples singleton(Triple triple) {
        return new Triples(Collections.singletonList(triple));
    }

    public boolean delete() {
        boolean changed = false;
        for (Triple t : this) {
            changed |= t.delete();
        }
        return changed;
    }
}

