/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.swkm.model2;

import java.io.IOException;
import java.util.regex.Pattern;
import org.springframework.util.Assert;

public final class Uri {
    private final String namespace;
    private final String localName;
    private static final Pattern validNamespacePattern = Pattern.compile("\\p{Alpha}([\\w_\\-/?:.~])*");
    private static final Pattern validLocalNamePattern = Pattern.compile("(\\p{Alpha}([\\w_\\-/?:.~])*)?");

    private Uri(String namespace, String localName, boolean validate) {
        namespace = Uri.maskNull(namespace);
        localName = Uri.maskNull(localName);
        if (validate) {
            String newBase = namespace;
            if (namespace.endsWith("#")) {
                newBase = namespace.substring(0, namespace.length() - 1);
            }
            String newLocal = localName;
            if (localName.startsWith("#")) {
                newLocal = localName.substring(1);
            }
            Uri.checkDoesNotContainSharp(newBase, "Base");
            Uri.checkDoesNotContainSharp(newLocal, "Local part");
            namespace = newBase;
            localName = newLocal;
        }
        this.namespace = namespace.intern();
        this.localName = localName.intern();
    }

    public Uri(String namespace, String localName) throws UriFormatException {
        this(namespace, localName, true);
    }

    public static Uri parse(String uri) throws UriFormatException {
        Assert.notNull((Object)uri);
        Uri parsedUri = Uri.tryParse(uri);
        if (parsedUri == null) {
            throw new UriFormatException("Cannot parse the given string as URI: '" + uri + "'");
        }
        return parsedUri;
    }

    public static Uri tryParse(String uri) {
        if (uri == null) {
            return null;
        }
        int ns = uri.indexOf(35);
        if (ns == -1) {
            return new Uri(uri, "");
        }
        if (uri.lastIndexOf(35) != ns) {
            return null;
        }
        return new Uri(uri.substring(0, ns), uri.substring(ns + 1));
    }

    private static void checkDoesNotContainSharp(String s, String name) {
        if (s.contains("#")) {
            throw new UriFormatException(name + " cannot contain '#'. Was: '" + s + "'");
        }
    }

    private static String maskNull(String s) {
        return s != null ? s : "";
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Uri getNamespaceUri() {
        return new Uri(this.namespace, "", false);
    }

    public void appendNamespace(Appendable appendable) {
        try {
            appendable.append(this.namespace);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getLocalName() {
        return this.localName;
    }

    public void appendLocalName(Appendable appendable) {
        try {
            appendable.append(this.localName);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean hasEqualNamespace(Uri uri) {
        return this.namespace == uri.namespace;
    }

    public boolean hasEqualLocalName(Uri uri) {
        return this.localName == uri.localName;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Uri other = (Uri)obj;
        return this.namespace == other.namespace && this.localName == other.localName;
    }

    public boolean validateCharacters() {
        return validNamespacePattern.matcher(this.namespace).matches() && validLocalNamePattern.matcher(this.localName).matches();
    }

    public int hashCode() {
        int hash = 3;
        hash = 31 * hash + (this.namespace != null ? this.namespace.hashCode() : 0);
        hash = 31 * hash + (this.localName != null ? this.localName.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return this.toString(Hash.WITHOUT);
    }

    public String toString(Hash hash) {
        if (this.localName.length() == 0) {
            if (hash == Hash.WITH) {
                return this.namespace + "#";
            }
            return this.namespace;
        }
        return this.namespace + "#" + this.localName;
    }

    public void toString(Appendable appendable) {
        this.toString(appendable, Hash.WITHOUT);
    }

    public void toString(Appendable appendable, Hash hash) {
        try {
            if (this.localName.length() == 0) {
                if (hash == Hash.WITH) {
                    appendable.append(this.namespace).append("#");
                } else {
                    appendable.append(this.namespace);
                }
            } else {
                appendable.append(this.namespace).append("#").append(this.localName);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Uri withLocalName(String localName) {
        return new Uri(this.namespace, localName);
    }

    public Uri withNamespace(String namespace) {
        return new Uri(namespace, this.localName);
    }

    public static class UriFormatException
    extends RuntimeException {
        public UriFormatException(String message) {
            super(message);
        }

        public UriFormatException(String message, Throwable cause) {
            super(message, cause);
        }

        public UriFormatException(Throwable cause) {
            super(cause);
        }

        public UriFormatException() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Hash {
        WITH,
        WITHOUT;

    }
}

