/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.swkm.model2;

import gr.forth.ics.swkm.model2.Uri;
import gr.forth.ics.swkm.vocabulary.XmlSchema;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

class XmlDatatypeUtil {
    XmlDatatypeUtil() {
    }

    static boolean isValidValue(String value, Uri datatype) {
        boolean result = true;
        if (datatype.equals(XmlSchema.DECIMAL)) {
            result = XmlDatatypeUtil.isValidDecimal(value);
        } else if (datatype.equals(XmlSchema.INTEGER)) {
            result = XmlDatatypeUtil.isValidInteger(value);
        } else if (datatype.equals(XmlSchema.NEGATIVE_INTEGER)) {
            result = XmlDatatypeUtil.isValidNegativeInteger(value);
        } else if (datatype.equals(XmlSchema.NON_POSITIVE_INTEGER)) {
            result = XmlDatatypeUtil.isValidNonPositiveInteger(value);
        } else if (datatype.equals(XmlSchema.NON_NEGATIVE_INTEGER)) {
            result = XmlDatatypeUtil.isValidNonNegativeInteger(value);
        } else if (datatype.equals(XmlSchema.POSITIVE_INTEGER)) {
            result = XmlDatatypeUtil.isValidPositiveInteger(value);
        } else if (datatype.equals(XmlSchema.LONG)) {
            result = XmlDatatypeUtil.isValidLong(value);
        } else if (datatype.equals(XmlSchema.INT)) {
            result = XmlDatatypeUtil.isValidInt(value);
        } else if (datatype.equals(XmlSchema.SHORT)) {
            result = XmlDatatypeUtil.isValidShort(value);
        } else if (datatype.equals(XmlSchema.BYTE)) {
            result = XmlDatatypeUtil.isValidByte(value);
        } else if (datatype.equals(XmlSchema.UNSIGNED_LONG)) {
            result = XmlDatatypeUtil.isValidUnsignedLong(value);
        } else if (datatype.equals(XmlSchema.UNSIGNED_INT)) {
            result = XmlDatatypeUtil.isValidUnsignedInt(value);
        } else if (datatype.equals(XmlSchema.UNSIGNED_SHORT)) {
            result = XmlDatatypeUtil.isValidUnsignedShort(value);
        } else if (datatype.equals(XmlSchema.UNSIGNED_BYTE)) {
            result = XmlDatatypeUtil.isValidUnsignedByte(value);
        } else if (datatype.equals(XmlSchema.FLOAT)) {
            result = XmlDatatypeUtil.isValidFloat(value);
        } else if (datatype.equals(XmlSchema.DOUBLE)) {
            result = XmlDatatypeUtil.isValidDouble(value);
        } else if (datatype.equals(XmlSchema.BOOLEAN)) {
            result = XmlDatatypeUtil.isValidBoolean(value);
        } else if (datatype.equals(XmlSchema.DATETIME)) {
            result = XmlDatatypeUtil.isValidDateTime(value);
        }
        return result;
    }

    static boolean isValidDecimal(String value) {
        try {
            XmlDatatypeUtil.normalizeDecimal(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    static boolean isValidInteger(String value) {
        try {
            XmlDatatypeUtil.normalizeInteger(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    static boolean isValidNegativeInteger(String value) {
        try {
            XmlDatatypeUtil.normalizeNegativeInteger(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    static boolean isValidNonPositiveInteger(String value) {
        try {
            XmlDatatypeUtil.normalizeNonPositiveInteger(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    static boolean isValidNonNegativeInteger(String value) {
        try {
            XmlDatatypeUtil.normalizeNonNegativeInteger(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    static boolean isValidPositiveInteger(String value) {
        try {
            XmlDatatypeUtil.normalizePositiveInteger(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    static boolean isValidLong(String value) {
        try {
            XmlDatatypeUtil.normalizeLong(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    static boolean isValidInt(String value) {
        try {
            XmlDatatypeUtil.normalizeInt(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    static boolean isValidShort(String value) {
        try {
            XmlDatatypeUtil.normalizeShort(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    static boolean isValidByte(String value) {
        try {
            XmlDatatypeUtil.normalizeByte(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    static boolean isValidUnsignedLong(String value) {
        try {
            XmlDatatypeUtil.normalizeUnsignedLong(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    static boolean isValidUnsignedInt(String value) {
        try {
            XmlDatatypeUtil.normalizeUnsignedInt(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    static boolean isValidUnsignedShort(String value) {
        try {
            XmlDatatypeUtil.normalizeUnsignedShort(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    static boolean isValidUnsignedByte(String value) {
        try {
            XmlDatatypeUtil.normalizeUnsignedByte(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    static boolean isValidFloat(String value) {
        try {
            XmlDatatypeUtil.normalizeFloat(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    static boolean isValidDouble(String value) {
        try {
            XmlDatatypeUtil.normalizeDouble(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    static boolean isValidBoolean(String value) {
        try {
            XmlDatatypeUtil.normalizeBoolean(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    static boolean isValidDateTime(String value) {
        try {
            DateTime dt = new DateTime(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    static String normalize(String value, Uri datatype) {
        String result = value;
        if (datatype.equals(XmlSchema.DECIMAL)) {
            result = XmlDatatypeUtil.normalizeDecimal(value);
        } else if (datatype.equals(XmlSchema.INTEGER)) {
            result = XmlDatatypeUtil.normalizeInteger(value);
        } else if (datatype.equals(XmlSchema.NEGATIVE_INTEGER)) {
            result = XmlDatatypeUtil.normalizeNegativeInteger(value);
        } else if (datatype.equals(XmlSchema.NON_POSITIVE_INTEGER)) {
            result = XmlDatatypeUtil.normalizeNonPositiveInteger(value);
        } else if (datatype.equals(XmlSchema.NON_NEGATIVE_INTEGER)) {
            result = XmlDatatypeUtil.normalizeNonNegativeInteger(value);
        } else if (datatype.equals(XmlSchema.POSITIVE_INTEGER)) {
            result = XmlDatatypeUtil.normalizePositiveInteger(value);
        } else if (datatype.equals(XmlSchema.LONG)) {
            result = XmlDatatypeUtil.normalizeLong(value);
        } else if (datatype.equals(XmlSchema.INT)) {
            result = XmlDatatypeUtil.normalizeInt(value);
        } else if (datatype.equals(XmlSchema.SHORT)) {
            result = XmlDatatypeUtil.normalizeShort(value);
        } else if (datatype.equals(XmlSchema.BYTE)) {
            result = XmlDatatypeUtil.normalizeByte(value);
        } else if (datatype.equals(XmlSchema.UNSIGNED_LONG)) {
            result = XmlDatatypeUtil.normalizeUnsignedLong(value);
        } else if (datatype.equals(XmlSchema.UNSIGNED_INT)) {
            result = XmlDatatypeUtil.normalizeUnsignedInt(value);
        } else if (datatype.equals(XmlSchema.UNSIGNED_SHORT)) {
            result = XmlDatatypeUtil.normalizeUnsignedShort(value);
        } else if (datatype.equals(XmlSchema.UNSIGNED_BYTE)) {
            result = XmlDatatypeUtil.normalizeUnsignedByte(value);
        } else if (datatype.equals(XmlSchema.FLOAT)) {
            result = XmlDatatypeUtil.normalizeFloat(value);
        } else if (datatype.equals(XmlSchema.DOUBLE)) {
            result = XmlDatatypeUtil.normalizeDouble(value);
        } else if (datatype.equals(XmlSchema.BOOLEAN)) {
            result = XmlDatatypeUtil.normalizeBoolean(value);
        } else if (datatype.equals(XmlSchema.DATETIME)) {
            result = XmlDatatypeUtil.normalizeDateTime(value);
        }
        return result;
    }

    static String normalizeBoolean(String value) {
        if ((value = XmlDatatypeUtil.collapseWhiteSpace(value)).equals("1")) {
            return "true";
        }
        if (value.equals("0")) {
            return "false";
        }
        if (value.equals("true") || value.equals("false")) {
            return value;
        }
        throw new IllegalArgumentException("Not a legal boolean value: " + value);
    }

    static String normalizeDecimal(String decimal) {
        decimal = XmlDatatypeUtil.collapseWhiteSpace(decimal);
        String errMsg = "Not a legal decimal: " + decimal;
        int decLength = decimal.length();
        StringBuffer result = new StringBuffer(decLength + 2);
        if (decLength == 0) {
            throw new IllegalArgumentException(errMsg);
        }
        boolean isZeroPointZero = true;
        int idx = 0;
        if (decimal.charAt(idx) == '-') {
            result.append('-');
            ++idx;
        } else if (decimal.charAt(idx) == '+') {
            ++idx;
        }
        if (idx == decLength) {
            throw new IllegalArgumentException(errMsg);
        }
        while (idx < decLength && decimal.charAt(idx) == '0') {
            ++idx;
        }
        if (idx == decLength) {
            result.append('0');
        } else if (idx < decLength && decimal.charAt(idx) == '.') {
            result.append('0');
        } else {
            char c;
            isZeroPointZero = false;
            while (idx < decLength && (c = decimal.charAt(idx)) != '.') {
                if (!XmlDatatypeUtil._isDigit(c)) {
                    throw new IllegalArgumentException(errMsg);
                }
                result.append(c);
                ++idx;
            }
        }
        result.append('.');
        if (idx == decLength) {
            result.append('0');
        } else {
            int lastIdx;
            ++idx;
            for (lastIdx = decLength - 1; lastIdx >= 0 && decimal.charAt(lastIdx) == '0'; --lastIdx) {
            }
            if (idx > lastIdx) {
                result.append('0');
            } else {
                isZeroPointZero = false;
                while (idx <= lastIdx) {
                    char c = decimal.charAt(idx);
                    if (!XmlDatatypeUtil._isDigit(c)) {
                        throw new IllegalArgumentException(errMsg);
                    }
                    result.append(c);
                    ++idx;
                }
            }
        }
        if (isZeroPointZero) {
            return "0.0";
        }
        return result.toString();
    }

    static String normalizeInteger(String value) {
        return XmlDatatypeUtil._normalizeIntegerValue(value, null, null);
    }

    static String normalizeNegativeInteger(String value) {
        return XmlDatatypeUtil._normalizeIntegerValue(value, null, "-1");
    }

    static String normalizeNonPositiveInteger(String value) {
        return XmlDatatypeUtil._normalizeIntegerValue(value, null, "0");
    }

    static String normalizeNonNegativeInteger(String value) {
        return XmlDatatypeUtil._normalizeIntegerValue(value, "0", null);
    }

    static String normalizePositiveInteger(String value) {
        return XmlDatatypeUtil._normalizeIntegerValue(value, "1", null);
    }

    static String normalizeLong(String value) {
        return XmlDatatypeUtil._normalizeIntegerValue(value, "-9223372036854775808", "9223372036854775807");
    }

    static String normalizeInt(String value) {
        return XmlDatatypeUtil._normalizeIntegerValue(value, "-2147483648", "2147483647");
    }

    static String normalizeShort(String value) {
        return XmlDatatypeUtil._normalizeIntegerValue(value, "-32768", "32767");
    }

    static String normalizeByte(String value) {
        return XmlDatatypeUtil._normalizeIntegerValue(value, "-128", "127");
    }

    static String normalizeUnsignedLong(String value) {
        return XmlDatatypeUtil._normalizeIntegerValue(value, "0", "18446744073709551615");
    }

    static String normalizeUnsignedInt(String value) {
        return XmlDatatypeUtil._normalizeIntegerValue(value, "0", "4294967295");
    }

    static String normalizeUnsignedShort(String value) {
        return XmlDatatypeUtil._normalizeIntegerValue(value, "0", "65535");
    }

    static String normalizeUnsignedByte(String value) {
        return XmlDatatypeUtil._normalizeIntegerValue(value, "0", "255");
    }

    private static String _normalizeIntegerValue(String integer, String minValue, String maxValue) {
        integer = XmlDatatypeUtil.collapseWhiteSpace(integer);
        String errMsg = "Not a legal integer: " + integer;
        int intLength = integer.length();
        if (intLength == 0) {
            throw new IllegalArgumentException(errMsg);
        }
        int idx = 0;
        boolean isNegative = false;
        if (integer.charAt(idx) == '-') {
            isNegative = true;
            ++idx;
        } else if (integer.charAt(idx) == '+') {
            ++idx;
        }
        if (idx == intLength) {
            throw new IllegalArgumentException(errMsg);
        }
        if (integer.charAt(idx) == '0' && idx < intLength - 1) {
            ++idx;
            while (idx < intLength - 1 && integer.charAt(idx) == '0') {
                ++idx;
            }
        }
        String norm = integer.substring(idx);
        for (int i = 0; i < norm.length(); ++i) {
            if (XmlDatatypeUtil._isDigit(norm.charAt(i))) continue;
            throw new IllegalArgumentException(errMsg);
        }
        if (isNegative && norm.charAt(0) != '0') {
            norm = "-" + norm;
        }
        if (minValue != null && XmlDatatypeUtil.compareCanonicalIntegers(norm, minValue) < 0) {
            throw new IllegalArgumentException(errMsg);
        }
        if (maxValue != null && XmlDatatypeUtil.compareCanonicalIntegers(norm, maxValue) > 0) {
            throw new IllegalArgumentException(errMsg);
        }
        return norm;
    }

    static String normalizeFloat(String value) {
        return XmlDatatypeUtil._normalizeFPNumber(value, "-16777215.0", "16777215.0", "-149", "104");
    }

    static String normalizeDouble(String value) {
        return XmlDatatypeUtil._normalizeFPNumber(value, "-9007199254740991.0", "9007199254740991.0", "-1075", "970");
    }

    static String normalizeFPNumber(String value) {
        return XmlDatatypeUtil._normalizeFPNumber(value, null, null, null, null);
    }

    private static String _normalizeFPNumber(String value, String minMantissa, String maxMantissa, String minExponent, String maxExponent) {
        int dotIdx;
        String exponent;
        String mantissa;
        if ((value = XmlDatatypeUtil.collapseWhiteSpace(value)).equals("INF") || value.equals("-INF") || value.equals("NaN")) {
            return value;
        }
        int eIdx = value.indexOf(69);
        if (eIdx == -1) {
            eIdx = value.indexOf(101);
        }
        if (eIdx == -1) {
            mantissa = XmlDatatypeUtil.normalizeDecimal(value);
            exponent = "0";
        } else {
            mantissa = XmlDatatypeUtil.normalizeDecimal(value.substring(0, eIdx));
            exponent = XmlDatatypeUtil.normalizeInteger(value.substring(eIdx + 1));
        }
        if (minMantissa != null && XmlDatatypeUtil.compareCanonicalDecimals(mantissa, minMantissa) < 0) {
            throw new IllegalArgumentException("Mantissa smaller than minimum value (" + minMantissa + ")");
        }
        if (maxMantissa != null && XmlDatatypeUtil.compareCanonicalDecimals(mantissa, maxMantissa) > 0) {
            throw new IllegalArgumentException("Mantissa larger than maximum value (" + minMantissa + ")");
        }
        if (minExponent != null && XmlDatatypeUtil.compareCanonicalIntegers(exponent, minExponent) < 0) {
            throw new IllegalArgumentException("Exponent smaller than minimum value (" + minExponent + ")");
        }
        if (maxExponent != null && XmlDatatypeUtil.compareCanonicalIntegers(exponent, maxExponent) > 0) {
            throw new IllegalArgumentException("Exponent larger than maximum value (" + maxExponent + ")");
        }
        int shift = 0;
        int digitCount = dotIdx = mantissa.indexOf(46);
        if (mantissa.charAt(0) == '-') {
            --digitCount;
        }
        if (digitCount > 1) {
            int nonZeroIdx;
            StringBuffer buf = new StringBuffer(mantissa.length());
            int firstDigitIdx = 0;
            if (mantissa.charAt(0) == '-') {
                buf.append('-');
                firstDigitIdx = 1;
            }
            buf.append(mantissa.charAt(firstDigitIdx));
            buf.append('.');
            buf.append(mantissa.substring(firstDigitIdx + 1, dotIdx));
            buf.append(mantissa.substring(dotIdx + 1));
            mantissa = buf.toString();
            for (nonZeroIdx = mantissa.length() - 1; nonZeroIdx >= 3 && mantissa.charAt(nonZeroIdx) == '0'; --nonZeroIdx) {
            }
            if (nonZeroIdx < 3 && mantissa.charAt(0) == '-') {
                ++nonZeroIdx;
            }
            if (nonZeroIdx < mantissa.length() - 1) {
                mantissa = mantissa.substring(0, nonZeroIdx + 1);
            }
            shift = 1 - digitCount;
        } else if (mantissa.startsWith("0.") || mantissa.startsWith("-0.")) {
            int nonZeroIdx;
            for (nonZeroIdx = 2; nonZeroIdx < mantissa.length() && mantissa.charAt(nonZeroIdx) == '0'; ++nonZeroIdx) {
            }
            if (nonZeroIdx < mantissa.length()) {
                StringBuffer buf = new StringBuffer(mantissa.length());
                buf.append(mantissa.charAt(nonZeroIdx));
                buf.append('.');
                if (nonZeroIdx == mantissa.length() - 1) {
                    buf.append('0');
                } else {
                    buf.append(mantissa.substring(nonZeroIdx + 1));
                }
                mantissa = buf.toString();
                shift = nonZeroIdx - 1;
            }
        }
        if (shift != 0) {
            try {
                int exp = Integer.parseInt(exponent);
                exponent = String.valueOf(exp - shift);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("NumberFormatException: " + e.getMessage());
            }
        }
        return mantissa + "E" + exponent;
    }

    static String normalizeDateTime(String value) {
        DateTime dt = new DateTime(value);
        dt.normalize();
        return dt.toString();
    }

    static String collapseWhiteSpace(String s) {
        StringTokenizer st = new StringTokenizer(s, "\t\r\n ");
        if (!st.hasMoreTokens()) {
            return "";
        }
        String firstToken = st.nextToken();
        if (!st.hasMoreTokens()) {
            return firstToken;
        }
        StringBuffer buf = new StringBuffer(s.length());
        buf.append(firstToken);
        while (st.hasMoreTokens()) {
            buf.append(' ').append(st.nextToken());
        }
        return buf.toString();
    }

    static int compare(String value1, String value2, Uri datatype) {
        if (datatype.equals(XmlSchema.DECIMAL)) {
            return XmlDatatypeUtil.compareDecimals(value1, value2);
        }
        if (datatype.equals(XmlSchema.INTEGER)) {
            return XmlDatatypeUtil.compareIntegers(value1, value2);
        }
        if (datatype.equals(XmlSchema.NEGATIVE_INTEGER)) {
            return XmlDatatypeUtil.compareNegativeIntegers(value1, value2);
        }
        if (datatype.equals(XmlSchema.NON_POSITIVE_INTEGER)) {
            return XmlDatatypeUtil.compareNonPositiveIntegers(value1, value2);
        }
        if (datatype.equals(XmlSchema.NON_NEGATIVE_INTEGER)) {
            return XmlDatatypeUtil.compareNonNegativeIntegers(value1, value2);
        }
        if (datatype.equals(XmlSchema.POSITIVE_INTEGER)) {
            return XmlDatatypeUtil.comparePositiveIntegers(value1, value2);
        }
        if (datatype.equals(XmlSchema.LONG)) {
            return XmlDatatypeUtil.compareLongs(value1, value2);
        }
        if (datatype.equals(XmlSchema.INT)) {
            return XmlDatatypeUtil.compareInts(value1, value2);
        }
        if (datatype.equals(XmlSchema.SHORT)) {
            return XmlDatatypeUtil.compareShorts(value1, value2);
        }
        if (datatype.equals(XmlSchema.BYTE)) {
            return XmlDatatypeUtil.compareBytes(value1, value2);
        }
        if (datatype.equals(XmlSchema.UNSIGNED_LONG)) {
            return XmlDatatypeUtil.compareUnsignedLongs(value1, value2);
        }
        if (datatype.equals(XmlSchema.UNSIGNED_INT)) {
            return XmlDatatypeUtil.compareUnsignedInts(value1, value2);
        }
        if (datatype.equals(XmlSchema.UNSIGNED_SHORT)) {
            return XmlDatatypeUtil.compareUnsignedShorts(value1, value2);
        }
        if (datatype.equals(XmlSchema.UNSIGNED_BYTE)) {
            return XmlDatatypeUtil.compareUnsignedBytes(value1, value2);
        }
        if (datatype.equals(XmlSchema.FLOAT)) {
            return XmlDatatypeUtil.compareFloats(value1, value2);
        }
        if (datatype.equals(XmlSchema.DOUBLE)) {
            return XmlDatatypeUtil.compareDoubles(value1, value2);
        }
        if (datatype.equals(XmlSchema.DATETIME)) {
            return XmlDatatypeUtil.compareDateTime(value1, value2);
        }
        throw new IllegalArgumentException("Data type: " + datatype + " not ordered");
    }

    static int compareDecimals(String dec1, String dec2) {
        dec1 = XmlDatatypeUtil.normalizeDecimal(dec1);
        dec2 = XmlDatatypeUtil.normalizeDecimal(dec2);
        return XmlDatatypeUtil.compareCanonicalDecimals(dec1, dec2);
    }

    static int compareCanonicalDecimals(String dec1, String dec2) {
        int dotIdx2;
        if (dec1.equals(dec2)) {
            return 0;
        }
        if (dec1.charAt(0) == '-' && dec2.charAt(0) != '-') {
            return -1;
        }
        if (dec2.charAt(0) == '-' && dec1.charAt(0) != '-') {
            return 1;
        }
        int dotIdx1 = dec1.indexOf(46);
        int result = dotIdx1 - (dotIdx2 = dec2.indexOf(46));
        if (result == 0) {
            int dec2Length;
            for (int i = 0; result == 0 && i < dotIdx1; ++i) {
                result = dec1.charAt(i) - dec2.charAt(i);
            }
            int dec1Length = dec1.length();
            int lastIdx = dec1Length <= (dec2Length = dec2.length()) ? dec1Length : dec2Length;
            for (int i = dotIdx1 + 1; result == 0 && i < lastIdx; ++i) {
                result = dec1.charAt(i) - dec2.charAt(i);
            }
            if (result == 0) {
                result = dec1Length - dec2Length;
            }
        }
        if (dec1.charAt(0) == '-') {
            result = -result;
        }
        return result;
    }

    static int compareIntegers(String int1, String int2) {
        int1 = XmlDatatypeUtil.normalizeInteger(int1);
        int2 = XmlDatatypeUtil.normalizeInteger(int2);
        return XmlDatatypeUtil.compareCanonicalIntegers(int1, int2);
    }

    static int compareCanonicalIntegers(String int1, String int2) {
        if (int1.equals(int2)) {
            return 0;
        }
        if (int1.charAt(0) == '-' && int2.charAt(0) != '-') {
            return -1;
        }
        if (int2.charAt(0) == '-' && int1.charAt(0) != '-') {
            return 1;
        }
        int result = int1.length() - int2.length();
        if (result == 0) {
            for (int i = 0; result == 0 && i < int1.length(); ++i) {
                result = int1.charAt(i) - int2.charAt(i);
            }
        }
        if (int1.charAt(0) == '-') {
            result = -result;
        }
        return result;
    }

    static int compareNegativeIntegers(String int1, String int2) {
        int1 = XmlDatatypeUtil.normalizeNegativeInteger(int1);
        int2 = XmlDatatypeUtil.normalizeNegativeInteger(int2);
        return XmlDatatypeUtil.compareCanonicalIntegers(int1, int2);
    }

    static int compareNonPositiveIntegers(String int1, String int2) {
        int1 = XmlDatatypeUtil.normalizeNonPositiveInteger(int1);
        int2 = XmlDatatypeUtil.normalizeNonPositiveInteger(int2);
        return XmlDatatypeUtil.compareCanonicalIntegers(int1, int2);
    }

    static int compareNonNegativeIntegers(String int1, String int2) {
        int1 = XmlDatatypeUtil.normalizeNonNegativeInteger(int1);
        int2 = XmlDatatypeUtil.normalizeNonNegativeInteger(int2);
        return XmlDatatypeUtil.compareCanonicalIntegers(int1, int2);
    }

    static int comparePositiveIntegers(String int1, String int2) {
        int1 = XmlDatatypeUtil.normalizePositiveInteger(int1);
        int2 = XmlDatatypeUtil.normalizePositiveInteger(int2);
        return XmlDatatypeUtil.compareCanonicalIntegers(int1, int2);
    }

    static int compareLongs(String int1, String int2) {
        int1 = XmlDatatypeUtil.normalizeLong(int1);
        int2 = XmlDatatypeUtil.normalizeLong(int2);
        return XmlDatatypeUtil.compareCanonicalIntegers(int1, int2);
    }

    static int compareInts(String int1, String int2) {
        int1 = XmlDatatypeUtil.normalizeInt(int1);
        int2 = XmlDatatypeUtil.normalizeInt(int2);
        return XmlDatatypeUtil.compareCanonicalIntegers(int1, int2);
    }

    static int compareShorts(String int1, String int2) {
        int1 = XmlDatatypeUtil.normalizeShort(int1);
        int2 = XmlDatatypeUtil.normalizeShort(int2);
        return XmlDatatypeUtil.compareCanonicalIntegers(int1, int2);
    }

    static int compareBytes(String int1, String int2) {
        int1 = XmlDatatypeUtil.normalizeByte(int1);
        int2 = XmlDatatypeUtil.normalizeByte(int2);
        return XmlDatatypeUtil.compareCanonicalIntegers(int1, int2);
    }

    static int compareUnsignedLongs(String int1, String int2) {
        int1 = XmlDatatypeUtil.normalizeUnsignedLong(int1);
        int2 = XmlDatatypeUtil.normalizeUnsignedLong(int2);
        return XmlDatatypeUtil.compareCanonicalIntegers(int1, int2);
    }

    static int compareUnsignedInts(String int1, String int2) {
        int1 = XmlDatatypeUtil.normalizeUnsignedInt(int1);
        int2 = XmlDatatypeUtil.normalizeUnsignedInt(int2);
        return XmlDatatypeUtil.compareCanonicalIntegers(int1, int2);
    }

    static int compareUnsignedShorts(String int1, String int2) {
        int1 = XmlDatatypeUtil.normalizeUnsignedShort(int1);
        int2 = XmlDatatypeUtil.normalizeUnsignedShort(int2);
        return XmlDatatypeUtil.compareCanonicalIntegers(int1, int2);
    }

    static int compareUnsignedBytes(String int1, String int2) {
        int1 = XmlDatatypeUtil.normalizeUnsignedByte(int1);
        int2 = XmlDatatypeUtil.normalizeUnsignedByte(int2);
        return XmlDatatypeUtil.compareCanonicalIntegers(int1, int2);
    }

    static int compareFloats(String float1, String float2) {
        float1 = XmlDatatypeUtil.normalizeFloat(float1);
        float2 = XmlDatatypeUtil.normalizeFloat(float2);
        return XmlDatatypeUtil.compareCanonicalFloats(float1, float2);
    }

    static int compareCanonicalFloats(String float1, String float2) {
        return XmlDatatypeUtil.compareCanonicalFPNumbers(float1, float2);
    }

    static int compareDoubles(String double1, String double2) {
        double1 = XmlDatatypeUtil.normalizeDouble(double1);
        double2 = XmlDatatypeUtil.normalizeDouble(double2);
        return XmlDatatypeUtil.compareCanonicalDoubles(double1, double2);
    }

    static int compareCanonicalDoubles(String double1, String double2) {
        return XmlDatatypeUtil.compareCanonicalFPNumbers(double1, double2);
    }

    static int compareFPNumbers(String fp1, String fp2) {
        fp1 = XmlDatatypeUtil.normalizeFPNumber(fp1);
        fp2 = XmlDatatypeUtil.normalizeFPNumber(fp2);
        return XmlDatatypeUtil.compareCanonicalFPNumbers(fp1, fp2);
    }

    static int compareCanonicalFPNumbers(String float1, String float2) {
        if (float1.equals("NaN") || float2.equals("NaN")) {
            if (float1.equals(float2)) {
                return 0;
            }
            throw new IllegalArgumentException("NaN cannot be compared to other floats");
        }
        if (float1.equals("INF")) {
            return float2.equals("INF") ? 0 : 1;
        }
        if (float2.equals("INF")) {
            return -1;
        }
        if (float1.equals("-INF")) {
            return float2.equals("-INF") ? 0 : -1;
        }
        if (float2.equals("-INF")) {
            return 1;
        }
        if (float1.charAt(0) == '-' && float2.charAt(0) != '-') {
            return -1;
        }
        if (float2.charAt(0) == '-' && float1.charAt(0) != '-') {
            return 1;
        }
        int eIdx1 = float1.indexOf(69);
        String mantissa1 = float1.substring(0, eIdx1);
        String exponent1 = float1.substring(eIdx1 + 1);
        int eIdx2 = float2.indexOf(69);
        String mantissa2 = float2.substring(0, eIdx2);
        String exponent2 = float2.substring(eIdx2 + 1);
        int result = XmlDatatypeUtil.compareCanonicalIntegers(exponent1, exponent2);
        if (result != 0 && float1.charAt(0) == '-') {
            result = -result;
        }
        if (result == 0) {
            result = XmlDatatypeUtil.compareCanonicalDecimals(mantissa1, mantissa2);
        }
        return result;
    }

    static int compareDateTime(String value1, String value2) {
        DateTime dateTime1 = new DateTime(value1);
        DateTime dateTime2 = new DateTime(value2);
        dateTime1.normalize();
        dateTime2.normalize();
        return dateTime1.compareTo(dateTime2);
    }

    private static final boolean _isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private static class DateTime
    implements Cloneable,
    Comparable {
        private String _dateTimeString;
        private boolean _isNegativeYear;
        private String _year;
        private String _months;
        private String _days;
        private String _hours;
        private String _minutes;
        private String _seconds;
        private String _fractionalSeconds;
        private boolean _isNegativeTimezone;
        private String _hoursTimezone;
        private String _minutesTimezone;
        private int _iYear;
        private int _iMonths;
        private int _iDays;
        private int _iHours;
        private int _iMinutes;
        private int _iSeconds;
        private double _iFractionalSeconds;
        private int _iHoursTimezone;
        private int _iMinutesTimezone;
        private boolean _isNormalized = false;

        DateTime(String dateTimeString) {
            this._dateTimeString = dateTimeString;
            this._parseDateTimeString();
            this._setNumericFields();
            this._validateFieldValues();
        }

        private void _parseDateTimeString() {
            if (this._dateTimeString.length() < 19) {
                throw new IllegalArgumentException("String value too short to be a valid xsd:dateTime value: " + this._dateTimeString);
            }
            String errMsg = "Invalid xsd:dateTime value: " + this._dateTimeString;
            StringTokenizer st = new StringTokenizer(this._dateTimeString, "+-:.TZ", true);
            try {
                String token;
                this._year = st.nextToken();
                this._isNegativeYear = this._year.equals("-");
                if (this._isNegativeYear) {
                    this._year = st.nextToken();
                }
                this._verifyTokenValue(st.nextToken(), "-", errMsg);
                this._months = st.nextToken();
                this._verifyTokenValue(st.nextToken(), "-", errMsg);
                this._days = st.nextToken();
                this._verifyTokenValue(st.nextToken(), "T", errMsg);
                this._hours = st.nextToken();
                this._verifyTokenValue(st.nextToken(), ":", errMsg);
                this._minutes = st.nextToken();
                this._verifyTokenValue(st.nextToken(), ":", errMsg);
                this._seconds = st.nextToken();
                String string = token = st.hasMoreTokens() ? st.nextToken() : null;
                if (".".equals(token)) {
                    this._fractionalSeconds = st.nextToken();
                    String string2 = token = st.hasMoreTokens() ? st.nextToken() : null;
                }
                if ("+".equals(token) || "-".equals(token)) {
                    this._isNegativeTimezone = "-".equals(token);
                    this._hoursTimezone = st.nextToken();
                    this._verifyTokenValue(st.nextToken(), ":", errMsg);
                    this._minutesTimezone = st.nextToken();
                } else if ("Z".equals(token)) {
                    this._isNegativeTimezone = false;
                    this._minutesTimezone = "00";
                    this._hoursTimezone = "00";
                }
                if (st.hasMoreTokens()) {
                    throw new IllegalArgumentException(errMsg);
                }
            }
            catch (NoSuchElementException e) {
                throw new IllegalArgumentException(errMsg);
            }
        }

        private void _verifyTokenValue(String token, String expected, String errMsg) {
            if (!token.equals(expected)) {
                throw new IllegalArgumentException(errMsg);
            }
        }

        private void _setNumericFields() {
            try {
                this._iYear = Integer.parseInt(this._year);
                this._iMonths = Integer.parseInt(this._months);
                this._iDays = Integer.parseInt(this._days);
                this._iHours = Integer.parseInt(this._hours);
                this._iMinutes = Integer.parseInt(this._minutes);
                this._iSeconds = Integer.parseInt(this._seconds);
                if (this._fractionalSeconds != null) {
                    this._iFractionalSeconds = Double.parseDouble("0." + this._fractionalSeconds);
                }
                if (this._hoursTimezone != null) {
                    this._iHoursTimezone = Integer.parseInt(this._hoursTimezone);
                }
                if (this._minutesTimezone != null) {
                    this._iMinutesTimezone = Integer.parseInt(this._minutesTimezone);
                }
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("All fields must be numbers: " + this._dateTimeString);
            }
        }

        private void _validateFieldValues() {
            if (this._year.length() < 4) {
                throw new IllegalArgumentException("Year field requires at least 4 digits: " + this._dateTimeString);
            }
            if (this._months.length() != 2) {
                throw new IllegalArgumentException("Month field must be two digits: " + this._dateTimeString);
            }
            if (this._days.length() != 2) {
                throw new IllegalArgumentException("Days field must be two digits: " + this._dateTimeString);
            }
            if (this._hours.length() != 2) {
                throw new IllegalArgumentException("Hours field must be two digits: " + this._dateTimeString);
            }
            if (this._minutes.length() != 2) {
                throw new IllegalArgumentException("Minutes field must be two digits: " + this._dateTimeString);
            }
            if (this._seconds.length() != 2) {
                throw new IllegalArgumentException("Seconds field must be two digits: " + this._dateTimeString);
            }
            if (this._hoursTimezone != null) {
                if (this._hoursTimezone.length() != 2) {
                    throw new IllegalArgumentException("Timezone-hours field must be two digits: " + this._dateTimeString);
                }
                if (this._minutesTimezone.length() != 2) {
                    throw new IllegalArgumentException("Timezone-minutes field must be two digits: " + this._dateTimeString);
                }
            }
            if (this._year.length() > 4 && this._year.charAt(0) == '0') {
                throw new IllegalArgumentException("Leading zeros in years with more than 4 digits are prohibited: " + this._dateTimeString);
            }
            if (this._iYear == 0) {
                throw new IllegalArgumentException("0000 is not a valid year: " + this._dateTimeString);
            }
            if (this._iHours > 24) {
                throw new IllegalArgumentException("Invalid hour value: " + this._dateTimeString);
            }
            if (this._iMinutes > 59) {
                throw new IllegalArgumentException("Invalid minute value: " + this._dateTimeString);
            }
            if (this._iSeconds > 59) {
                throw new IllegalArgumentException("Invalid second value: " + this._dateTimeString);
            }
            if (this._iHours == 24 && (this._iMinutes != 0 || this._iSeconds != 0)) {
                throw new IllegalArgumentException("Invalid time: " + this._dateTimeString);
            }
            if (this._iHoursTimezone > 14 || this._iMinutesTimezone > 59 || this._iHoursTimezone == 14 && this._iMinutesTimezone != 0) {
                throw new IllegalArgumentException("Invalid timezone: " + this._dateTimeString);
            }
        }

        boolean isNormalized() {
            return this._isNormalized;
        }

        void normalize() {
            if (this._isNormalized) {
                return;
            }
            if (this._iHours == 24 || this._hoursTimezone != null && (this._iHoursTimezone != 0 || this._iMinutesTimezone != 0)) {
                GregorianCalendar cal = new GregorianCalendar(this._iYear, this._iMonths - 1, this._iDays, this._iHours, this._iMinutes, this._iSeconds);
                if (this._isNegativeYear) {
                    cal.set(0, 0);
                }
                if (this._isNegativeTimezone) {
                    ((Calendar)cal).add(11, this._iHoursTimezone);
                    ((Calendar)cal).add(12, this._iMinutesTimezone);
                } else {
                    ((Calendar)cal).add(11, -this._iHoursTimezone);
                    ((Calendar)cal).add(12, -this._iMinutesTimezone);
                }
                if (cal.get(0) == 0) {
                    this._isNegativeYear = true;
                }
                this._iYear = cal.get(1);
                this._iMonths = cal.get(2) + 1;
                this._iDays = cal.get(5);
                this._iHours = cal.get(11);
                this._iMinutes = cal.get(12);
                this._iSeconds = cal.get(13);
                this._year = this._int2string(this._iYear, 4);
                this._months = this._int2string(this._iMonths, 2);
                this._days = this._int2string(this._iDays, 2);
                this._hours = this._int2string(this._iHours, 2);
                this._minutes = this._int2string(this._iMinutes, 2);
                this._seconds = this._int2string(this._iSeconds, 2);
                if (this._hoursTimezone != null) {
                    this._iMinutesTimezone = 0;
                    this._iHoursTimezone = 0;
                    this._minutesTimezone = "00";
                    this._hoursTimezone = "00";
                    this._isNegativeTimezone = false;
                }
            }
            if (this._fractionalSeconds != null) {
                int zeroCount = 0;
                for (int i = this._fractionalSeconds.length() - 1; i >= 0 && this._fractionalSeconds.charAt(i) == '0'; --i) {
                    ++zeroCount;
                }
                if (zeroCount == this._fractionalSeconds.length()) {
                    this._fractionalSeconds = null;
                } else if (zeroCount > 0) {
                    this._fractionalSeconds = this._fractionalSeconds.substring(0, this._fractionalSeconds.length() - zeroCount);
                }
            }
            this._isNormalized = true;
        }

        private String _int2string(int iValue, int minDigits) {
            String result = String.valueOf(iValue);
            int zeroCount = minDigits - result.length();
            if (zeroCount > 0) {
                StringBuffer buf = new StringBuffer(minDigits);
                for (int i = 0; i < zeroCount; ++i) {
                    buf.append('0');
                }
                buf.append(result);
                result = buf.toString();
            }
            return result;
        }

        public String toString() {
            StringBuffer result = new StringBuffer(32);
            if (this._isNegativeYear) {
                result.append('-');
            }
            result.append(this._year);
            result.append('-');
            result.append(this._months);
            result.append('-');
            result.append(this._days);
            result.append('T');
            result.append(this._hours);
            result.append(':');
            result.append(this._minutes);
            result.append(':');
            result.append(this._seconds);
            if (this._fractionalSeconds != null) {
                result.append('.');
                result.append(this._fractionalSeconds);
            }
            if (this._hoursTimezone != null) {
                if (this._iHoursTimezone == 0 && this._iMinutesTimezone == 0) {
                    result.append("Z");
                } else {
                    if (this._isNegativeTimezone) {
                        result.append('-');
                    } else {
                        result.append('+');
                    }
                    result.append(this._hoursTimezone);
                    result.append(':');
                    result.append(this._minutesTimezone);
                }
            }
            return result.toString();
        }

        public int compareTo(Object other) {
            DateTime thisDT = this;
            DateTime otherDT = (DateTime)other;
            if (thisDT._hoursTimezone != null && (thisDT._iHoursTimezone != 0 || thisDT._iMinutesTimezone != 0)) {
                thisDT = (DateTime)thisDT.clone();
                thisDT.normalize();
            }
            if (otherDT._hoursTimezone != null && (otherDT._iHoursTimezone != 0 || otherDT._iMinutesTimezone != 0)) {
                otherDT = (DateTime)otherDT.clone();
                otherDT.normalize();
            }
            if (thisDT._isNegativeYear && !otherDT._isNegativeYear) {
                return -1;
            }
            if (!thisDT._isNegativeYear && otherDT._isNegativeYear) {
                return 1;
            }
            int result = 0;
            if (thisDT._iYear != otherDT._iYear) {
                result = thisDT._iYear - otherDT._iYear;
            } else if (thisDT._iMonths != otherDT._iMonths) {
                result = thisDT._iMonths - otherDT._iMonths;
            } else if (thisDT._iDays != otherDT._iDays) {
                result = thisDT._iDays - otherDT._iDays;
            } else if (thisDT._iHours != otherDT._iHours) {
                result = thisDT._iHours - otherDT._iHours;
            } else if (thisDT._iMinutes != otherDT._iMinutes) {
                result = thisDT._iMinutes - otherDT._iMinutes;
            } else if (thisDT._iSeconds != otherDT._iSeconds) {
                result = thisDT._iSeconds - otherDT._iSeconds;
            } else if (thisDT._iFractionalSeconds != otherDT._iFractionalSeconds) {
                int n = result = thisDT._iFractionalSeconds < otherDT._iFractionalSeconds ? -1 : 1;
            }
            if (thisDT._isNegativeYear) {
                result = -result;
            }
            return result;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

