/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.swkm.model2.importer;

import gr.forth.ics.swkm.model2.Model;
import gr.forth.ics.swkm.model2.Uri;
import gr.forth.ics.swkm.model2.importer.Attribute;
import gr.forth.ics.swkm.model2.importer.Configurer;
import gr.forth.ics.swkm.model2.importer.ConnectionTask;
import gr.forth.ics.swkm.model2.importer.DbConstants;
import gr.forth.ics.swkm.model2.importer.DbSynchronizer;
import gr.forth.ics.swkm.model2.importer.Jdbc;
import gr.forth.ics.swkm.model2.importer.RdfStore;
import gr.forth.ics.swkm.model2.importer.RdfStores;
import gr.forth.ics.swkm.model2.importer.SequenceTable;
import gr.forth.ics.swkm.model2.importer.Table;
import gr.forth.ics.swkm.model2.labels.PredefinedLabels;
import gr.forth.ics.swkm.model2.validation.Validator;
import gr.forth.ics.swkm.vocabulary.Owl;
import gr.forth.ics.swkm.vocabulary.Rdf;
import gr.forth.ics.swkm.vocabulary.RdfSchema;
import gr.forth.ics.swkm.vocabulary.RdfSuite;
import gr.forth.ics.swkm.vocabulary.XmlSchema;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.springframework.util.Assert;

abstract class AbstractStore
implements RdfStore {
    protected final Jdbc jdbc;
    protected final Tables commonTables;
    protected final Configurer conf;
    private final RdfStores.Representation representation;

    public AbstractStore(RdfStores.Representation representation, DataSource dataSource, Configurer conf) {
        Assert.notNull((Object)((Object)representation), (String)"Representation");
        Assert.notNull((Object)dataSource, (String)"DataSource");
        Assert.notNull((Object)conf, (String)"Configurer");
        this.representation = representation;
        this.jdbc = new Jdbc(dataSource);
        this.commonTables = new Tables(conf);
        this.conf = conf;
    }

    boolean isSchemaInitialized() {
        try {
            Jdbc.execute("SELECT * from %s", this.commonTables.representation.getName());
            return true;
        }
        catch (SQLException e) {
            return false;
        }
    }

    public final void initializeSchemaIfNeeded() throws SQLException {
        this.jdbc.doInConnection(new ConnectionTask<Void>(){

            @Override
            public Void execute() throws SQLException {
                Connection connection = Jdbc.connection();
                connection.setTransactionIsolation(8);
                connection.setAutoCommit(true);
                if (AbstractStore.this.isSchemaInitialized()) {
                    return null;
                }
                connection.setAutoCommit(false);
                AbstractStore.this.initialize();
                connection.commit();
                return null;
            }
        });
    }

    private void initialize() throws SQLException {
        this.commonTables.createCommonTables(this.representation);
        this.commonTables.createCommonIndexes();
        this.initializeRepresentation();
    }

    abstract void initializeRepresentation() throws SQLException;

    public void store(final Model model) throws SQLException {
        this.jdbc.doInConnection(new ConnectionTask<Void>(){

            @Override
            public Void execute() throws SQLException {
                AbstractStore.this.storeImpl(model);
                return null;
            }
        });
    }

    private void storeImpl(Model model) throws SQLException {
        try {
            DbSynchronizer synchronizer = DbSynchronizer.forModel(model);
            PredefinedLabels existingLabels = synchronizer.synchronize(RdfSuite.IMPORTER_SIDE_EFFECTS);
            Validator.defaultValidator().validateAndFailOnFirstError(model);
            for (Uri uri : existingLabels.getResourcesWithPredefinedLabels()) {
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        finally {
            model.triples().g(RdfSuite.IMPORTER_SIDE_EFFECTS).delete();
        }
    }

    static class AnonIds
    extends Table {
        public final Attribute att0 = this.newAttribute("att0", "INTEGER PRIMARY KEY");

        private AnonIds(Configurer conf) {
            super("AnonIds");
        }
    }

    static class ResourceIsDefinedBy
    extends ResourceNote {
        public final Attribute isDefinedBy;
        public final Attribute att2;
        public final Attribute att3;

        private ResourceIsDefinedBy(Configurer conf) {
            super("ResourceIsDefinedBy", conf);
            this.isDefinedBy = this.newAttribute("att1", "VARCHAR(%d)", conf.getSmallMaxLiteralLength());
            this.att2 = this.newAttribute("att2", "INTEGER");
            this.att3 = this.newAttribute("att3", "INTEGER");
        }
    }

    static class PropertyIsDefinedBy
    extends PropertyNote {
        public final Attribute isDefinedBy = this.newAttribute("att1", "INTEGER");
        public final Attribute att2 = this.newAttribute("att2", "INTEGER");

        private PropertyIsDefinedBy(Configurer conf) {
            super("PropertyIsDefinedBy");
        }
    }

    static class ClassIsDefinedBy
    extends ClassNote {
        public final Attribute isDefinedBy = this.newAttribute("att1", "INTEGER");
        public final Attribute att2 = this.newAttribute("att2", "INTEGER");

        private ClassIsDefinedBy(Configurer conf) {
            super("ClassIsDefinedBy");
        }
    }

    static class ResourceSeeAlso
    extends ResourceNote {
        public final Attribute seeAlso;
        public final Attribute att2;
        public final Attribute att3;

        private ResourceSeeAlso(Configurer conf) {
            super("ResourceSeeAlso", conf);
            this.seeAlso = this.newAttribute("att1", "VARCHAR(%d)", conf.getSmallMaxLiteralLength());
            this.att2 = this.newAttribute("att2", "INTEGER");
            this.att3 = this.newAttribute("att3", "INTEGER");
        }
    }

    static class PropertySeeAlso
    extends PropertyNote {
        public final Attribute seeAlso = this.newAttribute("att1", "INTEGER");
        public final Attribute att2 = this.newAttribute("att2", "INTEGER");

        private PropertySeeAlso(Configurer conf) {
            super("PropertySeeAlso");
        }
    }

    static class ClassSeeAlso
    extends ClassNote {
        public final Attribute seeAlso = this.newAttribute("att1", "INTEGER");
        public final Attribute att2 = this.newAttribute("att2", "INTEGER");

        private ClassSeeAlso(Configurer conf) {
            super("ClassSeeAlso");
        }
    }

    static class ResourceLabel
    extends ResourceNote {
        public final Attribute label;
        public final Attribute att2;
        public final Attribute att3;

        private ResourceLabel(Configurer conf) {
            super("ResourceLabel", conf);
            this.label = this.newAttribute("att1", "VARCHAR(%d)", conf.getSmallMaxLiteralLength());
            this.att2 = this.newAttribute("att2", "INTEGER");
            this.att3 = this.newAttribute("att3", "INTEGER");
        }
    }

    static class PropertyLabel
    extends PropertyNote {
        public final Attribute label;
        public final Attribute att2;

        private PropertyLabel(Configurer conf) {
            super("PropertyLabel");
            this.label = this.newAttribute("att1", "VARCHAR(%d)", conf.getSmallMaxLiteralLength());
            this.att2 = this.newAttribute("att2", "INTEGER");
        }
    }

    static class ClassLabel
    extends ClassNote {
        public final Attribute label;
        public final Attribute att2;

        private ClassLabel(Configurer conf) {
            super("ClassLabel");
            this.label = this.newAttribute("att1", "VARCHAR(%d)", conf.getSmallMaxLiteralLength());
            this.att2 = this.newAttribute("att2", "INTEGER");
        }
    }

    static class ResourceComment
    extends ResourceNote {
        public final Attribute comment = this.newAttribute("att1", "TEXT");
        public final Attribute att2 = this.newAttribute("att2", "INTEGER");
        public final Attribute att3 = this.newAttribute("att3", "INTEGER");

        private ResourceComment(Configurer conf) {
            super("ResourceComment", conf);
        }
    }

    static class PropertyComment
    extends PropertyNote {
        public final Attribute comment = this.newAttribute("att1", "TEXT");
        public final Attribute att2 = this.newAttribute("att2", "INTEGER");

        private PropertyComment(Configurer conf) {
            super("PropertyComment");
        }
    }

    static class ClassComment
    extends ClassNote {
        public final Attribute comment = this.newAttribute("att1", "TEXT");
        public final Attribute att2 = this.newAttribute("att2", "INTEGER");

        private ClassComment(Configurer conf) {
            super("ClassComment");
        }
    }

    static abstract class ResourceNote
    extends Table {
        public final Attribute resourceUri;

        private ResourceNote(String name, Configurer conf) {
            super(name);
            this.resourceUri = this.newAttribute("att0", "VARCHAR(%d)", conf.getMaxUriLength());
        }
    }

    static abstract class PropertyNote
    extends Table {
        public final Attribute propertyId = this.newAttribute("att0", "INTEGER");

        private PropertyNote(String name) {
            super(name);
        }
    }

    static abstract class ClassNote
    extends Table {
        public final Attribute classId = this.newAttribute("att0", "INTEGER");

        private ClassNote(String name) {
            super(name);
        }
    }

    static class BagTypes
    extends Table {
        public final Attribute att0 = this.newAttribute("att0", "INTEGER");
        public final Attribute att1 = this.newAttribute("att1", "INTEGER");
        public final Attribute att2 = this.newAttribute("att2", "INTEGER");

        private BagTypes(Configurer conf) {
            super("bagtypes");
        }
    }

    static class SequenceTypes
    extends Table {
        public final Attribute att0 = this.newAttribute("att0", "INTEGER");
        public final Attribute att1 = this.newAttribute("att1", "INTEGER");
        public final Attribute att2 = this.newAttribute("att2", "INTEGER");
        public final Attribute att3 = this.newAttribute("att3", "INTEGER");

        private SequenceTypes(Configurer conf) {
            super("seqtypes");
        }
    }

    static class MaxPostOrder
    extends Table {
        public final Attribute metaclassPostOrder = this.newAttribute("att0", "INTEGER NOT NULL");
        public final Attribute metapropertyPostOrder = this.newAttribute("att1", "INTEGER NOT NULL");
        public final Attribute classPostOrder = this.newAttribute("att2", "INTEGER NOT NULL");
        public final Attribute propertyPostOrder = this.newAttribute("att3", "INTEGER NOT NULL");

        private MaxPostOrder(Configurer conf) {
            super("max_postorder");
        }
    }

    static class Representation
    extends Table {
        public final Attribute type = this.newAttribute("att0", "INTEGER NOT NULL");

        private Representation(Configurer conf) {
            super("REPRESENTATION");
        }
    }

    static class Generator
    extends Table {
        public final Attribute namespaceCounter = this.newAttribute("att0", "INTEGER NOT NULL");
        public final Attribute anonymousCounter = this.newAttribute("att1", "INTEGER NOT NULL");
        public final Attribute thesaurusCounter = this.newAttribute("att2", "INTEGER NOT NULL");

        private Generator(Configurer conf) {
            super("Generator");
        }
    }

    static class PropertyAncestry
    extends Table {
        public final Attribute propertyId = this.newAttribute("att0", "INTEGER NOT NULL");
        public final Attribute namespaceId = this.newAttribute("att1", "INTEGER");
        public final Attribute ancestorPropertyId = this.newAttribute("att2", "INTEGER NOT NULL");
        public final Attribute isDirectChild = this.newAttribute("att3", "boolean NOT NULL");
        public final Attribute tripleId = this.newAttribute("att4", "INTEGER");

        private PropertyAncestry(Configurer conf) {
            super("Property_Anc");
        }
    }

    static class ClassAncestry
    extends Table {
        public final Attribute classId = this.newAttribute("att0", "INTEGER NOT NULL");
        public final Attribute namespaceId = this.newAttribute("att1", "INTEGER");
        public final Attribute ancestorClassId = this.newAttribute("att2", "INTEGER NOT NULL");
        public final Attribute isDirectChild = this.newAttribute("att3", "boolean NOT NULL");
        public final Attribute tripleId = this.newAttribute("att4", "INTEGER");

        private ClassAncestry(Configurer conf) {
            super("Class_Anc");
        }
    }

    static class SubProperty
    extends Table {
        public final Attribute subId = this.newAttribute("att0", "INTEGER NOT NULL");
        public final Attribute superId = this.newAttribute("att1", "INTEGER");
        public final Attribute index = this.newAttribute("att2", "INTEGER NOT NULL");
        public final Attribute tripleId = this.newAttribute("att3", "INTEGER");

        private SubProperty(Configurer conf) {
            super("SubProperty");
        }
    }

    static class SubClass
    extends Table {
        public final Attribute subId = this.newAttribute("att0", "INTEGER NOT NULL");
        public final Attribute superId = this.newAttribute("att1", "INTEGER");
        public final Attribute index = this.newAttribute("att2", "INTEGER NOT NULL");
        public final Attribute tripleId = this.newAttribute("att3", "INTEGER");

        private SubClass(Configurer conf) {
            super("SubClass");
        }
    }

    static class Enumeration
    extends Table {
        public final Attribute att0 = this.newAttribute("att0", "INTEGER NOT NULL");
        public final Attribute att1;

        private Enumeration(Configurer conf) {
            super("t" + DbConstants.getIdFor(RdfSuite.ENUMERATION));
            this.att1 = this.newAttribute("att1", "VARCHAR(%s) NOT NULL", conf.getMaxLiteralLength());
        }
    }

    static class Thesaurus
    extends Table {
        public final Attribute id = this.newAttribute("att0", "INTEGER PRIMARY KEY");
        public final Attribute att1 = this.newAttribute("att1", "INTEGER NOT NULL");
        public final Attribute att2 = this.newAttribute("att2", "INTEGER NOT NULL");

        private Thesaurus(Configurer conf) {
            super("t" + DbConstants.getIdFor(RdfSuite.THESAURUS));
        }
    }

    static class LiteralType
    extends Table {
        public final Attribute id = this.newAttribute("att0", "INTEGER PRIMARY KEY");
        public final Attribute namespaceId = this.newAttribute("att1", "INTEGER NOT NULL");
        public final Attribute localPart;
        public final Attribute kind;

        private LiteralType(Configurer conf) {
            super("t" + DbConstants.getIdFor(RdfSchema.LITERAL));
            this.localPart = this.newAttribute("att2", "VARCHAR(%s) NOT NULL", conf.getMaxLocalPartLength());
            this.kind = this.newAttribute("att3", "INTEGER UNIQUE");
        }

        public LiteralType insertXmlType(Uri uri) throws SQLException {
            this.insert(this.id, this.namespaceId, this.localPart, this.kind).values(DbConstants.getIdFor(uri), 3, uri.getLocalName(), DbConstants.getRqlKindFor(uri));
            return this;
        }
    }

    static class Graph
    extends Table {
        public final Attribute uri;
        public final Attribute id;

        private Graph(Configurer conf) {
            super("Graph");
            this.uri = this.newAttribute("att0", "VARCHAR(%s) NOT NULL", conf.getMaxPrefixLength());
            this.id = this.newAttribute("att1", "INTEGER NOT NULL");
        }
    }

    static class MetapropertyAncestry
    extends Table {
        public final Attribute childPostOrder = this.newAttribute("att0", "INTEGER NOT NULL");
        public final Attribute parentPostOrder = this.newAttribute("att1", "INTEGER");
        public final Attribute childIndex = this.newAttribute("att2", "INTEGER NOT NULL");
        public final Attribute isDirectChild = this.newAttribute("att3", "boolean NOT NULL");
        public final Attribute att4 = this.newAttribute("att4", "INTEGER");

        private MetapropertyAncestry(Configurer conf) {
            super("MetaProperty_Anc");
        }
    }

    static class MetaclassAncestry
    extends Table {
        public final Attribute childPostOrder = this.newAttribute("att0", "INTEGER NOT NULL");
        public final Attribute parentPostOrder = this.newAttribute("att1", "INTEGER");
        public final Attribute childIndex = this.newAttribute("att2", "INTEGER NOT NULL");
        public final Attribute isDirectChild = this.newAttribute("att3", "boolean NOT NULL");
        public final Attribute att4 = this.newAttribute("att4", "INTEGER");

        private MetaclassAncestry(Configurer conf) {
            super("Metaclass_Anc");
        }
    }

    static class SubMetaproperty
    extends Table {
        public final Attribute subPropertyId = this.newAttribute("att0", "INTEGER NOT NULL");
        public final Attribute superPropertyId = this.newAttribute("att1", "INTEGER");
        public final Attribute postOrder = this.newAttribute("att2", "INTEGER NOT NULL");
        public final Attribute att3 = this.newAttribute("att3", "INTEGER");

        private SubMetaproperty(Configurer conf) {
            super("SubMetaProperty");
        }
    }

    static class SubMetaclass
    extends Table {
        public final Attribute subClassId = this.newAttribute("att0", "INTEGER NOT NULL");
        public final Attribute superClassId = this.newAttribute("att1", "INTEGER");
        public final Attribute postOrder = this.newAttribute("att2", "INTEGER NOT NULL");
        public final Attribute att3 = this.newAttribute("att3", "INTEGER");

        private SubMetaclass(Configurer conf) {
            super("SubMetaClass");
        }
    }

    static class Metaclass
    extends Table {
        public final Attribute classId = this.newAttribute("att0", "INTEGER PRIMARY KEY");
        public final Attribute namespaceId = this.newAttribute("att1", "INTEGER NOT NULL");
        public final Attribute localPart;
        public final Attribute kind;
        public final Attribute att4;

        private Metaclass(Configurer conf) {
            super("MetaClass");
            this.localPart = this.newAttribute("att2", "VARCHAR(%s) NOT NULL", conf.getMaxLocalPartLength());
            this.kind = this.newAttribute("att3", "INTEGER NOT NULL");
            this.att4 = this.newAttribute("att4", "INTEGER");
        }

        public Metaclass insertRow(Uri uri, int nsId) throws SQLException {
            this.insert(this.classId, this.namespaceId, this.localPart, this.kind).values(DbConstants.getIdFor(uri), nsId, DbConstants.getNameFor(uri), DbConstants.getRqlKindFor(uri));
            return this;
        }
    }

    static class GraphspaceDependencies
    extends Table {
        public final Attribute att0 = this.newAttribute("att0", "INTEGER");
        public final Attribute att1 = this.newAttribute("att1", "INTEGER");
        public final Attribute att2 = this.newAttribute("att2", "INTEGER");

        public GraphspaceDependencies(Configurer conf) {
            super("Graphspace_Dependencies");
        }
    }

    static class Graphspace
    extends Table {
        public final Attribute id = this.newAttribute("att0", "INTEGER PRIMARY KEY");
        public final Attribute uri;

        private Graphspace(Configurer conf) {
            super("GraphSpace");
            this.uri = this.newAttribute("att1", "VARCHAR(%s) NOT NULL UNIQUE", conf.getMaxPrefixLength());
        }
    }

    static class NamespaceDependencies
    extends Table {
        public final Attribute att0 = this.newAttribute("att0", "INTEGER");
        public final Attribute att1 = this.newAttribute("att1", "INTEGER");

        public NamespaceDependencies(Configurer conf) {
            super("Namespace_Dependencies");
        }
    }

    static class Namespace
    extends Table {
        public final Attribute id = this.newAttribute("att0", "INTEGER PRIMARY KEY");
        public final Attribute uri;

        private Namespace(Configurer conf) {
            super("NameSpace");
            this.uri = this.newAttribute("att1", "VARCHAR(%s) NOT NULL UNIQUE", conf.getMaxPrefixLength());
        }
    }

    class Tables {
        protected final Namespace namespace;
        protected final Graphspace graphspace;
        protected final NamespaceDependencies namespaceDependencies;
        protected final GraphspaceDependencies graphspaceDependencies;
        protected final Metaclass metaclass;
        protected final SubMetaclass subMetaclass;
        protected final SubMetaproperty subMetaproperty;
        protected final MetaclassAncestry metaclassAncestry;
        protected final MetapropertyAncestry metapropertyAncestry;
        protected final Graph graph;
        protected final LiteralType literalType;
        protected final Thesaurus thesaurus;
        protected final Enumeration enumeration;
        protected final SubClass subClass;
        protected final SubProperty subProperty;
        protected final ClassAncestry classAncestry;
        protected final PropertyAncestry propertyAncestry;
        protected final Generator generator;
        protected final SequenceTable namespaceIdGenerator;
        protected final SequenceTable graphspaceIdGenerator;
        protected final SequenceTable tripleIdGenerator;
        protected final Representation representation;
        protected final MaxPostOrder maxPostOrder;
        protected final SequenceTypes sequenceTypes;
        protected final BagTypes bagTypes;
        protected final AnonIds anonIds;
        protected final ClassComment classComment;
        protected final ClassSeeAlso classSeeAlso;
        protected final ClassLabel classLabel;
        protected final ClassIsDefinedBy classIsDefinedBy;
        protected final PropertyComment propertyComment;
        protected final PropertySeeAlso propertySeeAlso;
        protected final PropertyLabel propertyLabel;
        protected final PropertyIsDefinedBy propertyIsDefinedBy;
        protected final ResourceComment resourceComment;
        protected final ResourceSeeAlso resourceSeeAlso;
        protected final ResourceLabel resourceLabel;
        protected final ResourceIsDefinedBy resourceIsDefinedBy;

        protected Tables(Configurer conf) {
            this.namespace = new Namespace(conf);
            this.graphspace = new Graphspace(conf);
            this.namespaceDependencies = new NamespaceDependencies(conf);
            this.graphspaceDependencies = new GraphspaceDependencies(conf);
            this.metaclass = new Metaclass(conf);
            this.subMetaclass = new SubMetaclass(conf);
            this.subMetaproperty = new SubMetaproperty(conf);
            this.metaclassAncestry = new MetaclassAncestry(conf);
            this.metapropertyAncestry = new MetapropertyAncestry(conf);
            this.graph = new Graph(conf);
            this.literalType = new LiteralType(conf);
            this.thesaurus = new Thesaurus(conf);
            this.enumeration = new Enumeration(conf);
            this.subClass = new SubClass(conf);
            this.subProperty = new SubProperty(conf);
            this.classAncestry = new ClassAncestry(conf);
            this.propertyAncestry = new PropertyAncestry(conf);
            this.generator = new Generator(conf);
            this.namespaceIdGenerator = new SequenceTable("nsid_generator", 6);
            this.graphspaceIdGenerator = new SequenceTable("gsid_generator", 2);
            this.tripleIdGenerator = new SequenceTable("tripleid_generator", 1);
            this.representation = new Representation(conf);
            this.maxPostOrder = new MaxPostOrder(conf);
            this.sequenceTypes = new SequenceTypes(conf);
            this.bagTypes = new BagTypes(conf);
            this.anonIds = new AnonIds(conf);
            this.classComment = new ClassComment(conf);
            this.classSeeAlso = new ClassSeeAlso(conf);
            this.classLabel = new ClassLabel(conf);
            this.classIsDefinedBy = new ClassIsDefinedBy(conf);
            this.propertyComment = new PropertyComment(conf);
            this.propertySeeAlso = new PropertySeeAlso(conf);
            this.propertyLabel = new PropertyLabel(conf);
            this.propertyIsDefinedBy = new PropertyIsDefinedBy(conf);
            this.resourceComment = new ResourceComment(conf);
            this.resourceSeeAlso = new ResourceSeeAlso(conf);
            this.resourceLabel = new ResourceLabel(conf);
            this.resourceIsDefinedBy = new ResourceIsDefinedBy(conf);
        }

        private void createTablePerClassField() throws SQLException {
            Table.createAllTablesDeclaredAsFields(this);
        }

        private void createCommonTables(RdfStores.Representation repr) throws SQLException {
            this.createTablePerClassField();
            this.graphspace.insert(this.graphspace.id, this.graphspace.uri).values(1, "DEFAULT#");
            this.namespace.insert(this.namespace.id, this.namespace.uri).values(1, Rdf.NAMESPACE.toString(Uri.Hash.WITH)).insert(this.namespace.id, this.namespace.uri).values(2, RdfSchema.NAMESPACE.toString(Uri.Hash.WITH)).insert(this.namespace.id, this.namespace.uri).values(3, XmlSchema.NAMESPACE.toString(Uri.Hash.WITH)).insert(this.namespace.id, this.namespace.uri).values(4, RdfSuite.NAMESPACE.toString(Uri.Hash.WITH)).insert(this.namespace.id, this.namespace.uri).values(5, Owl.NAMESPACE.toString(Uri.Hash.WITH));
            this.metaclass.insertRow(RdfSchema.CLASS, 2).insertRow(RdfSuite.DATA_PROPERTY, 1).insertRow(Rdf.PROPERTY, 1).insertRow(RdfSchema.LITERAL, 4).insertRow(RdfSuite.THESAURUS, 4).insertRow(RdfSuite.ENUMERATION, 4);
            this.subMetaclass.insert(this.subMetaclass.subClassId, this.subMetaclass.postOrder).values(DbConstants.getIdFor(RdfSchema.CLASS), DbConstants.getPostOrderFor(RdfSchema.CLASS));
            this.subMetaproperty.insert(this.subMetaproperty.subPropertyId, this.subMetaproperty.postOrder).values(DbConstants.getIdFor(Rdf.PROPERTY), DbConstants.getPostOrderFor(Rdf.PROPERTY));
            this.generator.insert(this.generator.namespaceCounter, this.generator.anonymousCounter, this.generator.thesaurusCounter).values(4, 0, 2000000000);
            this.subClass.insert(this.subClass.subId, this.subClass.index).values(DbConstants.getIdFor(RdfSchema.RESOURCE), DbConstants.getPostOrderFor(RdfSchema.RESOURCE));
            this.representation.insert(this.representation.type).values(repr.getCode());
            this.maxPostOrder.insert(this.maxPostOrder.metaclassPostOrder, this.maxPostOrder.metapropertyPostOrder, this.maxPostOrder.classPostOrder, this.maxPostOrder.propertyPostOrder).values(300, 1000000002, 300, 300);
            AbstractStore.this.commonTables.literalType.insert(AbstractStore.this.commonTables.literalType.id, AbstractStore.this.commonTables.literalType.namespaceId, AbstractStore.this.commonTables.literalType.localPart, AbstractStore.this.commonTables.literalType.kind).values(DbConstants.getIdFor(RdfSuite.GRAPH), 2, "Literal", DbConstants.getIdFor(RdfSuite.GRAPH));
            this.insertXmlTypes();
        }

        private void insertXmlTypes() throws SQLException {
            for (Uri uri : XmlSchema.getAllTypes()) {
                this.literalType.insertXmlType(uri);
            }
        }

        private void createCommonIndexes() throws SQLException {
            this.namespace.clusteredIndexOn("ns", this.namespace.id);
            this.namespaceDependencies.indexOn("ns_deps_idx", this.namespaceDependencies.att0, this.namespaceDependencies.att1);
            this.graph.clusteredIndexOn("g1", this.graph.id);
            this.subClass.clusteredIndexOn("cls_sub_idx", this.subClass.subId).indexOn("cls_super_idx", this.subClass.superId).indexOn("cls_index_idx", this.subClass.index);
            this.subProperty.clusteredIndexOn("p_sub_idx", this.subProperty.subId).indexOn("p_super_idx", this.subProperty.superId).indexOn("p_index_idx", this.subProperty.index);
            this.subMetaclass.indexOn("sm_att0", this.subMetaclass.subClassId).indexOn("sm_att1", this.subMetaclass.superClassId).indexOn("sm_att2", this.subMetaclass.postOrder);
            this.subMetaproperty.indexOn("smp_att0", this.subMetaproperty.subPropertyId).indexOn("smp_att1", this.subMetaproperty.superPropertyId).indexOn("smp_att2", this.subMetaproperty.postOrder);
            this.classAncestry.clusteredIndexOn("ca_att0", this.classAncestry.classId).indexOn("ca_att1", this.classAncestry.namespaceId).indexOn("ca_att2", this.classAncestry.ancestorClassId);
            this.propertyAncestry.clusteredIndexOn("pa_att0", this.propertyAncestry.propertyId).indexOn("pa_att1", this.propertyAncestry.namespaceId).indexOn("pa_att2", this.propertyAncestry.ancestorPropertyId);
            this.metaclassAncestry.indexOn("ma_att0", this.metaclassAncestry.childPostOrder).indexOn("ma_att1", this.metaclassAncestry.parentPostOrder).indexOn("ma_att2", this.metaclassAncestry.childIndex);
            this.metapropertyAncestry.indexOn("mpa_att0", this.metapropertyAncestry.childPostOrder).indexOn("mpa_att1", this.metapropertyAncestry.parentPostOrder).indexOn("mpa_att2", this.metapropertyAncestry.childIndex);
            this.sequenceTypes.indexOn("seq1_idx", this.sequenceTypes.att0).indexOn("seq2_idx", this.sequenceTypes.att1).indexOn("seq3_idx", this.sequenceTypes.att2).indexOn("seq4_idx", this.sequenceTypes.att3);
            this.bagTypes.indexOn("bag1_idx", this.bagTypes.att0).indexOn("bag2_idx", this.bagTypes.att1).indexOn("bag3_idx", this.bagTypes.att2);
            this.enumeration.indexOn("emum_id_idx", this.enumeration.att0);
        }
    }
}

