/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.swkm.model2.importer;

import gr.forth.ics.swkm.model2.importer.AbstractStore;
import gr.forth.ics.swkm.model2.importer.Attribute;
import gr.forth.ics.swkm.model2.importer.Configurer;
import gr.forth.ics.swkm.model2.importer.DbConstants;
import gr.forth.ics.swkm.model2.importer.Jdbc;
import gr.forth.ics.swkm.model2.importer.RdfStores;
import gr.forth.ics.swkm.model2.importer.Table;
import gr.forth.ics.swkm.vocabulary.Rdf;
import gr.forth.ics.swkm.vocabulary.RdfSchema;
import gr.forth.ics.swkm.vocabulary.RdfSuite;
import gr.forth.ics.swkm.vocabulary.XmlSchema;
import java.sql.SQLException;
import javax.sql.DataSource;

class HybridStore
extends AbstractStore {
    private final HybridTables hybridTables;

    public HybridStore(DataSource dataSource, Configurer conf) {
        super(RdfStores.Representation.HYBRID, dataSource, conf);
        this.hybridTables = new HybridTables(conf);
    }

    protected void initializeRepresentation() throws SQLException {
        this.hybridTables.createHybridTables();
        this.hybridTables.createRepresentationTables();
        this.hybridTables.createRepresentationIndexes();
    }

    private static class Resource
    extends Table {
        final Attribute att0;
        final Attribute att1;
        final Attribute att2;

        Resource(Configurer conf) {
            super("tc" + DbConstants.getIdFor(RdfSchema.RESOURCE));
            this.att0 = this.newAttribute("att0", "VARCHAR(%d) NOT NULL", conf.getMaxUriLength());
            this.att1 = this.newAttribute("att1", "INTEGER NOT NULL");
            this.att2 = this.newAttribute("att2", "INTEGER");
        }
    }

    private static class DataProperty
    extends Table {
        final Attribute att0 = this.newAttribute("att0", "INTEGER PRIMARY KEY");
        final Attribute att1 = this.newAttribute("att1", "INTEGER NOT NULL");
        final Attribute att2;
        final Attribute att3;
        final Attribute att4;
        final Attribute att5;
        final Attribute att6;
        final Attribute att7;
        final Attribute att8;
        final Attribute att9;
        final Attribute att10;
        final Attribute att11;

        DataProperty(Configurer conf) {
            super("t" + DbConstants.getIdFor(RdfSuite.DATA_PROPERTY));
            this.att2 = this.newAttribute("att2", "VARCHAR(%d) NOT NULL", conf.getMaxLocalPartLength());
            this.att3 = this.newAttribute("att3", "INTEGER NOT NULL");
            this.att4 = this.newAttribute("att4", "INTEGER NOT NULL");
            this.att5 = this.newAttribute("att5", "INTEGER NOT NULL");
            this.att6 = this.newAttribute("att6", "INTEGER NOT NULL");
            this.att7 = this.newAttribute("att7", "INTEGER NOT NULL");
            this.att8 = this.newAttribute("att8", "VARCHAR(10) NOT NULL");
            this.att9 = this.newAttribute("att9", "INTEGER");
            this.att10 = this.newAttribute("att10", "INTEGER");
            this.att11 = this.newAttribute("att11", "INTEGER");
        }
    }

    private static class Property
    extends Table {
        final Attribute post = this.newAttribute("att0", "INTEGER PRIMARY KEY");
        final Attribute nsId = this.newAttribute("att1", "INTEGER NOT NULL");
        final Attribute localPart;
        final Attribute domainId;
        final Attribute rangeId;
        final Attribute domainKind;
        final Attribute rangeKind;
        final Attribute typeId;
        final Attribute propertyTableId;
        final Attribute propertyTripleId;
        final Attribute domainTripleId;
        final Attribute rangeTripleId;

        Property(Configurer conf) {
            super("t" + DbConstants.getIdFor(Rdf.PROPERTY));
            this.localPart = this.newAttribute("att2", "VARCHAR(%d) NOT NULL", conf.getMaxLocalPartLength());
            this.domainId = this.newAttribute("att3", "INTEGER NOT NULL");
            this.rangeId = this.newAttribute("att4", "INTEGER NOT NULL");
            this.domainKind = this.newAttribute("att5", "INTEGER NOT NULL");
            this.rangeKind = this.newAttribute("att6", "INTEGER NOT NULL");
            this.typeId = this.newAttribute("att7", "INTEGER NOT NULL");
            this.propertyTableId = this.newAttribute("att8", "VARCHAR(10) NOT NULL");
            this.propertyTripleId = this.newAttribute("att9", "INTEGER");
            this.domainTripleId = this.newAttribute("att10", "INTEGER");
            this.rangeTripleId = this.newAttribute("att11", "INTEGER");
        }
    }

    private static class Classes
    extends Table {
        final Attribute att0 = this.newAttribute("att0", "INTEGER");
        final Attribute att1 = this.newAttribute("att1", "INTEGER NOT NULL");
        final Attribute att2;
        final Attribute att3;
        final Attribute att4;

        Classes(Configurer conf) {
            super("t" + DbConstants.getIdFor(RdfSchema.CLASS));
            this.att2 = this.newAttribute("att2", "VARCHAR(%d) NOT NULL", conf.getMaxLocalPartLength());
            this.att3 = this.newAttribute("att3", "INTEGER NOT NULL");
            this.att4 = this.newAttribute("att4", "INTEGER");
            this.newConstraint("post_type_post PRIMARY KEY(att0, att3)");
        }
    }

    private class HybridTables {
        private final Classes classes;
        private final Property property;
        private final DataProperty dataProperty;
        private final Resource resource;

        HybridTables(Configurer conf) {
            this.classes = new Classes(conf);
            this.property = new Property(conf);
            this.dataProperty = new DataProperty(conf);
            this.resource = new Resource(conf);
        }

        private void createTablePerClassField() throws SQLException {
            Table.createAllTablesDeclaredAsFields(this);
        }

        private void createHybridTables() throws SQLException {
            this.createTablePerClassField();
            this.classes.insert(this.classes.att0, this.classes.att1, this.classes.att2, this.classes.att3).values(DbConstants.getIdFor(RdfSchema.RESOURCE), 2, "Resource", DbConstants.getIdFor(RdfSchema.CLASS));
        }

        private void createRepresentationTables() throws SQLException {
            this.createAllPropertyTables();
        }

        private void createAllPropertyTables() throws SQLException {
            int[] domains;
            String sqlType = "VARCHAR(" + HybridStore.this.conf.getMaxUriLength() + ")";
            for (int domain : domains = new int[]{DbConstants.getRqlKindFor(RdfSchema.RESOURCE)}) {
                this.createTables(domain, sqlType);
            }
            sqlType = "INTEGER";
            for (int domain : domains = new int[]{DbConstants.getRqlKindFor(RdfSchema.CLASS), DbConstants.getRqlKindFor(Rdf.PROPERTY)}) {
                this.createTables(domain, sqlType);
            }
        }

        private void createTables(final int domain, final String domainType) throws SQLException {
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class PropertyGroup {
                PropertyGroup(String rangeType, int[] rangeKinds) throws SQLException {
                    HybridTables.this.createTables(domain, domainType, rangeKinds, rangeType);
                }
            }
            new PropertyGroup("VARCHAR(" + HybridStore.this.conf.getMaxUriLength() + ")", new int[]{DbConstants.getRqlKindFor(RdfSchema.RESOURCE), DbConstants.getRqlKindFor(RdfSuite.ENUMERATION)});
            new PropertyGroup("VARCHAR(" + HybridStore.this.conf.getMaxUriLength() + ")", new int[]{DbConstants.getRqlKindFor(RdfSuite.GRAPH)});
            new PropertyGroup("INTEGER", new int[]{DbConstants.getRqlKindFor(RdfSchema.CLASS), DbConstants.getRqlKindFor(Rdf.PROPERTY), DbConstants.getRqlKindFor(RdfSuite.THESAURUS), DbConstants.getRqlKindFor(XmlSchema.INTEGER), DbConstants.getRqlKindFor(XmlSchema.NON_POSITIVE_INTEGER), DbConstants.getRqlKindFor(XmlSchema.NEGATIVE_INTEGER), DbConstants.getRqlKindFor(XmlSchema.INT), DbConstants.getRqlKindFor(XmlSchema.NON_NEGATIVE_INTEGER), DbConstants.getRqlKindFor(XmlSchema.UNSIGNED_INT), DbConstants.getRqlKindFor(XmlSchema.POSITIVE_INTEGER)});
            new PropertyGroup("VARCHAR(" + HybridStore.this.conf.getMaxLiteralLength() + ")", new int[]{DbConstants.getRqlKindFor(XmlSchema.STRING), DbConstants.getRqlKindFor(XmlSchema.HEX_BINARY), DbConstants.getRqlKindFor(XmlSchema.ANY_URI), DbConstants.getRqlKindFor(XmlSchema.QNAME), DbConstants.getRqlKindFor(XmlSchema.NOTATION), DbConstants.getRqlKindFor(XmlSchema.NORMALIZED_STRING), DbConstants.getRqlKindFor(XmlSchema.TOKEN), DbConstants.getRqlKindFor(XmlSchema.LANGUAGE), DbConstants.getRqlKindFor(XmlSchema.NMTOKEN), DbConstants.getRqlKindFor(XmlSchema.NMTOKENS), DbConstants.getRqlKindFor(XmlSchema.NAME), DbConstants.getRqlKindFor(XmlSchema.NCNAME), DbConstants.getRqlKindFor(XmlSchema.ID), DbConstants.getRqlKindFor(XmlSchema.IDREF), DbConstants.getRqlKindFor(XmlSchema.IDREFS), DbConstants.getRqlKindFor(XmlSchema.ENTITY), DbConstants.getRqlKindFor(XmlSchema.ENTITIES)});
            new PropertyGroup("date", new int[]{DbConstants.getRqlKindFor(XmlSchema.DATE), DbConstants.getRqlKindFor(XmlSchema.GYEAR_MONTH), DbConstants.getRqlKindFor(XmlSchema.GYEAR), DbConstants.getRqlKindFor(XmlSchema.GMONTH_DAY), DbConstants.getRqlKindFor(XmlSchema.GDAY), DbConstants.getRqlKindFor(XmlSchema.GMONTH)});
            new PropertyGroup("boolean", new int[]{DbConstants.getRqlKindFor(XmlSchema.BOOLEAN)});
            new PropertyGroup("numeric", new int[]{DbConstants.getRqlKindFor(XmlSchema.DECIMAL)});
            new PropertyGroup("real", new int[]{DbConstants.getRqlKindFor(XmlSchema.FLOAT)});
            new PropertyGroup("float8", new int[]{DbConstants.getRqlKindFor(XmlSchema.DOUBLE)});
            new PropertyGroup("interval", new int[]{DbConstants.getRqlKindFor(XmlSchema.DURATION)});
            new PropertyGroup("timestamp with time zone", new int[]{DbConstants.getRqlKindFor(XmlSchema.DATETIME)});
            new PropertyGroup("time with time zone", new int[]{DbConstants.getRqlKindFor(XmlSchema.TIME)});
            new PropertyGroup("bytea", new int[]{DbConstants.getRqlKindFor(XmlSchema.BASE64_BINARY)});
            new PropertyGroup("bigint", new int[]{DbConstants.getRqlKindFor(XmlSchema.LONG), DbConstants.getRqlKindFor(XmlSchema.UNSIGNED_LONG)});
            new PropertyGroup("smallint", new int[]{DbConstants.getRqlKindFor(XmlSchema.SHORT), DbConstants.getRqlKindFor(XmlSchema.BYTE), DbConstants.getRqlKindFor(XmlSchema.UNSIGNED_SHORT), DbConstants.getRqlKindFor(XmlSchema.UNSIGNED_BYTE)});
        }

        private void createTables(int domain, String domainType, int[] rangeKinds, String rangeType) throws SQLException {
            for (int range : rangeKinds) {
                Jdbc.execute("CREATE TABLE tp%dk%d(att0 %s, att1 %s, att2 INTEGER, att3 INTEGER)", domain, range, domainType, rangeType);
                if (!HybridStore.this.conf.createIndexes()) continue;
                Jdbc.execute("CREATE INDEX idx%1$dk%2$d_from on tp%1$dk%2$d (att0)", domain, range);
                if (!rangeType.equalsIgnoreCase("bytea")) {
                    Jdbc.execute("CREATE INDEX idx%1$dk%2$d_to on tp%1$dk%2$d (att1)", domain, range);
                }
                Jdbc.execute("CREATE INDEX idx%1$dk%2$d_pid on tp%1$dk%2$d (att2)", domain, range);
                Jdbc.execute("CLUSTER idx%1$dk%2$d_pid on tp%1$dk%2$d", domain, range);
            }
        }

        private void createRepresentationIndexes() throws SQLException {
            if (HybridStore.this.conf.createIndexes()) {
                this.classes.indexOn("cls_type_idx", this.classes.att3).indexOn("cls_type_idx_on_local_name", this.classes.att2);
                this.resource.clusteredIndexOn("Inst_uri_idx", this.resource.att0).indexOn("Inst_id_idx", this.resource.att1);
                this.property.indexOn("p_id_idx", this.property.post).clusteredIndexOn("p_uri_idx", this.property.localPart).indexOn("p_type_idx", this.property.typeId).indexOn("p_table_idx", this.property.propertyTableId);
                this.dataProperty.indexOn("dp_id_idx", this.property.post).clusteredIndexOn("dp_uri_idx", this.property.localPart).indexOn("dp_type_idx", this.property.typeId).indexOn("dp_table_idx", this.property.propertyTableId);
            }
        }
    }
}

