/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.swkm.model2.importer;

import gr.forth.ics.swkm.model2.importer.ConnectionTask;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Jdbc {
    private static final ThreadLocal<Connection> localConnection = new ThreadLocal();
    private static final ThreadLocal<Statement> localStatement = new ThreadLocal();
    private final JdbcTemplate jdbcTemplate;

    Jdbc(DataSource dataSource) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    <R> R doInConnection(final ConnectionTask<R> connectionTask) throws SQLException {
        return (R)this.jdbcTemplate.execute(new ConnectionCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doInConnection(Connection con) throws SQLException {
                if (localConnection.get() != null) {
                    throw new IllegalStateException("Execution of nested tasks not supported");
                }
                boolean autoCommit = con.getAutoCommit();
                int isolationLevel = con.getTransactionIsolation();
                localConnection.set(con);
                localStatement.set(con.createStatement());
                try {
                    Object r = connectionTask.execute();
                    return r;
                }
                finally {
                    con.setAutoCommit(autoCommit);
                    con.setTransactionIsolation(isolationLevel);
                    ((Statement)localStatement.get()).close();
                    localStatement.remove();
                    localConnection.remove();
                }
            }
        });
    }

    static Connection connection() throws IllegalStateException {
        Connection c = localConnection.get();
        if (c == null) {
            throw new IllegalStateException("No current connection set in this thread. It should exist if a " + ConnectionTask.class + " was currently executing");
        }
        return c;
    }

    static Statement statement() throws IllegalStateException {
        Statement st = localStatement.get();
        if (st == null) {
            throw new IllegalStateException("No current connection set in this thread. It should exist if a " + ConnectionTask.class + " was currently executing");
        }
        return st;
    }

    static PreparedStatement prepared(String sql, Object ... args) throws IllegalStateException, SQLException {
        PreparedStatement ps = Jdbc.connection().prepareStatement(sql);
        int pos = 1;
        for (Object arg : args) {
            ps.setObject(pos++, arg);
        }
        return ps;
    }

    static void execute(String sql, Object ... args) throws SQLException {
        Jdbc.statement().execute(String.format(sql, args));
    }

    static ResultSet query(String sql, Object ... args) throws SQLException {
        return Jdbc.statement().executeQuery(String.format(sql, args));
    }
}

