/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.swkm.model2.importer;

import com.google.common.base.Join;
import gr.forth.ics.swkm.model2.importer.Attribute;
import gr.forth.ics.swkm.model2.importer.Jdbc;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

abstract class Table {
    private final String name;
    private final List<Attribute> attributes = new ArrayList<Attribute>(4);
    private final List<String> constraints = new ArrayList<String>(1);

    public Table(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    protected Attribute newAttribute(String name, String sqlDefinition) {
        Attribute attr = new Attribute(name, sqlDefinition);
        this.attributes.add(attr);
        return attr;
    }

    protected Attribute newAttribute(String name, String sqlDefinitionWithParams, Object ... params) {
        Attribute attr = new Attribute(name, String.format(sqlDefinitionWithParams, params));
        this.attributes.add(attr);
        return attr;
    }

    protected void newConstraint(String constraint) {
        Assert.notNull((Object)constraint);
        this.constraints.add(constraint);
    }

    public Table createTable() throws SQLException {
        Jdbc.execute(this.getCreateTableSql(), new Object[0]);
        return this;
    }

    protected void insert(Attribute[] attrs, Object[] values) throws SQLException {
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO ").append(this.getName());
        if (attrs.length > 0) {
            sb.append(" (").append(StringUtils.arrayToCommaDelimitedString((Object[])attrs)).append(")");
        }
        sb.append(" VALUES (");
        boolean hasPrevious = false;
        for (Object value : values) {
            if (hasPrevious) {
                sb.append(", ");
            }
            if (value == null) {
                sb.append("NULL");
            } else {
                sb.append("'").append(String.valueOf(value)).append("'");
            }
            hasPrevious = true;
        }
        sb.append(")");
        Jdbc.execute(sb.toString(), new Object[0]);
    }

    public Table createIndex(String indexName, boolean clustered, Attribute ... attrs) throws SQLException {
        Jdbc.execute(String.format("CREATE INDEX %s on %s (%s)", indexName, this.getName(), Join.join((String)",", (Object[])attrs)), new Object[0]);
        if (clustered) {
            Jdbc.execute(String.format("CLUSTER %s on %s", indexName, this.getName()), new Object[0]);
        }
        return this;
    }

    protected String getCreateTableSql() {
        if (this.attributes.isEmpty()) {
            throw new IllegalStateException("Cannot define CREATE TABLE sql with zero attributes");
        }
        StringBuilder sb = new StringBuilder(64);
        sb.append("CREATE TABLE ").append(this.getName()).append(" (");
        boolean hasPrevious = false;
        for (Attribute attr : this.attributes) {
            if (hasPrevious) {
                sb.append(", ");
            }
            attr.renderToSql(sb);
            hasPrevious = true;
        }
        for (String constraint : this.constraints) {
            sb.append(", CONSTRAINT ").append(constraint);
        }
        sb.append(")");
        return sb.toString();
    }

    public String toString() {
        return this.name;
    }

    public Values insert(Attribute ... attributes) {
        return new Values(attributes);
    }

    public Table indexOn(String indexName, Attribute ... attrs) throws SQLException {
        this.createIndex(indexName, false, attrs);
        return this;
    }

    public Table clusteredIndexOn(String indexName, Attribute ... attrs) throws SQLException {
        this.createIndex(indexName, true, attrs);
        return this;
    }

    protected static void createAllTablesDeclaredAsFields(Object instanceWithTablesAsFields) throws SQLException {
        for (Field f : instanceWithTablesAsFields.getClass().getDeclaredFields()) {
            if (!Table.class.isAssignableFrom(f.getType())) continue;
            f.setAccessible(true);
            try {
                Table t = (Table)f.get(instanceWithTablesAsFields);
                try {
                    t.createTable();
                }
                catch (SQLException e) {
                    throw (SQLException)new SQLException("Error while creating table: '" + t.getName() + "'").initCause(e);
                }
            }
            catch (IllegalAccessException e) {
                throw (AssertionError)((Object)((Throwable)((Object)new AssertionError())).initCause(e));
            }
            finally {
                f.setAccessible(false);
            }
        }
    }

    public class Values {
        private final Attribute[] attrs;

        private Values(Attribute ... attrs) {
            this.attrs = attrs;
        }

        public Table values(Object ... values) throws SQLException {
            Table.this.insert(this.attrs, values);
            return Table.this;
        }
    }
}

