/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.swkm.model2.index;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import gr.forth.ics.swkm.model2.Model;
import gr.forth.ics.swkm.model2.ObjectNode;
import gr.forth.ics.swkm.model2.RdfNode;
import gr.forth.ics.swkm.model2.RdfType;
import gr.forth.ics.swkm.model2.Resource;
import gr.forth.ics.swkm.model2.Triple;
import gr.forth.ics.swkm.model2.Uri;
import gr.forth.ics.swkm.model2.event.TypeChange;
import gr.forth.ics.swkm.model2.index.Index;
import gr.forth.ics.swkm.model2.index.ModelIndexer;
import gr.forth.ics.swkm.model2.index.ModelView;
import gr.forth.ics.swkm.model2.index.ObjectViewSupport;
import gr.forth.ics.swkm.model2.index.TripleBasedObjectViewSupport;
import gr.forth.ics.swkm.model2.index.TripleDeletionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelIndexerRefImpl
implements ModelIndexer {
    private final Set<Triple> triples = Sets.newLinkedHashSet();
    private Model model;
    private ModelView modelView;
    private static final Function<Resource, Uri> namespaceExtractor = new Function<Resource, Uri>(){

        public Uri apply(Resource resource) {
            return resource.getUri().getNamespaceUri();
        }
    };
    private static final Function<Triple, Iterable<Resource>> tripleResources = new Function<Triple, Iterable<Resource>>(){

        public Iterable<Resource> apply(Triple triple) {
            ArrayList list = Lists.newArrayListWithExpectedSize((int)3);
            for (ObjectNode objectNode : triple.nonLiterals()) {
                if (!(objectNode instanceof Resource)) continue;
                list.add((Resource)objectNode);
            }
            return list;
        }
    };

    @Override
    public void add(Resource namedGraph, Triple triple) {
        this.triples.add(triple);
    }

    @Override
    public Index indexFor(RdfNode node, TypeChange typeChange) {
        return new IndexImpl(node);
    }

    @Override
    public void delete(Triple triple) {
        this.triples.remove(triple);
    }

    @Override
    public void removeTripleFromNamedGraph(Resource namedGraph, Triple triple) {
    }

    @Override
    public ObjectViewSupport objectViewSupport() {
        return new TripleBasedObjectViewSupport(this, this.model);
    }

    @Override
    public boolean containsTriple(Triple triple) {
        return this.triples.contains(triple);
    }

    @Override
    public Iterable<Triple> findTriples(Resource g, ObjectNode s, Resource p, RdfNode o) {
        ArrayList results = Lists.newArrayList();
        for (Triple triple : this.triples) {
            if (g != null && !triple.graphs().contains(g) || s != null && s != triple.subject() || p != null && p != triple.predicate() || o != null && o != triple.object()) continue;
            results.add(triple);
        }
        return results;
    }

    @Override
    public void deleteTriples(Resource g, ObjectNode s, Resource p, RdfNode o, TripleDeletionListener listener) {
        Iterator<Triple> i = this.triples.iterator();
        while (i.hasNext()) {
            Triple triple = i.next();
            if (g != null && !triple.graphs().contains(g) || s != null && s != triple.subject() || p != null && p != triple.predicate() || o != null && o != triple.object()) continue;
            if (g != null) {
                listener.tripleRemovedFromNamedGraph(g, triple);
                continue;
            }
            listener.tripleDeleted(triple);
            i.remove();
        }
    }

    @Override
    public Iterable<RdfNode> find(RdfType type) {
        HashSet results = Sets.newHashSet();
        for (Triple triple : this.triples) {
            if (triple.subject().type() == type) {
                results.add(triple.subject());
            }
            if (triple.predicate().type() == type) {
                results.add(triple.predicate());
            }
            if (triple.object().type() == type) {
                results.add(triple.object());
            }
            if (type != RdfType.NAMED_GRAPH) continue;
            results.addAll(triple.graphs());
        }
        return results;
    }

    @Override
    public void setModelView(ModelView modelView) {
        this.modelView = modelView;
    }

    @Override
    public void setModel(Model model) {
        this.model = model;
    }

    private Iterable<Resource> allResources() {
        return Iterables.concat((Iterable)Iterables.transform(this.triples, tripleResources));
    }

    @Override
    public Iterable<Resource> findInNamespace(final RdfType type, final Uri namespace) {
        if (!type.isSchema()) {
            throw new IllegalArgumentException("Requested type: " + (Object)((Object)type) + " is not schema");
        }
        if (namespace.getLocalName().length() > 0) {
            throw new IllegalArgumentException("Uri: '" + namespace + "' is not purely a namespace; it also contains a local part");
        }
        return Iterables.filter(this.allResources(), (Predicate)new Predicate<Resource>(){

            public boolean apply(Resource resource) {
                return resource.type() == type && resource.getUri().hasEqualNamespace(namespace);
            }
        });
    }

    @Override
    public Set<Uri> namespaces() {
        return Sets.newHashSet((Iterable)Iterables.transform((Iterable)Iterables.filter(this.allResources(), (Predicate)new Predicate<Resource>(){

            public boolean apply(Resource resource) {
                return resource.type().isSchema();
            }
        }), namespaceExtractor));
    }

    @Override
    public int tripleCount() {
        return this.triples.size();
    }

    private static class IndexImpl
    implements Index {
        final RdfNode node;

        IndexImpl(RdfNode node) {
            this.node = node;
        }

        public RdfNode getNode() {
            return this.node;
        }
    }
}

