/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.swkm.model2.index;

import gr.forth.ics.swkm.model2.Resource;
import gr.forth.ics.swkm.model2.Triple;
import gr.forth.ics.swkm.model2.index.NamedGraphIndexer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NamedGraphIndexerImpl
implements NamedGraphIndexer {
    private final Map<Resource, List<Triple>> graphToTriples = new IdentityHashMap<Resource, List<Triple>>();

    @Override
    public Iterator<Resource> iterator() {
        return this.graphToTriples.keySet().iterator();
    }

    @Override
    public void add(Resource namedGraph, Triple triple) {
        List<Triple> triples = this.graphToTriples.get(namedGraph);
        if (triples == null) {
            triples = new ArrayList<Triple>();
            this.graphToTriples.put(namedGraph, triples);
        }
        triples.add(triple);
    }

    @Override
    public Collection<Triple> get(Resource namedGraph) {
        Collection triples = this.graphToTriples.get(namedGraph);
        return triples == null ? Collections.emptyList() : triples;
    }

    @Override
    public void removeTriple(Triple triple) {
        for (Resource namedGraph : triple.graphs()) {
            this.removeTriple(namedGraph, triple);
        }
    }

    @Override
    public void removeTriple(Resource namedGraph, Triple triple) {
        List<Triple> triples = this.graphToTriples.get(namedGraph);
        if (triples == null) {
            return;
        }
        triples.remove(triple);
    }
}

