/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.swkm.model2.index;

import gr.forth.ics.swkm.model2.RdfNode;
import gr.forth.ics.swkm.model2.RdfType;
import gr.forth.ics.swkm.model2.Resource;
import gr.forth.ics.swkm.model2.Triple;
import gr.forth.ics.swkm.model2.event.RdfNodeListener;
import gr.forth.ics.swkm.model2.event.TypeChange;
import gr.forth.ics.swkm.model2.index.NamedGraphIndexer;
import gr.forth.ics.swkm.model2.index.NodeIndex;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NodeListsNamedGraphIndexer
implements NamedGraphIndexer,
RdfNodeListener {
    Set<Resource> namedGraphs = new HashSet<Resource>(4);

    @Override
    public void add(Resource namedGraph, Triple triple) {
        NodeIndex.getIndex(namedGraph).addToNamedGraphs(triple);
    }

    @Override
    public Collection<Triple> get(Resource namedGraph) {
        return NodeIndex.getIndex(namedGraph).namedGraphs();
    }

    @Override
    public void removeTriple(Triple triple) {
        for (Resource ng : triple.graphs()) {
            this.removeTriple(ng, triple);
        }
    }

    @Override
    public void removeTriple(Resource namedGraph, Triple triple) {
        NodeIndex index = NodeIndex.getIndex(namedGraph);
        index.removeFrom(index.namedGraphs(), triple);
    }

    @Override
    public Iterator<Resource> iterator() {
        return this.namedGraphs.iterator();
    }

    @Override
    public void onTypeChange(RdfNode node, RdfType oldType, List<TypeChange> changeStack) {
        this.addNamedGraph(node);
    }

    @Override
    public void onNodeAddition(RdfNode node) {
        this.addNamedGraph(node);
    }

    private void addNamedGraph(RdfNode node) {
        if (node.type().isNamedGraph()) {
            this.namedGraphs.add((Resource)node);
        }
    }

    @Override
    public void onNodeDeletion(RdfNode node) {
        if (node.type().isNamedGraph()) {
            this.namedGraphs.remove(node);
        }
    }
}

