/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.swkm.model2.index;

import gr.forth.ics.swkm.model2.Model;
import gr.forth.ics.swkm.model2.ObjectNode;
import gr.forth.ics.swkm.model2.RdfNode;
import gr.forth.ics.swkm.model2.Resource;
import gr.forth.ics.swkm.model2.Triple;
import gr.forth.ics.swkm.model2.Triples;
import gr.forth.ics.swkm.model2.index.AbstractModelIndexer;
import gr.forth.ics.swkm.model2.index.NamedGraphIndexerImpl;
import gr.forth.ics.swkm.model2.index.ObjectViewSupport;
import gr.forth.ics.swkm.model2.index.QueryTriple;
import gr.forth.ics.swkm.model2.index.ResourceAny;
import gr.forth.ics.swkm.model2.index.TreeMultiMap;
import gr.forth.ics.swkm.model2.index.TripleBasedObjectViewSupport;
import gr.forth.ics.swkm.model2.index.TripleDeletionListener;
import gr.forth.ics.swkm.model2.index.TriplesComparator;
import java.util.Iterator;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TreeMapModelIndexer
extends AbstractModelIndexer {
    private TreeSet<Triple> spo = new TreeSet<Triple>(TriplesComparator.instance);
    private TreeMultiMap po = new TreeMultiMap(new TriplesComparator(){

        public int compare(Triple t1, Triple t2) {
            int dif = this.compare(t1.predicate(), t2.predicate());
            if (dif != 0) {
                return dif;
            }
            return this.compare(t1.object(), t2.object());
        }
    });
    private TreeMultiMap os = new TreeMultiMap(new TriplesComparator(){

        public int compare(Triple t1, Triple t2) {
            int dif = this.compare(t1.object(), t2.object());
            if (dif != 0) {
                return dif;
            }
            return this.compare(t1.subject(), t2.subject());
        }
    });

    public TreeMapModelIndexer() {
        super(new NamedGraphIndexerImpl());
    }

    private Iterable<Triple> findTriplesFromSPO(ObjectNode subject, Resource predicate, RdfNode object) {
        if (subject == null) {
            return this.spo.descendingSet();
        }
        QueryTriple fromElement = new QueryTriple(subject, predicate, object);
        QueryTriple toElement = new QueryTriple(subject, predicate, object);
        if (object == null) {
            fromElement.setObject(ResourceAny.minimum);
            toElement.setObject(ResourceAny.maximum);
            if (predicate == null) {
                fromElement.setPredicate(ResourceAny.minimum);
                toElement.setPredicate(ResourceAny.maximum);
            }
        }
        return this.spo.subSet(fromElement, true, toElement, true);
    }

    private Iterable<Triple> findTriplesFromPO(Resource predicate) {
        return this.po.subSet(this.poQueryTriple(predicate, ResourceAny.minimum), this.poQueryTriple(predicate, ResourceAny.maximum));
    }

    private Iterable<Triple> findTriplesFromOS(RdfNode object) {
        return this.os.subSet(this.osQueryTriple(object, ResourceAny.minimum), this.osQueryTriple(object, ResourceAny.maximum));
    }

    public Iterable<Triple> findTriples(ObjectNode s, Resource p, RdfNode o) {
        int count = 0;
        if (s != null) {
            count |= 4;
        }
        if (p != null) {
            count |= 2;
        }
        if (o != null) {
            count |= 1;
        }
        switch (count) {
            case 0: {
                return this.spo;
            }
            case 4: 
            case 6: 
            case 7: {
                return this.findTriplesFromSPO(s, p, o);
            }
            case 2: {
                return this.findTriplesFromPO(p);
            }
            case 3: {
                return this.po.get(new QueryTriple(ResourceAny.minimum, p, o));
            }
            case 1: {
                return this.findTriplesFromOS(o);
            }
        }
        return this.os.get(new QueryTriple(s, ResourceAny.minimum, o));
    }

    public Triples findTriples(Resource namedGraph, ObjectNode subject, Resource predicate, RdfNode object) {
        Iterable<Triple> triples = this.findTriples(subject, predicate, object);
        if (triples == null) {
            return Triples.empty();
        }
        if (namedGraph == null) {
            return new Triples(triples);
        }
        if (triples == this.spo) {
            return new Triples(this.graphIndexer.get(namedGraph));
        }
        return AbstractModelIndexer.findTriples(triples, namedGraph);
    }

    @Override
    public boolean containsTriple(Triple triple) {
        return this.spo.contains(triple);
    }

    @Override
    public void add(Resource namedGraph, Triple triple) {
        this.graphIndexer.add(namedGraph, triple);
        if (!this.spo.add(triple)) {
            return;
        }
        this.po.put(this.poQueryTriple(triple.predicate(), triple.object()), triple);
        this.os.put(this.osQueryTriple(triple.object(), triple.subject()), triple);
    }

    private QueryTriple poQueryTriple(Resource predicate, RdfNode object) {
        return new QueryTriple(ResourceAny.minimum, predicate, object);
    }

    private QueryTriple osQueryTriple(RdfNode object, ObjectNode subject) {
        return new QueryTriple(subject, ResourceAny.minimum, object);
    }

    public ObjectViewSupport objectViewSupport(Model model) {
        return new TripleBasedObjectViewSupport(this, model);
    }

    private void delete(Triple triple, boolean tryDeleteFromAll) {
        if (!this.spo.remove(triple) && !tryDeleteFromAll) {
            return;
        }
        this.po.remove(this.poQueryTriple(triple.predicate(), triple.object()), triple);
        this.os.remove(this.osQueryTriple(triple.object(), triple.subject()), triple);
        this.graphIndexer.removeTriple(triple);
    }

    @Override
    public void delete(Triple triple) {
        this.delete(triple, false);
    }

    @Override
    public void deleteTriples(Resource g, ObjectNode s, Resource p, RdfNode o, TripleDeletionListener listener) {
        if (g != null) {
            this.deleteFromNamedGraph(g, s, p, o, listener);
            return;
        }
        Iterator<Triple> triples = this.findTriples(s, p, o).iterator();
        while (triples.hasNext()) {
            Triple triple = triples.next();
            triples.remove();
            this.delete(triple, true);
            listener.tripleDeleted(triple);
        }
    }

    @Override
    public int tripleCount() {
        return this.spo.size();
    }
}

