/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.swkm.model2.index;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import gr.forth.ics.swkm.model2.Model;
import gr.forth.ics.swkm.model2.ObjectNode;
import gr.forth.ics.swkm.model2.RdfNode;
import gr.forth.ics.swkm.model2.RdfType;
import gr.forth.ics.swkm.model2.Resource;
import gr.forth.ics.swkm.model2.Transitively;
import gr.forth.ics.swkm.model2.Triple;
import gr.forth.ics.swkm.model2.Triples;
import gr.forth.ics.swkm.model2.Uri;
import gr.forth.ics.swkm.model2.index.ModelIndexer;
import gr.forth.ics.swkm.model2.index.ObjectViewSupport;
import gr.forth.ics.swkm.vocabulary.Rdf;
import gr.forth.ics.swkm.vocabulary.RdfSchema;
import java.util.AbstractMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TripleBasedObjectViewSupport
implements ObjectViewSupport {
    protected final ModelIndexer indexer;
    protected final Model model;

    public TripleBasedObjectViewSupport(ModelIndexer indexer, Model model) {
        this.indexer = indexer;
        this.model = model;
    }

    @Override
    public Iterable<? extends RdfNode> findAncestors(Resource schemaResource, Transitively transitively) {
        return this.findRelatives(schemaResource, transitively, true);
    }

    @Override
    public Iterable<? extends RdfNode> findDescendants(Resource schemaResource, Transitively transitively) {
        return this.findRelatives(schemaResource, transitively, false);
    }

    private Iterable<? extends RdfNode> findRelatives(Resource schemaResource, Transitively transitively, boolean upward) {
        return transitively.collect(schemaResource, this.createIsaExplorer(this.getIsaPropertyFor(schemaResource), upward));
    }

    private Resource getIsaPropertyFor(Resource schemaResource) {
        Uri transitivePropertyUri = schemaResource.type().isProperty() ? RdfSchema.SUBPROPERTYOF : RdfSchema.SUBCLASSOF;
        return this.model.mapResource(transitivePropertyUri);
    }

    protected Iterable<? extends Resource> findDirectRelatives(Resource schemaResource, Resource transitiveProperty, boolean upward) {
        return upward ? this.model.triples().s(schemaResource).p(transitiveProperty).fetch().objects() : this.model.triples().p(transitiveProperty).o(schemaResource).fetch().subjects();
    }

    private Function<Resource, Iterable<? extends Resource>> createIsaExplorer(final Resource property, final boolean upward) {
        return new Function<Resource, Iterable<? extends Resource>>(){

            public Iterable<? extends Resource> apply(Resource resource) {
                return TripleBasedObjectViewSupport.this.findDirectRelatives(resource, property, upward);
            }
        };
    }

    @Override
    public Iterable<? extends RdfNode> findClassesOfIndividual(ObjectNode individual) {
        return this.model.triples().s(individual).p(Rdf.TYPE).fetch().objects();
    }

    @Override
    public Iterable<? extends RdfNode> findClassesOfMetaclass(Resource metaclass) {
        return this.model.triples().p(Rdf.TYPE).o(metaclass).fetch().subjects();
    }

    @Override
    public Iterable<? extends RdfNode> findIndividuals(Resource clazz) {
        return this.model.triples().p(Rdf.TYPE).o(clazz).fetch().subjects();
    }

    @Override
    public Iterable<? extends RdfNode> findMetaclassesOfClass(Resource clazz) {
        return this.model.triples().s(clazz).p(Rdf.TYPE).fetch().objects();
    }

    @Override
    public Iterable<? extends RdfNode> findPropertiesOfMetaproperty(Resource metaproperty) {
        return this.model.triples().p(Rdf.TYPE).o(metaproperty).fetch().subjects();
    }

    @Override
    public Iterable<? extends RdfNode> findPropertiesWithDomain(Resource domainClass) {
        return this.model.triples().p(RdfSchema.DOMAIN).o(domainClass).fetch().subjects();
    }

    @Override
    public Iterable<? extends RdfNode> findPropertiesWithRange(Resource domainClass) {
        return this.model.triples().p(RdfSchema.RANGE).o(domainClass).fetch().subjects();
    }

    @Override
    public Triples findPropertyInstances(Resource property) {
        return this.model.triples().p(property).fetch();
    }

    @Override
    public Iterable<? extends RdfNode> findDomainsOfProperty(Resource property) {
        return this.model.triples().s(property).p(RdfSchema.DOMAIN).fetch().objects();
    }

    @Override
    public Iterable<? extends RdfNode> findRangesOfProperty(Resource property) {
        return this.model.triples().s(property).p(RdfSchema.RANGE).fetch().objects();
    }

    @Override
    public boolean isFirstAncestorOfSecond(Resource maybeAncestor, Resource maybeDescendant) {
        if (maybeAncestor == maybeDescendant) {
            return true;
        }
        for (RdfNode rdfNode : this.findDescendants(maybeAncestor, Transitively.YES)) {
            if (maybeDescendant != rdfNode) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterable<? extends RdfNode> findMembersOfContainer(ObjectNode container) {
        AbstractMap members = container.type() == RdfType.SEQ ? Maps.newTreeMap() : Maps.newHashMap();
        for (Triple t : this.model.triples().s(container).fetch()) {
            Uri uri = t.predicate().getUri();
            try {
                if (!uri.hasEqualNamespace(Rdf.NAMESPACE) || !uri.getLocalName().startsWith("_")) continue;
                int index = Integer.parseInt(uri.getLocalName().substring(1));
                members.put(index, t.object());
            }
            catch (NumberFormatException e) {}
        }
        return members.values();
    }
}

