/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.swkm.model2.io;

import java.util.concurrent.atomic.AtomicInteger;
import org.openrdf.model.BNode;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.BNodeImpl;
import org.openrdf.model.impl.ValueFactoryImpl;

public abstract class BlankNodesPolicy {
    protected BlankNodesPolicy() {
    }

    public abstract String createIdentifier(String var1);

    public static BlankNodesPolicy globallyUnique() {
        return GloballyUniqueBlankNodesPolicy.instance;
    }

    public static BlankNodesPolicy asDeclared() {
        return AsDeclaredBlankNodesPolicy.instance;
    }

    ValueFactory valueFactory() {
        return new ValueFactoryImpl(){

            public BNode createBNode(String blankNodeId) {
                return new BNodeImpl(BlankNodesPolicy.this.createIdentifier(blankNodeId));
            }

            public BNode createBNode() {
                return this.createBNode(GloballyUniqueBlankNodesPolicy.instance.createIdentifier(null));
            }
        };
    }

    private static class AsDeclaredBlankNodesPolicy
    extends BlankNodesPolicy {
        static final AsDeclaredBlankNodesPolicy instance = new AsDeclaredBlankNodesPolicy();

        private AsDeclaredBlankNodesPolicy() {
        }

        public String createIdentifier(String localIdentifier) {
            return localIdentifier;
        }
    }

    private static class GloballyUniqueBlankNodesPolicy
    extends BlankNodesPolicy {
        static final GloballyUniqueBlankNodesPolicy instance = new GloballyUniqueBlankNodesPolicy();
        private static final AtomicInteger anonymousBlankNodeCounter = new AtomicInteger();

        private GloballyUniqueBlankNodesPolicy() {
        }

        public String createIdentifier(String localIdentifier) {
            return "bnode" + anonymousBlankNodeCounter.getAndIncrement();
        }
    }
}

