/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.swkm.model2.labels;

import org.springframework.util.Assert;

public final class Interval {
    private static final Interval empty = new Interval(0, -1);
    private final int index;
    private final int post;

    public Interval(int index, int post) {
        this.index = index;
        this.post = post;
    }

    public int getIndex() {
        return this.index;
    }

    public int getPost() {
        return this.post;
    }

    public boolean isEmpty() {
        return this.post < this.index;
    }

    public Interval intersection(Interval other) {
        Assert.notNull((Object)other);
        if (this.isEmpty()) {
            return this;
        }
        if (other.isEmpty()) {
            return other;
        }
        return new Interval(Math.max(this.index, other.index), Math.min(this.post, other.post));
    }

    public Interval union(Interval other) {
        Assert.notNull((Object)other);
        if (this.isEmpty()) {
            return other;
        }
        if (other.isEmpty()) {
            return this;
        }
        return new Interval(Math.min(this.index, other.index), Math.max(this.post, other.post));
    }

    public boolean contains(int point) {
        return this.index <= point && point <= this.post;
    }

    public boolean contains(Interval other) {
        Assert.notNull((Object)other);
        if (this.isEmpty() || other.isEmpty()) {
            return false;
        }
        return this.contains(other.index) && this.contains(other.post);
    }

    public boolean overlapsWith(Interval other) {
        Assert.notNull((Object)other);
        if (this.isEmpty() || other.isEmpty()) {
            return false;
        }
        return this.contains(other.index) || other.contains(this.index);
    }

    public boolean canBeMergedWith(Interval other) {
        Interval union = this.union(other);
        return union.length() <= this.length() + other.length();
    }

    public int length() {
        return Math.max(0, this.post - this.index + 1);
    }

    public Interval withIndex(int index) {
        return new Interval(index, this.post);
    }

    public Interval withPost(int post) {
        return new Interval(this.index, post);
    }

    public static Interval empty() {
        return empty;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Interval)) {
            return false;
        }
        Interval other = (Interval)obj;
        return this.index == other.index && this.post == other.post;
    }

    public int hashCode() {
        int hash = 7;
        hash = 59 * hash + this.index;
        hash = 59 * hash + this.post;
        return hash;
    }

    public String toString() {
        return "[" + this.index + ", " + this.post + "]";
    }
}

