/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.swkm.model2.labels;

import gr.forth.ics.swkm.model2.labels.CompoundInterval;
import gr.forth.ics.swkm.model2.labels.Interval;
import org.springframework.util.Assert;

public final class Label {
    private Interval treeLabel;
    private final CompoundInterval directPropagatedLabels;
    private final CompoundInterval indirectPropagatedLabels;

    public Label(Interval treeLabel) {
        this.setTreeLabel(treeLabel);
        this.directPropagatedLabels = new CompoundInterval();
        this.indirectPropagatedLabels = new CompoundInterval();
    }

    private Label(Interval treeLabel, CompoundInterval directPropagatedLabels, CompoundInterval indirectPropagatedLabels) {
        this.treeLabel = treeLabel;
        this.directPropagatedLabels = directPropagatedLabels;
        this.indirectPropagatedLabels = indirectPropagatedLabels;
    }

    public static Label create(int index, int post) {
        return new Label(new Interval(index, post));
    }

    public Interval getTreeLabel() {
        return this.treeLabel;
    }

    public void setTreeLabel(Interval treeLabel) {
        if (treeLabel == null) {
            treeLabel = Interval.empty();
        }
        this.treeLabel = treeLabel;
    }

    public boolean addPropagatedLabel(Interval label, boolean direct) {
        Assert.notNull((Object)label);
        if (this.treeLabel.contains(label)) {
            return false;
        }
        if (this.treeLabel.overlapsWith(label)) {
            throw new IllegalArgumentException("Cannot propagate a label that overlaps with the treeLabel! Propagated: " + label + ", treeLabel: " + this.treeLabel);
        }
        CompoundInterval intervals = direct ? this.directPropagatedLabels : this.indirectPropagatedLabels;
        return intervals.add(label);
    }

    public boolean removePropagatedLabel(Interval label, boolean direct) {
        Assert.notNull((Object)label);
        CompoundInterval intervals = direct ? this.directPropagatedLabels : this.indirectPropagatedLabels;
        return intervals.remove(label);
    }

    public CompoundInterval getPropagatedLabels(boolean direct) {
        CompoundInterval intervals = direct ? this.directPropagatedLabels : this.indirectPropagatedLabels;
        return new CompoundInterval(intervals);
    }

    public Label copy() {
        return new Label(this.treeLabel, new CompoundInterval(this.directPropagatedLabels), new CompoundInterval(this.indirectPropagatedLabels));
    }

    public boolean contains(int point) {
        return this.treeLabel.contains(point) || this.directPropagatedLabels.contains(point) || this.indirectPropagatedLabels.contains(point);
    }

    public boolean contains(Interval interval) {
        return this.treeLabel.contains(interval) || this.directPropagatedLabels.contains(interval) || this.indirectPropagatedLabels.contains(interval);
    }

    public boolean contains(Label label) {
        return this.treeLabel.contains(label.treeLabel) || this.directPropagatedLabels.contains(label.treeLabel) || this.indirectPropagatedLabels.contains(label.treeLabel);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(32);
        sb.append("[").append(this.treeLabel);
        if (!this.directPropagatedLabels.isEmpty()) {
            sb.append(", direct=" + this.directPropagatedLabels);
        }
        if (!this.indirectPropagatedLabels.isEmpty()) {
            sb.append(", indirect=" + this.indirectPropagatedLabels);
        }
        sb.append("]");
        return sb.toString();
    }

    public static Label newEmpty() {
        return new Label(Interval.empty());
    }

    public boolean equals(Object o) {
        if (!(o instanceof Label)) {
            return false;
        }
        Label that = (Label)o;
        return this.treeLabel.equals(that.treeLabel) && this.directPropagatedLabels.equals(that.directPropagatedLabels) && this.indirectPropagatedLabels.equals(that.indirectPropagatedLabels);
    }

    public int hashCode() {
        return 37 + 11 * this.treeLabel.hashCode() + 17 * this.directPropagatedLabels.hashCode() + 31 * this.indirectPropagatedLabels.hashCode();
    }
}

