/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.swkm.model2.labels;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import gr.forth.ics.graph.Node;
import gr.forth.ics.swkm.model2.Model;
import gr.forth.ics.swkm.model2.Resource;
import gr.forth.ics.swkm.model2.Triple;
import gr.forth.ics.swkm.model2.labels.Hierarchy;
import gr.forth.ics.swkm.model2.labels.Label;
import gr.forth.ics.swkm.model2.labels.LabelManager;
import gr.forth.ics.swkm.model2.labels.Labeler;
import gr.forth.ics.swkm.model2.labels.MainMemoryHierarchy;
import gr.forth.ics.swkm.model2.labels.PredefinedLabels;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Callable;

public class LabelManagers {
    private LabelManagers() {
    }

    public static class NonIncrementalMainMemoryManager
    implements LabelManager {
        private final Model model;
        private final Labeler labeler;
        private PredefinedLabels predefinedLabels;
        private Map<Resource, Label> resourcesToLabels = null;

        public NonIncrementalMainMemoryManager(Model model, Labeler labeler) {
            this.model = (Model)Preconditions.checkNotNull((Object)model);
            this.labeler = (Labeler)Preconditions.checkNotNull((Object)labeler);
        }

        private void clearLabels() {
            this.resourcesToLabels = null;
        }

        public Model getTargetModel() {
            return this.model;
        }

        public void tripleAdded(Triple triple) {
            this.clearLabels();
        }

        public void tripleDeleted(Triple triple) {
            this.clearLabels();
        }

        public boolean areLabelsAvailable() {
            return this.resourcesToLabels != null;
        }

        public void updateLabels(PredefinedLabels predefinedLabels) {
            if (this.areLabelsAvailable()) {
                return;
            }
            ArrayList hierarchyFactories = Lists.newArrayListWithExpectedSize((int)4);
            hierarchyFactories.add(new Callable<Hierarchy>(){

                @Override
                public Hierarchy call() {
                    return MainMemoryHierarchy.newClassHierarchy(NonIncrementalMainMemoryManager.this.model);
                }
            });
            hierarchyFactories.add(new Callable<Hierarchy>(){

                @Override
                public Hierarchy call() {
                    return MainMemoryHierarchy.newMetaclassHierarchy(NonIncrementalMainMemoryManager.this.model);
                }
            });
            hierarchyFactories.add(new Callable<Hierarchy>(){

                @Override
                public Hierarchy call() {
                    return MainMemoryHierarchy.newPropertyHierarchy(NonIncrementalMainMemoryManager.this.model);
                }
            });
            hierarchyFactories.add(new Callable<Hierarchy>(){

                @Override
                public Hierarchy call() {
                    return MainMemoryHierarchy.newMetapropertyHierarchy(NonIncrementalMainMemoryManager.this.model);
                }
            });
            this.resourcesToLabels = Maps.newHashMapWithExpectedSize((int)128);
            for (Callable hierarchyFactory : hierarchyFactories) {
                try {
                    Hierarchy hierarchy = (Hierarchy)hierarchyFactory.call();
                    if (hierarchy == null) continue;
                    this.labeler.assignLabels(hierarchy);
                    for (Node n : hierarchy.exploredGraph().nodes()) {
                        this.resourcesToLabels.put((Resource)n.getValue(), hierarchy.getLabelOf(n));
                    }
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }

        public boolean isFirstAncestorOfSecond(Resource maybeAncestor, Resource maybeDescendant) {
            if (this.resourcesToLabels == null) {
                this.updateLabels(this.predefinedLabels);
            }
            if (maybeAncestor.type() != maybeDescendant.type()) {
                return false;
            }
            Label ancestorLabel = this.resourcesToLabels.get(maybeAncestor);
            Label descendantLabel = this.resourcesToLabels.get(maybeDescendant);
            return ancestorLabel.contains(descendantLabel);
        }
    }
}

