/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.swkm.model2.util;

import com.google.common.base.Function;
import com.google.common.base.Join;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import gr.forth.ics.swkm.model2.Model;
import gr.forth.ics.swkm.model2.RdfNode;
import gr.forth.ics.swkm.model2.RdfType;
import gr.forth.ics.swkm.model2.Resource;
import gr.forth.ics.swkm.model2.Transitively;
import gr.forth.ics.swkm.model2.Triple;
import gr.forth.ics.swkm.model2.Uri;
import gr.forth.ics.swkm.model2.event.RdfNodeListener;
import gr.forth.ics.swkm.model2.event.TripleListener;
import gr.forth.ics.swkm.model2.event.TypeChange;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamespaceDependenciesIndex {
    private final Model model;
    private MyListener listener;
    private final Map<Uri, Multiset<Uri>> forwardDeps = Maps.newHashMap();
    private final Map<Uri, Multiset<Uri>> backwardDeps = Maps.newHashMap();
    private final Map<Direction, Function<Uri, Iterable<Uri>>> exploringFunctions = Maps.newEnumMap(Direction.class);

    public NamespaceDependenciesIndex(Model model) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class ExploringFunction
        implements Function<Uri, Iterable<Uri>> {
            private final Map<Uri, Multiset<Uri>> deps;

            ExploringFunction(Map<Uri, Multiset<Uri>> deps) {
                this.deps = deps;
            }

            public Iterable<Uri> apply(Uri uri) {
                return (Iterable)this.deps.get(uri);
            }
        }
        this.exploringFunctions.put(Direction.FORWARD, new ExploringFunction(this.forwardDeps));
        this.exploringFunctions.put(Direction.BACKWARD, new ExploringFunction(this.backwardDeps));
        this.model = (Model)Preconditions.checkNotNull((Object)model);
        this.listener = new MyListener();
        model.addRdfNodeListener(this.listener);
        model.addTripleListener(this.listener);
        for (Triple t : model.triples().fetch()) {
            this.tripleAdded(t);
        }
    }

    public void dettach() {
        if (this.listener != null) {
            this.model.removeRdfNodeListener(this.listener);
            this.model.removeTripleListener(this.listener);
            this.listener = null;
        }
    }

    public boolean isDettached() {
        return this.listener == null;
    }

    public Set<Uri> getDependencies(Uri namespace, Transitively transitively) {
        return transitively.collect(namespace, this.exploringFunctions.get((Object)Direction.FORWARD));
    }

    public Set<Uri> getDependants(Uri namespace, Transitively transitively) {
        return transitively.collect(namespace, this.exploringFunctions.get((Object)Direction.BACKWARD));
    }

    private Map<Uri, Multiset<Uri>> deps(Direction direction) {
        switch (direction) {
            case FORWARD: {
                return this.forwardDeps;
            }
            case BACKWARD: {
                return this.backwardDeps;
            }
        }
        throw new AssertionError();
    }

    private Multiset<Uri> depsPerNamespace(Map<Uri, Multiset<Uri>> deps, Uri namespace) {
        HashMultiset value = deps.get(namespace);
        if (value == null) {
            value = HashMultiset.create();
            deps.put(namespace, (Multiset<Uri>)value);
        }
        return value;
    }

    private void tripleAdded(Triple triple) {
        if (triple.subject().type().isSchema() && triple.object().type().isSchema()) {
            this.addDependency(((Resource)triple.subject()).getUri().getNamespaceUri(), ((Resource)triple.object()).getUri().getNamespaceUri());
        }
    }

    private void tripleDeleted(Triple triple) {
        if (triple.subject().type().isSchema() && triple.object().type().isSchema()) {
            this.removeDependency(((Resource)triple.subject()).getUri().getNamespaceUri(), ((Resource)triple.object()).getUri().getNamespaceUri());
        }
    }

    private void addDependency(Uri from, Uri to) {
        if (from.equals(to)) {
            return;
        }
        this.addDependency(from, to, Direction.FORWARD);
        this.addDependency(to, from, Direction.BACKWARD);
    }

    private void addDependency(Uri uri1, Uri uri2, Direction direction) {
        Map<Uri, Multiset<Uri>> deps = this.deps(direction);
        Multiset<Uri> depsOfNamespace = this.depsPerNamespace(deps, uri1);
        depsOfNamespace.add((Object)uri2);
    }

    private void removeDependency(Uri from, Uri to) {
        this.removeDependency(from, to, Direction.FORWARD);
        this.removeDependency(to, from, Direction.BACKWARD);
    }

    private void removeDependency(Uri uri1, Uri uri2, Direction direction) {
        Map<Uri, Multiset<Uri>> deps = this.deps(direction);
        Multiset<Uri> depsOfNamespace = this.depsPerNamespace(deps, uri1);
        depsOfNamespace.remove((Object)uri2);
        if (depsOfNamespace.isEmpty()) {
            deps.remove(uri1);
        }
    }

    public String toString() {
        final Map<Uri, Multiset<Uri>> deps = this.deps(Direction.FORWARD);
        return "{" + Join.join((String)", ", (Iterable)Iterables.transform(deps.keySet(), (Function)new Function<Uri, String>(){

            public String apply(final Uri uri) {
                return Join.join((String)", ", (Iterable)Iterables.transform((Iterable)((Multiset)deps.get(uri)).elementSet(), (Function)new Function<Uri, String>(){

                    public String apply(Uri uri2) {
                        return uri + "<->" + uri2;
                    }
                }));
            }
        })) + "}";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MyListener
    implements RdfNodeListener,
    TripleListener {
        private MyListener() {
        }

        @Override
        public void onNodeAddition(RdfNode node) {
        }

        @Override
        public void onNodeDeletion(RdfNode node) {
        }

        @Override
        public void onTypeChange(RdfNode node, RdfType oldType, List<TypeChange> changeStack) {
            if (node.type().isSchema() && !oldType.isSchema()) {
                Resource resource = (Resource)node;
                for (Triple t : NamespaceDependenciesIndex.this.model.triples().s(resource).fetch()) {
                    NamespaceDependenciesIndex.this.tripleAdded(t);
                }
                for (Triple t : NamespaceDependenciesIndex.this.model.triples().o(resource).fetch()) {
                    NamespaceDependenciesIndex.this.tripleAdded(t);
                }
            }
        }

        @Override
        public void onTripleAddition(Resource namedGraph, Triple triple) {
            if (triple.graphs().size() == 1) {
                NamespaceDependenciesIndex.this.tripleAdded(triple);
            }
        }

        @Override
        public void onTripleDeletion(Resource namedGraph, Triple triple) {
            if (triple.graphs().isEmpty()) {
                NamespaceDependenciesIndex.this.tripleDeleted(triple);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Direction {
        FORWARD,
        BACKWARD;

    }
}

