/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.swkm.model2.util;

import com.google.common.collect.Lists;
import gr.forth.ics.swkm.model2.Model;
import gr.forth.ics.swkm.model2.RdfNode;
import gr.forth.ics.swkm.model2.RdfType;
import gr.forth.ics.swkm.model2.Resource;
import gr.forth.ics.swkm.model2.Triple;
import gr.forth.ics.swkm.model2.Uri;
import gr.forth.ics.swkm.model2.util.UniqueNames;
import gr.forth.ics.swkm.vocabulary.Rdf;
import gr.forth.ics.swkm.vocabulary.RdfSchema;
import gr.forth.ics.swkm.vocabulary.RdfSuite;
import gr.forth.ics.util.RandomChooser;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandomTripleGenerator {
    private final Map<Event, Double> probabilities = new EnumMap<Event, Double>(Event.class);

    private RandomTripleGenerator() {
    }

    public static RandomTripleGenerator newEmpty() {
        return new RandomTripleGenerator();
    }

    public static RandomTripleGenerator newDefault() {
        RandomTripleGenerator tg = new RandomTripleGenerator();
        for (Event event : Event.values()) {
            tg.setProb(event, 1.0);
        }
        tg.setProb(Event.NEW_INDIVIDUAL, 0.5);
        tg.setProb(Event.NEW_BLANK_INDIVIDUAL, 0.5);
        tg.setProb(Event.NEW_STATEMENT, 0.5);
        tg.setProb(Event.NEW_BLANK_STATEMENT, 0.5);
        tg.setProb(Event.NEW_ALT, 0.5);
        tg.setProb(Event.NEW_BLANK_ALT, 0.5);
        tg.setProb(Event.NEW_SEQ, 0.5);
        tg.setProb(Event.NEW_BLANK_SEQ, 0.5);
        tg.setProb(Event.NEW_BAG, 0.5);
        tg.setProb(Event.NEW_BLANK_BAG, 0.5);
        return tg;
    }

    public RandomTripleGenerator setProb(Event event, Double probability) {
        this.probabilities.put(event, probability);
        return this;
    }

    public Double getProb(Event event) {
        Double prob = this.probabilities.get((Object)event);
        if (prob == null) {
            return 0.0;
        }
        return prob;
    }

    public Iterator<Triple> triplesFor(Model model) {
        Assert.notNull((Object)model);
        return new TripleStream(model, this);
    }

    static interface ModelAction {
        public Triple call();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TripleStream
    implements Iterator<Triple> {
        private final Model model;
        private final Random random = new Random(0L);
        private final UniqueNames names = new UniqueNames();
        private final Uri dummy = Uri.parse("http://ns#dummy");
        private final List<Resource> namedGraphs = Lists.newArrayList((Object[])new Resource[]{null});
        private final RandomChooser<ModelAction> actionChooser;

        TripleStream(Model model, RandomTripleGenerator tg) {
            this.model = model;
            this.actionChooser = RandomChooser.newInstance().setRandom(this.random).choice(tg.getProb(Event.NEW_NAMED_GRAPH).doubleValue(), (Object)new NewNamedGraph()).choice(tg.getProb(Event.NEW_INDIVIDUAL).doubleValue(), (Object)new NewIndividual()).choice(tg.getProb(Event.NEW_BLANK_INDIVIDUAL).doubleValue(), (Object)new NewBlankIndividual()).choice(tg.getProb(Event.NEW_CLASS).doubleValue(), (Object)new NewClass()).choice(tg.getProb(Event.NEW_PROPERTY).doubleValue(), (Object)new NewProperty()).choice(tg.getProb(Event.NEW_METACLASS).doubleValue(), (Object)new NewMetaclass()).choice(tg.getProb(Event.NEW_METAPROPERTY).doubleValue(), (Object)new NewMetaproperty()).choice(tg.getProb(Event.NEW_STATEMENT).doubleValue(), (Object)new NewStatement()).choice(tg.getProb(Event.NEW_BLANK_STATEMENT).doubleValue(), (Object)new NewBlankStatement()).choice(tg.getProb(Event.NEW_ALT).doubleValue(), (Object)new NewAlt()).choice(tg.getProb(Event.NEW_BLANK_ALT).doubleValue(), (Object)new NewBlankAlt()).choice(tg.getProb(Event.NEW_BAG).doubleValue(), (Object)new NewBag()).choice(tg.getProb(Event.NEW_BLANK_BAG).doubleValue(), (Object)new NewBlankBag()).choice(tg.getProb(Event.NEW_SEQ).doubleValue(), (Object)new NewSeq()).choice(tg.getProb(Event.NEW_BLANK_SEQ).doubleValue(), (Object)new NewBlankSeq()).choice(tg.getProb(Event.TURN_CLASS_TO_METACLASS).doubleValue(), (Object)new ClassToMetaclass()).choice(tg.getProb(Event.TURN_PROPERTY_TO_METAPROPERTY).doubleValue(), (Object)new PropertyToMetaproperty()).build();
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        @Override
        public Triple next() {
            ModelAction action;
            Triple triple;
            while ((triple = (action = (ModelAction)this.actionChooser.choose()).call()) == null) {
            }
            return triple;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private Resource randomGraph() {
            return this.namedGraphs.get(this.random.nextInt(this.namedGraphs.size()));
        }

        private class PropertyToMetaproperty
        implements ModelAction {
            private PropertyToMetaproperty() {
            }

            public Triple call() {
                ArrayList properties = Lists.newArrayList(TripleStream.this.model.findNodes(RdfType.PROPERTY));
                if (properties.isEmpty()) {
                    return null;
                }
                RdfNode property = (RdfNode)properties.get(TripleStream.this.random.nextInt(properties.size()));
                Uri uri = ((Resource)property).getUri();
                if (uri.getNamespace() == Rdf.NAMESPACE.getNamespace() || uri.getNamespace() == RdfSchema.NAMESPACE.getNamespace()) {
                    return null;
                }
                return TripleStream.this.model.add(TripleStream.this.randomGraph(), (Resource)property, TripleStream.this.model.mapResource(RdfSchema.SUBCLASSOF), TripleStream.this.model.mapResource(Rdf.PROPERTY));
            }
        }

        private class ClassToMetaclass
        implements ModelAction {
            private ClassToMetaclass() {
            }

            public Triple call() {
                ArrayList classes = Lists.newArrayList(TripleStream.this.model.findNodes(RdfType.CLASS));
                if (classes.isEmpty()) {
                    return null;
                }
                RdfNode clazz = (RdfNode)classes.get(TripleStream.this.random.nextInt(classes.size()));
                if (clazz.hasConstantType()) {
                    return null;
                }
                Uri uri = ((Resource)clazz).getUri();
                if (uri.getNamespace() == Rdf.NAMESPACE.getNamespace() || uri.getNamespace() == RdfSchema.NAMESPACE.getNamespace()) {
                    return null;
                }
                return TripleStream.this.model.add(TripleStream.this.randomGraph(), (Resource)clazz, TripleStream.this.model.mapResource(RdfSchema.SUBCLASSOF), TripleStream.this.model.mapResource(RdfSchema.CLASS));
            }
        }

        private class NewBlankSeq
        implements ModelAction {
            private NewBlankSeq() {
            }

            public Triple call() {
                return TripleStream.this.model.add(TripleStream.this.randomGraph(), TripleStream.this.model.mapBlankNode(TripleStream.this.names.nextBlankNode("seq")), TripleStream.this.model.mapResource(Rdf.TYPE), TripleStream.this.model.mapResource(Rdf.SEQ));
            }
        }

        private class NewSeq
        implements ModelAction {
            private NewSeq() {
            }

            public Triple call() {
                return TripleStream.this.model.add(TripleStream.this.randomGraph(), TripleStream.this.model.mapResource(TripleStream.this.names.nextUri("seq")), TripleStream.this.model.mapResource(Rdf.TYPE), TripleStream.this.model.mapResource(Rdf.SEQ));
            }
        }

        private class NewBlankBag
        implements ModelAction {
            private NewBlankBag() {
            }

            public Triple call() {
                return TripleStream.this.model.add(TripleStream.this.randomGraph(), TripleStream.this.model.mapBlankNode(TripleStream.this.names.nextBlankNode("bag")), TripleStream.this.model.mapResource(Rdf.TYPE), TripleStream.this.model.mapResource(Rdf.BAG));
            }
        }

        private class NewBag
        implements ModelAction {
            private NewBag() {
            }

            public Triple call() {
                return TripleStream.this.model.add(TripleStream.this.randomGraph(), TripleStream.this.model.mapResource(TripleStream.this.names.nextUri("bag")), TripleStream.this.model.mapResource(Rdf.TYPE), TripleStream.this.model.mapResource(Rdf.BAG));
            }
        }

        private class NewBlankAlt
        implements ModelAction {
            private NewBlankAlt() {
            }

            public Triple call() {
                return TripleStream.this.model.add(TripleStream.this.randomGraph(), TripleStream.this.model.mapBlankNode(TripleStream.this.names.nextBlankNode("alt")), TripleStream.this.model.mapResource(Rdf.TYPE), TripleStream.this.model.mapResource(Rdf.ALT));
            }
        }

        private class NewAlt
        implements ModelAction {
            private NewAlt() {
            }

            public Triple call() {
                return TripleStream.this.model.add(TripleStream.this.randomGraph(), TripleStream.this.model.mapResource(TripleStream.this.names.nextUri("alt")), TripleStream.this.model.mapResource(Rdf.TYPE), TripleStream.this.model.mapResource(Rdf.ALT));
            }
        }

        private class NewBlankStatement
        implements ModelAction {
            private NewBlankStatement() {
            }

            public Triple call() {
                return TripleStream.this.model.add(TripleStream.this.randomGraph(), TripleStream.this.model.mapBlankNode(TripleStream.this.names.nextBlankNode("statement")), TripleStream.this.model.mapResource(Rdf.TYPE), TripleStream.this.model.mapResource(Rdf.STATEMENT));
            }
        }

        private class NewStatement
        implements ModelAction {
            private NewStatement() {
            }

            public Triple call() {
                return TripleStream.this.model.add(TripleStream.this.randomGraph(), TripleStream.this.model.mapResource(TripleStream.this.names.nextUri("statement")), TripleStream.this.model.mapResource(Rdf.TYPE), TripleStream.this.model.mapResource(Rdf.STATEMENT));
            }
        }

        private class NewMetaproperty
        implements ModelAction {
            private NewMetaproperty() {
            }

            public Triple call() {
                return TripleStream.this.model.add(TripleStream.this.randomGraph(), TripleStream.this.model.mapResource(TripleStream.this.names.nextUri("metaproperty")), TripleStream.this.model.mapResource(RdfSchema.SUBCLASSOF), TripleStream.this.model.mapResource(Rdf.PROPERTY));
            }
        }

        private class NewMetaclass
        implements ModelAction {
            private NewMetaclass() {
            }

            public Triple call() {
                return TripleStream.this.model.add(TripleStream.this.randomGraph(), TripleStream.this.model.mapResource(TripleStream.this.names.nextUri("metaclass")), TripleStream.this.model.mapResource(RdfSchema.SUBCLASSOF), TripleStream.this.model.mapResource(RdfSchema.CLASS));
            }
        }

        private class NewProperty
        implements ModelAction {
            private NewProperty() {
            }

            public Triple call() {
                return TripleStream.this.model.add(TripleStream.this.randomGraph(), TripleStream.this.model.mapResource(TripleStream.this.dummy), TripleStream.this.model.mapResource(TripleStream.this.names.nextUri("property")), TripleStream.this.model.mapResource(TripleStream.this.dummy));
            }
        }

        private class NewClass
        implements ModelAction {
            private NewClass() {
            }

            public Triple call() {
                return TripleStream.this.model.add(TripleStream.this.randomGraph(), TripleStream.this.model.mapResource(TripleStream.this.names.nextUri("class")), TripleStream.this.model.mapResource(Rdf.TYPE), TripleStream.this.model.mapResource(RdfSchema.CLASS));
            }
        }

        private class NewBlankIndividual
        implements ModelAction {
            private NewBlankIndividual() {
            }

            public Triple call() {
                return TripleStream.this.model.add(TripleStream.this.randomGraph(), TripleStream.this.model.mapBlankNode(TripleStream.this.names.nextBlankNode("individual")), TripleStream.this.model.mapResource(Rdf.TYPE), TripleStream.this.model.mapResource(RdfSchema.RESOURCE));
            }
        }

        private class NewIndividual
        implements ModelAction {
            private NewIndividual() {
            }

            public Triple call() {
                return TripleStream.this.model.add(TripleStream.this.randomGraph(), TripleStream.this.model.mapResource(TripleStream.this.names.nextUri("individual")), TripleStream.this.model.mapResource(Rdf.TYPE), TripleStream.this.model.mapResource(RdfSchema.RESOURCE));
            }
        }

        private class NewNamedGraph
        implements ModelAction {
            private NewNamedGraph() {
            }

            public Triple call() {
                Resource newNamedGraph = TripleStream.this.model.mapResource(TripleStream.this.names.nextUri("graph"));
                TripleStream.this.namedGraphs.add(newNamedGraph);
                return TripleStream.this.model.add(TripleStream.this.randomGraph(), newNamedGraph, TripleStream.this.model.mapResource(Rdf.TYPE), TripleStream.this.model.mapResource(RdfSuite.GRAPH));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Event {
        NEW_NAMED_GRAPH,
        NEW_INDIVIDUAL,
        NEW_BLANK_INDIVIDUAL,
        NEW_CLASS,
        NEW_PROPERTY,
        NEW_METACLASS,
        NEW_METAPROPERTY,
        NEW_STATEMENT,
        NEW_BLANK_STATEMENT,
        NEW_ALT,
        NEW_BLANK_ALT,
        NEW_BAG,
        NEW_BLANK_BAG,
        NEW_SEQ,
        NEW_BLANK_SEQ,
        TURN_CLASS_TO_METACLASS,
        TURN_PROPERTY_TO_METAPROPERTY;

    }
}

