/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.swkm.model2.validation;

import com.google.common.base.Preconditions;
import gr.forth.ics.swkm.model2.validation.ErrorCode;
import gr.forth.ics.swkm.model2.validation.ValidationHandler;

public class ValidationProblem {
    private final String message;
    private final ErrorCode errorCode;
    private final boolean isError;

    private ValidationProblem(String message, ErrorCode errorCode, boolean isError) {
        this.message = (String)Preconditions.checkNotNull((Object)message);
        this.errorCode = (ErrorCode)((Object)Preconditions.checkNotNull((Object)((Object)errorCode)));
        this.isError = isError;
    }

    static ValidationProblem error(String message, ErrorCode errorCode) {
        return new ValidationProblem(message, errorCode, true);
    }

    static ValidationProblem warning(String message, ErrorCode errorCode) {
        return new ValidationProblem(message, errorCode, false);
    }

    public String getMessage() {
        return this.message;
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public boolean isError() {
        return this.isError;
    }

    public boolean isWarning() {
        return !this.isError;
    }

    void handledBy(ValidationHandler handler) {
        if (this.isError) {
            handler.handleError(this);
        } else {
            handler.handleWarning(this);
        }
    }

    public String toString() {
        return "[" + (Object)((Object)this.errorCode) + "] " + this.message;
    }
}

