/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.net;

import info.aduna.net.http.HttpClientUtil;
import info.aduna.text.StringUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UrlUtil {
    public static URL normalizeURL(URL url) {
        String protocol = url.getProtocol();
        String host = url.getHost();
        int port = url.getPort();
        String path = url.getPath();
        String query = url.getQuery();
        protocol = protocol.toLowerCase();
        host = host.toLowerCase();
        if (port == url.getDefaultPort()) {
            port = -1;
        }
        String file = UrlUtil._normalizePath(path);
        if (query != null) {
            query = UrlUtil._normalizeQuery(query);
            file = file + "?" + query;
        }
        try {
            return new URL(protocol, host, port, file);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private static String _normalizePath(String path) {
        String result = path;
        result = StringUtil.gsub((String)"//", (String)"/", (String)result);
        result = StringUtil.gsub((String)"/./", (String)"/", (String)result);
        result = result.replaceAll("/[^/]+/\\.\\./", "/");
        return result;
    }

    private static String _normalizeQuery(String query) {
        TreeSet<String> sortedSet = new TreeSet<String>();
        StringTokenizer tokenizer = new StringTokenizer(query, "&");
        while (tokenizer.hasMoreTokens()) {
            sortedSet.add(tokenizer.nextToken());
        }
        StringBuilder result = new StringBuilder(query.length());
        Iterator iter = sortedSet.iterator();
        while (iter.hasNext()) {
            result.append((String)iter.next());
            if (!iter.hasNext()) continue;
            result.append("&");
        }
        return result.toString();
    }

    public static boolean urlsEqual(URL url1, URL url2) {
        boolean result;
        String protocol1 = url1.getProtocol();
        String host1 = url1.getHost();
        int port1 = url1.getPort();
        String path1 = url1.getPath();
        String query1 = url1.getQuery();
        String ref1 = url1.getRef();
        String protocol2 = url2.getProtocol();
        String host2 = url2.getHost();
        int port2 = url2.getPort();
        String path2 = url2.getPath();
        String query2 = url2.getQuery();
        String ref2 = url2.getRef();
        boolean bl = result = path1.equals(path2) && (host1 == null && host2 == null || host1 != null && host1.equalsIgnoreCase(host2)) && (ref1 == null && ref2 == null || ref1 != null && ref1.equals(ref2)) && (port1 == port2 || port1 == -1 && port2 == url1.getDefaultPort() || port2 == -1 && port1 == url2.getDefaultPort()) && (protocol1 == null && protocol2 == null || protocol1 != null && protocol1.equalsIgnoreCase(protocol2));
        if (result) {
            boolean bl2 = result = query1 == null && query2 == null || query1 != null && query1.equals(query2);
            if (!result && query1 != null && query2 != null) {
                query1 = UrlUtil._normalizeQuery(query1);
                query2 = UrlUtil._normalizeQuery(query2);
                result = query1.equals(query2);
            }
        }
        return result;
    }

    public static String buildQueryString(Map<String, String> keyValuePairs) {
        StringBuilder result = new StringBuilder(200);
        Set<Map.Entry<String, String>> entrySet = keyValuePairs.entrySet();
        Iterator<Map.Entry<String, String>> iter = entrySet.iterator();
        while (iter.hasNext()) {
            Map.Entry<String, String> keyValuePair = iter.next();
            String key = keyValuePair.getKey();
            String value = keyValuePair.getValue();
            HttpClientUtil.formUrlEncode(key, result);
            result.append('=');
            HttpClientUtil.formUrlEncode(value, result);
            if (!iter.hasNext()) continue;
            result.append('&');
        }
        return result.toString();
    }

    public static URL trimToDirectory(URL url) {
        String path = url.getPath();
        int lastPathSep = Math.max(path.lastIndexOf(47), path.lastIndexOf(92));
        if (lastPathSep != -1) {
            path = path.substring(0, lastPathSep + 1);
        }
        try {
            return new URL(url, path);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

