/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.rio.ntriples;

import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;

public class NTriplesUtil {
    public static Value parseValue(String nTriplesValue, ValueFactory valueFactory) throws IllegalArgumentException {
        if (nTriplesValue.startsWith("<")) {
            return NTriplesUtil.parseURI(nTriplesValue, valueFactory);
        }
        if (nTriplesValue.startsWith("_:")) {
            return NTriplesUtil.parseBNode(nTriplesValue, valueFactory);
        }
        if (nTriplesValue.startsWith("\"")) {
            return NTriplesUtil.parseLiteral(nTriplesValue, valueFactory);
        }
        throw new IllegalArgumentException("Not a legal N-Triples value: " + nTriplesValue);
    }

    public static Resource parseResource(String nTriplesResource, ValueFactory valueFactory) throws IllegalArgumentException {
        if (nTriplesResource.startsWith("<")) {
            return NTriplesUtil.parseURI(nTriplesResource, valueFactory);
        }
        if (nTriplesResource.startsWith("_:")) {
            return NTriplesUtil.parseBNode(nTriplesResource, valueFactory);
        }
        throw new IllegalArgumentException("Not a legal N-Triples resource: " + nTriplesResource);
    }

    public static URI parseURI(String nTriplesURI, ValueFactory valueFactory) throws IllegalArgumentException {
        if (nTriplesURI.startsWith("<") && nTriplesURI.endsWith(">")) {
            String uri = nTriplesURI.substring(1, nTriplesURI.length() - 1);
            uri = NTriplesUtil.unescapeString(uri);
            return valueFactory.createURI(uri);
        }
        throw new IllegalArgumentException("Not a legal N-Triples URI: " + nTriplesURI);
    }

    public static BNode parseBNode(String nTriplesBNode, ValueFactory valueFactory) throws IllegalArgumentException {
        if (nTriplesBNode.startsWith("_:")) {
            return valueFactory.createBNode(nTriplesBNode.substring(2));
        }
        throw new IllegalArgumentException("Not a legal N-Triples URI: " + nTriplesBNode);
    }

    public static Literal parseLiteral(String nTriplesLiteral, ValueFactory valueFactory) throws IllegalArgumentException {
        int endLabelIdx;
        if (nTriplesLiteral.startsWith("\"") && (endLabelIdx = NTriplesUtil.findEndOfLabel(nTriplesLiteral)) != -1) {
            int startLangIdx = nTriplesLiteral.indexOf("@", endLabelIdx);
            int startDtIdx = nTriplesLiteral.indexOf("^^", endLabelIdx);
            if (startLangIdx != -1 && startDtIdx != -1) {
                throw new IllegalArgumentException("Literals can not have both a language and a datatype");
            }
            String label = nTriplesLiteral.substring(1, endLabelIdx);
            label = NTriplesUtil.unescapeString(label);
            if (startLangIdx != -1) {
                String language = nTriplesLiteral.substring(startLangIdx + 1);
                return valueFactory.createLiteral(label, language);
            }
            if (startDtIdx != -1) {
                String datatype = nTriplesLiteral.substring(startDtIdx + 2);
                URI dtURI = NTriplesUtil.parseURI(datatype, valueFactory);
                return valueFactory.createLiteral(label, dtURI);
            }
            return valueFactory.createLiteral(label);
        }
        throw new IllegalArgumentException("Not a legal N-Triples literal: " + nTriplesLiteral);
    }

    private static int findEndOfLabel(String nTriplesLiteral) {
        boolean previousWasBackslash = false;
        for (int i = 1; i < nTriplesLiteral.length(); ++i) {
            char c = nTriplesLiteral.charAt(i);
            if (c == '\"' && !previousWasBackslash) {
                return i;
            }
            if (c == '\\' && !previousWasBackslash) {
                previousWasBackslash = true;
                continue;
            }
            if (!previousWasBackslash) continue;
            previousWasBackslash = false;
        }
        return -1;
    }

    public static String toNTriplesString(Value value) {
        if (value instanceof Resource) {
            return NTriplesUtil.toNTriplesString((Resource)value);
        }
        if (value instanceof Literal) {
            return NTriplesUtil.toNTriplesString((Literal)value);
        }
        throw new IllegalArgumentException("Unknown value type: " + value.getClass());
    }

    public static String toNTriplesString(Resource resource) {
        if (resource instanceof URI) {
            return NTriplesUtil.toNTriplesString((URI)resource);
        }
        if (resource instanceof BNode) {
            return NTriplesUtil.toNTriplesString((BNode)resource);
        }
        throw new IllegalArgumentException("Unknown resource type: " + resource.getClass());
    }

    public static String toNTriplesString(URI uri) {
        return "<" + NTriplesUtil.escapeString(uri.toString()) + ">";
    }

    public static String toNTriplesString(BNode bNode) {
        return "_:" + bNode.getID();
    }

    public static String toNTriplesString(Literal lit) {
        StringBuilder sb = new StringBuilder(128);
        sb.append("\"");
        sb.append(NTriplesUtil.escapeString(lit.getLabel()));
        sb.append("\"");
        if (lit.getDatatype() != null) {
            sb.append("^^");
            sb.append(NTriplesUtil.toNTriplesString(lit.getDatatype()));
        } else if (lit.getLanguage() != null) {
            sb.append("@");
            sb.append(lit.getLanguage());
        }
        return sb.toString();
    }

    public static boolean isLetterOrNumber(int c) {
        return NTriplesUtil.isLetter(c) || NTriplesUtil.isNumber(c);
    }

    public static boolean isLetter(int c) {
        return c >= 65 && c <= 90 || c >= 97 && c <= 122;
    }

    public static boolean isNumber(int c) {
        return c >= 48 && c <= 57;
    }

    public static String escapeString(String label) {
        int labelLength = label.length();
        StringBuilder sb = new StringBuilder(2 * labelLength);
        for (int i = 0; i < labelLength; ++i) {
            char c;
            char cInt = c = label.charAt(i);
            if (c == '\\') {
                sb.append("\\\\");
                continue;
            }
            if (c == '\"') {
                sb.append("\\\"");
                continue;
            }
            if (c == '\n') {
                sb.append("\\n");
                continue;
            }
            if (c == '\r') {
                sb.append("\\r");
                continue;
            }
            if (c == '\t') {
                sb.append("\\t");
                continue;
            }
            if (cInt >= '\u0000' && cInt <= '\b' || cInt == '\u000b' || cInt == '\f' || cInt >= '\u000e' && cInt <= '\u001f' || cInt >= '\u007f' && cInt <= '\uffff') {
                sb.append("\\u");
                sb.append(NTriplesUtil.toHexString(cInt, 4));
                continue;
            }
            if (cInt >= '\u10000' && cInt <= '\u10ffff') {
                sb.append("\\U");
                sb.append(NTriplesUtil.toHexString(cInt, 8));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String unescapeString(String s) {
        int backSlashIdx = s.indexOf(92);
        if (backSlashIdx == -1) {
            return s;
        }
        int startIdx = 0;
        int sLength = s.length();
        StringBuilder sb = new StringBuilder(sLength);
        while (backSlashIdx != -1) {
            String xx;
            sb.append(s.substring(startIdx, backSlashIdx));
            if (backSlashIdx + 1 >= sLength) {
                throw new IllegalArgumentException("Unescaped backslash in: " + s);
            }
            char c = s.charAt(backSlashIdx + 1);
            if (c == 't') {
                sb.append('\t');
                startIdx = backSlashIdx + 2;
            } else if (c == 'r') {
                sb.append('\r');
                startIdx = backSlashIdx + 2;
            } else if (c == 'n') {
                sb.append('\n');
                startIdx = backSlashIdx + 2;
            } else if (c == '\"') {
                sb.append('\"');
                startIdx = backSlashIdx + 2;
            } else if (c == '\\') {
                sb.append('\\');
                startIdx = backSlashIdx + 2;
            } else if (c == 'u') {
                if (backSlashIdx + 5 >= sLength) {
                    throw new IllegalArgumentException("Incomplete Unicode escape sequence in: " + s);
                }
                xx = s.substring(backSlashIdx + 2, backSlashIdx + 6);
                try {
                    c = (char)Integer.parseInt(xx, 16);
                    sb.append(c);
                    startIdx = backSlashIdx + 6;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Illegal Unicode escape sequence '\\u" + xx + "' in: " + s);
                }
            } else if (c == 'U') {
                if (backSlashIdx + 9 >= sLength) {
                    throw new IllegalArgumentException("Incomplete Unicode escape sequence in: " + s);
                }
                xx = s.substring(backSlashIdx + 2, backSlashIdx + 10);
                try {
                    c = (char)Integer.parseInt(xx, 16);
                    sb.append(c);
                    startIdx = backSlashIdx + 10;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Illegal Unicode escape sequence '\\U" + xx + "' in: " + s);
                }
            } else {
                throw new IllegalArgumentException("Unescaped backslash in: " + s);
            }
            backSlashIdx = s.indexOf(92, startIdx);
        }
        sb.append(s.substring(startIdx));
        return sb.toString();
    }

    public static String toHexString(int decimal, int stringLength) {
        StringBuilder sb = new StringBuilder(stringLength);
        String hexVal = Integer.toHexString(decimal).toUpperCase();
        int nofZeros = stringLength - hexVal.length();
        for (int i = 0; i < nofZeros; ++i) {
            sb.append('0');
        }
        sb.append(hexVal);
        return sb.toString();
    }
}

