/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.graph;

import gr.forth.ics.graph.Graph;
import gr.forth.ics.graph.Hint;
import gr.forth.ics.graph.concrete.PrimaryGraph;
import gr.forth.ics.graph.concrete.SecondaryGraph;
import gr.forth.ics.graph.util.Graphs;

public class GraphFactory {
    public static Graph newGraph() {
        return new PrimaryGraph();
    }

    public static Graph newGraph(Hint ... hints) {
        return GraphFactory.newGraph(true, hints);
    }

    public static Graph newGraph(boolean parallel) {
        PrimaryGraph g = new PrimaryGraph();
        if (!parallel) {
            Graphs.turnSimplicityOn(g);
        }
        return g;
    }

    public static Graph newGraph(boolean parallel, Hint ... hints) {
        PrimaryGraph g = new PrimaryGraph();
        if (!parallel) {
            Graphs.turnSimplicityOn(g);
        }
        for (Hint hint : hints) {
            g.hint(hint);
        }
        return g;
    }

    public static SecondaryGraph newSecondary() {
        return new SecondaryGraph();
    }

    public static SecondaryGraph newSecondary(Hint ... hints) {
        return GraphFactory.newSecondary(true, hints);
    }

    public static SecondaryGraph newSecondary(boolean parallel) {
        SecondaryGraph g = new SecondaryGraph();
        if (!parallel) {
            Graphs.turnSimplicityOn(g);
        }
        return g;
    }

    public static SecondaryGraph newSecondary(boolean parallel, Hint ... hints) {
        SecondaryGraph g = new SecondaryGraph();
        if (!parallel) {
            Graphs.turnSimplicityOn(g);
        }
        for (Hint hint : hints) {
            g.hint(hint);
        }
        return g;
    }
}

