/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.graph.algo;

import gr.forth.ics.graph.Direction;
import gr.forth.ics.graph.Graph;
import gr.forth.ics.graph.Node;
import gr.forth.ics.util.Args;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BarabasiAlbertGenerator {
    private Graph graph;
    private Set<Node> nodeSet;
    private List<Node> nodeList;
    private final int attachedEdgesPerStep;
    private final int steps;
    private final int startNodes;
    private final boolean allowParallel;
    private final Random random = new Random();

    public BarabasiAlbertGenerator(int steps, int startNodes, int attachedEdgesPerStep, boolean allowParallel) {
        Args.gte(startNodes, 0);
        Args.gte(steps, 1);
        Args.inRangeII(attachedEdgesPerStep, 0, startNodes);
        this.steps = steps;
        this.startNodes = startNodes;
        this.attachedEdgesPerStep = attachedEdgesPerStep;
        this.allowParallel = allowParallel;
    }

    private List<Node> createRandomEdge(Node newNode, Set<List<Node>> addedPairs) {
        boolean created_edge = false;
        ArrayList<Node> endpoints = new ArrayList<Node>(2);
        do {
            double degree;
            double attach_prob;
            Node attachNode = this.nodeList.get(this.random.nextInt(this.nodeList.size()));
            endpoints.add(newNode);
            endpoints.add(attachNode);
            if (!this.allowParallel && addedPairs.contains(endpoints) || !((attach_prob = ((degree = (double)this.graph.degree(attachNode, Direction.IN)) + 1.0) / (double)(this.graph.edgeCount() + this.graph.nodeCount() - 1)) >= this.random.nextDouble())) continue;
            created_edge = true;
        } while (!created_edge);
        addedPairs.add(endpoints);
        return endpoints;
    }

    public Graph generate(Graph g) {
        int i;
        this.graph = g;
        for (i = 0; i < this.startNodes; ++i) {
            this.graph.newNode();
        }
        this.nodeSet = this.graph.nodes().drainToSet();
        this.nodeList = this.graph.nodes().drainToList();
        for (i = 0; i < this.steps; ++i) {
            Object IS_NEW = new Object();
            Node newNode = this.graph.newNode();
            newNode.putWeakly(IS_NEW, true);
            LinkedList<List<Node>> edgesToBeAdded = new LinkedList<List<Node>>();
            HashSet<List<Node>> added_pairs = new HashSet<List<Node>>(this.attachedEdgesPerStep);
            for (int j = 0; j < this.attachedEdgesPerStep; ++j) {
                edgesToBeAdded.add(this.createRandomEdge(newNode, added_pairs));
            }
            for (List list : edgesToBeAdded) {
                this.graph.newEdge((Node)list.get(0), (Node)list.get(1));
            }
            this.nodeList.add(newNode);
        }
        this.graph = null;
        this.nodeList = null;
        this.nodeSet = null;
        return g;
    }
}

