/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.graph.algo;

import gr.forth.ics.graph.Edge;
import gr.forth.ics.graph.Graph;
import gr.forth.ics.graph.GraphFactory;
import gr.forth.ics.graph.InspectableGraph;
import gr.forth.ics.graph.Node;
import gr.forth.ics.graph.algo.Biconnectivity;
import gr.forth.ics.util.Args;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockCutPointTree {
    private final InspectableGraph graph;
    private final Graph blockCutPointTree;
    private final Object componentEdgesKey = new Object();
    private final Object cutNodeKey = new Object();
    private final Biconnectivity bicon;

    private BlockCutPointTree(InspectableGraph graph) {
        Args.notNull((Object)graph);
        this.graph = graph;
        this.bicon = Biconnectivity.execute(graph);
        this.blockCutPointTree = GraphFactory.newGraph();
        HashMap<Object, Node> blocks = new HashMap<Object, Node>();
        for (Edge e : graph.edges()) {
            HashSet<Edge> blockEdges;
            Object component = this.bicon.componentOf(e);
            Node block = (Node)blocks.get(component);
            if (block == null) {
                block = this.blockCutPointTree.newNode();
                blocks.put(component, block);
                blockEdges = new HashSet<Edge>();
                block.putWeakly(this.componentEdgesKey, blockEdges);
                block.setValue(Collections.unmodifiableSet(blockEdges));
            } else {
                HashSet<Edge> hashSet;
                blockEdges = hashSet = (HashSet<Edge>)block.get(this.componentEdgesKey);
            }
            blockEdges.add(e);
        }
        for (Node n : graph.nodes()) {
            if (!this.bicon.isCutNode(n)) continue;
            Node cutNode = this.blockCutPointTree.newNode(n);
            cutNode.putWeakly(this.cutNodeKey, n);
            HashSet<Object> neighborBlocks = new HashSet<Object>();
            for (Edge edge : graph.edges(n)) {
                neighborBlocks.add(this.bicon.componentOf(edge));
            }
            for (Edge edge : neighborBlocks) {
                Node block = (Node)blocks.get(edge);
                this.blockCutPointTree.newEdge(cutNode, block);
            }
        }
    }

    public static BlockCutPointTree execute(InspectableGraph graph) {
        return new BlockCutPointTree(graph);
    }

    public InspectableGraph get() {
        return this.blockCutPointTree;
    }

    public InspectableGraph getOriginalGraph() {
        return this.graph;
    }

    public boolean isBlock(Node n) {
        this.checkOwned(n);
        return n.has(this.componentEdgesKey);
    }

    public Set<Edge> getBlockEdges(Node blockNode) {
        Set edges = (Set)blockNode.get(this.componentEdgesKey);
        if (edges == null) {
            throw new IllegalArgumentException("Not a block node");
        }
        return edges;
    }

    public boolean isCutNode(Node n) {
        return !this.isBlock(n);
    }

    public Node getCutNode(Node cutNode) {
        if (!this.isCutNode(cutNode)) {
            throw new IllegalArgumentException("Not a cut node");
        }
        return cutNode.getNode(this.cutNodeKey);
    }

    private void checkOwned(Node n) {
        if (!this.blockCutPointTree.containsNode(n)) {
            throw new IllegalArgumentException("Not a node of the block-cutpoint tree: " + n);
        }
    }

    public Biconnectivity getBiconnectivity() {
        return this.bicon;
    }
}

