/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.graph.algo;

import gr.forth.ics.graph.Direction;
import gr.forth.ics.graph.GraphException;
import gr.forth.ics.graph.InspectableGraph;
import gr.forth.ics.graph.Node;
import gr.forth.ics.graph.algo.BucketSort;
import gr.forth.ics.graph.algo.Layerer;
import gr.forth.ics.graph.concrete.SecondaryGraph;
import gr.forth.ics.util.Args;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BucketSortLayerer
implements Layerer {
    private final List<Collection<Node>> layers = new ArrayList<Collection<Node>>();
    private final InspectableGraph g;
    private final Direction direction;

    private BucketSortLayerer(InspectableGraph g, Direction direction) {
        Args.notNull(new Object[]{g, direction});
        this.g = g;
        this.direction = direction;
        SecondaryGraph sg = new SecondaryGraph(g);
        BucketSort bs = new BucketSort(sg, direction);
        while (!sg.isEmpty()) {
            ArrayList<Node> layer = new ArrayList<Node>(bs.getNodes(0));
            if (layer.size() == 0) {
                throw new GraphException("No node with degree zero - graph with cycle?");
            }
            this.layers.add(layer);
            sg.removeNodes(layer);
        }
    }

    static Layerer execute(InspectableGraph g, Direction direction) {
        return new BucketSortLayerer(g, direction);
    }

    @Override
    public InspectableGraph getGraph() {
        return this.g;
    }

    @Override
    public Collection<Node> getLayer(int level) {
        Args.gte(level, 0);
        if (level >= this.layers.size()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.layers.get(level));
    }

    @Override
    public int getLayerCount() {
        return this.layers.size();
    }

    @Override
    public Collection<Node> getCluster(Object key) {
        Args.isTrue("Invalid key", key instanceof Integer);
        return this.getLayer((Integer)key);
    }

    public Set<Object> getClusters() {
        HashSet<Integer> keys = new HashSet<Integer>();
        for (int i = 0; i < this.getLayerCount(); ++i) {
            keys.add(i);
        }
        return Collections.unmodifiableSet(keys);
    }

    @Override
    public Iterator<Collection<Node>> iterator() {
        return this.layers.iterator();
    }

    @Override
    public Object findClusterOf(Node node) {
        if (!this.g.containsNode(node)) {
            return null;
        }
        return this.g.degree(node, this.direction);
    }
}

