/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.graph.algo;

import gr.forth.ics.graph.InspectableGraph;
import gr.forth.ics.graph.Node;
import gr.forth.ics.graph.algo.Clusterer;
import gr.forth.ics.graph.algo.Dfs;
import gr.forth.ics.graph.path.Path;
import gr.forth.ics.util.DVMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConnectedComponents
extends Dfs
implements Clusterer {
    private final Map<Object, Collection<Node>> components = DVMap.newLinkedHashMapWithLinkedLists();
    private final Object MARK = new Object();

    private ConnectedComponents(InspectableGraph graph) {
        super(graph);
    }

    private ConnectedComponents(InspectableGraph graph, Node startNode) {
        super(graph, startNode);
    }

    public static ConnectedComponents execute(InspectableGraph g) {
        ConnectedComponents cc = new ConnectedComponents(g);
        cc.execute();
        return cc;
    }

    public static ConnectedComponents execute(InspectableGraph g, Node startNode) {
        ConnectedComponents cc = new ConnectedComponents(g, startNode);
        cc.execute();
        return cc;
    }

    @Override
    public Iterator<Collection<Node>> iterator() {
        return Collections.unmodifiableMap(this.components).values().iterator();
    }

    @Override
    public Collection<Node> getCluster(Object cluster) {
        if (!this.components.containsKey(cluster)) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.components.get(cluster));
    }

    public Set<Object> getClusters() {
        return Collections.unmodifiableSet(this.components.keySet());
    }

    @Override
    public boolean visitPre(Path path) {
        Node node = path.tailNode();
        Object tree = this.getComponentIdentifier(node);
        Collection<Node> component = this.components.get(tree);
        component.add(node);
        node.putWeakly(this.MARK, tree);
        return false;
    }

    @Override
    public Object findClusterOf(Node node) {
        return this.getComponentIdentifier(node);
    }

    public String toString() {
        return "[Components: " + this.components.values() + "]";
    }
}

