/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.graph.algo;

import gr.forth.ics.graph.Direction;
import gr.forth.ics.graph.Edge;
import gr.forth.ics.graph.InspectableGraph;
import gr.forth.ics.graph.Node;
import gr.forth.ics.graph.algo.AbstractSearch;
import gr.forth.ics.graph.path.Path;
import java.util.Iterator;
import java.util.LinkedList;

public class Dfs
extends AbstractSearch {
    private Object EDGE_INFO;
    private Object NODE_INFO;
    private int time;

    public Dfs(InspectableGraph graph) {
        super(graph);
    }

    public Dfs(InspectableGraph graph, Node startNode) {
        super(graph, startNode);
    }

    private void initKeys() {
        this.EDGE_INFO = new Object();
        this.NODE_INFO = new Object();
    }

    protected void executeImpl() {
        block1: {
            Node n;
            this.initKeys();
            this.time = 0;
            boolean exit = this.dfs(this.startNode);
            if (exit) break block1;
            Iterator<Node> i$ = this.graph.nodes().iterator();
            while (!(!i$.hasNext() || this.isUnexplored(n = i$.next()) && (exit = this.dfs(n)))) {
            }
        }
    }

    protected boolean dfs(Node start) {
        Object tree = new Object();
        this.incTreeNumber();
        this.markNodeTree(start, tree);
        if (this.visitNewTree(start)) {
            return true;
        }
        Stack stack = new Stack();
        stack.push(start.asPath(), start, this.graph.edges(start, Direction.OUT).iterator());
        block0: while (!stack.isEmpty()) {
            ExecutionPoint executionPoint = stack.pop();
            Node root = executionPoint.node;
            Iterator<Edge> iterator = executionPoint.iterator;
            NodeInfo rootInfo = this.getNode(root);
            if (rootInfo == null || rootInfo.justCreated) {
                Edge parent = rootInfo == null ? null : rootInfo.parent;
                rootInfo = new NodeInfo(this.time++, parent);
                rootInfo.justCreated = false;
                this.markNode(root, rootInfo);
                this.markNodeTree(root, tree);
                if (this.visitPre(executionPoint.parent)) {
                    return true;
                }
            }
            while (iterator.hasNext()) {
                Edge e = iterator.next();
                Path currentPath = executionPoint.parent.append(e.asPath(executionPoint.parent.tailNode()));
                currentPath = this.storePath(currentPath);
                if (this.getEdge(e) != null) continue;
                Node other = e.opposite(root);
                NodeInfo otherInfo = this.getNode(other);
                if (otherInfo == null) {
                    this.markEdge(e, EdgeType.treeEdge);
                    if (this.visitTreeEdge(currentPath)) {
                        return true;
                    }
                    stack.push(executionPoint.parent, root, iterator);
                    stack.push(currentPath, other, this.graph.edges(other, Direction.OUT).iterator());
                    otherInfo = new NodeInfo(this.time, e);
                    this.markNode(other, otherInfo);
                    continue block0;
                }
                if (!otherInfo.doneVisiting) {
                    this.markEdge(e, EdgeType.backEdge);
                    if (!this.visitBackEdge(currentPath)) continue;
                    return true;
                }
                if (otherInfo.time.endTime < rootInfo.time.startTime) {
                    this.markEdge(e, EdgeType.crossEdge);
                    if (!this.visitCrossEdge(currentPath)) continue;
                    return true;
                }
                this.markEdge(e, EdgeType.forwardEdge);
                if (!this.visitForwardEdge(currentPath)) continue;
                return true;
            }
            ++this.time;
            rootInfo.time.endTime = rootInfo.time.endTime;
            if (this.visitPost(executionPoint.parent)) {
                return true;
            }
            rootInfo.doneVisiting = true;
        }
        return false;
    }

    protected boolean visitTreeEdge(Path path) {
        return false;
    }

    protected boolean visitPre(Path path) {
        return false;
    }

    protected boolean visitPost(Path path) {
        return false;
    }

    protected boolean visitForwardEdge(Path path) {
        return false;
    }

    protected boolean visitBackEdge(Path path) {
        return false;
    }

    protected boolean visitCrossEdge(Path path) {
        return false;
    }

    private NodeInfo getNode(Node node) {
        return (NodeInfo)node.get(this.NODE_INFO);
    }

    private void markEdge(Edge edge, EdgeType type) {
        edge.putWeakly(this.EDGE_INFO, (Object)type);
    }

    private EdgeType getEdge(Edge e) {
        return (EdgeType)((Object)e.get(this.EDGE_INFO));
    }

    private void markNode(Node node, NodeInfo info) {
        node.putWeakly(this.NODE_INFO, info);
    }

    public boolean isTreeEdge(Edge e) {
        return this.isType(e, EdgeType.treeEdge);
    }

    public boolean isCrossEdge(Edge e) {
        return this.isType(e, EdgeType.crossEdge);
    }

    public boolean isForwardEdge(Edge e) {
        return this.isType(e, EdgeType.forwardEdge);
    }

    public boolean isBackEdge(Edge e) {
        return this.isType(e, EdgeType.backEdge);
    }

    private boolean isType(Edge e, EdgeType type) {
        EdgeType edgeType = this.getEdge(e);
        if (edgeType == null) {
            return false;
        }
        return edgeType == type;
    }

    public boolean isUnexplored(Node node) {
        return this.getNode(node) == null;
    }

    public boolean isVisited(Node node) {
        NodeInfo info = this.getNode(node);
        if (info == null) {
            return false;
        }
        return info.doneVisiting;
    }

    public boolean isVisiting(Node node) {
        NodeInfo info = this.getNode(node);
        if (info == null) {
            return false;
        }
        return !info.doneVisiting;
    }

    public Time getTime(Node node) {
        NodeInfo info = this.getNode(node);
        if (info == null) {
            return null;
        }
        return info.time;
    }

    public Node getParent(Node node) {
        Edge parent = this.getParentEdge(node);
        if (parent == null) {
            return null;
        }
        return parent.opposite(node);
    }

    public Edge getParentEdge(Node node) {
        NodeInfo info = this.getNode(node);
        if (info == null) {
            return null;
        }
        return info.parent;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExecutionPoint {
        final Node node;
        final Iterator<Edge> iterator;
        final Path parent;

        ExecutionPoint(Path parent, Node node, Iterator<Edge> iterator) {
            this.parent = parent;
            this.node = node;
            this.iterator = iterator;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Stack {
        private final LinkedList<ExecutionPoint> list = new LinkedList();

        private Stack() {
        }

        void push(Path current, Node node, Iterator<Edge> iterator) {
            this.list.addLast(new ExecutionPoint(current, node, iterator));
        }

        ExecutionPoint pop() {
            return this.list.removeLast();
        }

        boolean isEmpty() {
            return this.list.isEmpty();
        }
    }

    public static class Time {
        int startTime = -1;
        int endTime = -1;

        Time(int start) {
            this.startTime = start;
        }

        public int getStart() {
            return this.startTime;
        }

        public int getFinish() {
            return this.endTime;
        }

        public String toString() {
            return "[" + this.startTime + ".." + this.endTime + "]";
        }
    }

    private static class NodeInfo {
        final Time time;
        boolean doneVisiting = false;
        boolean justCreated = true;
        final Edge parent;

        NodeInfo(int time) {
            this(time, null);
        }

        NodeInfo(int time, Edge parent) {
            this.time = new Time(time);
            this.parent = parent;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum EdgeType {
        treeEdge,
        forwardEdge,
        backEdge,
        crossEdge;

    }
}

