/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.graph.algo;

import gr.forth.ics.graph.Graph;
import gr.forth.ics.graph.Node;
import gr.forth.ics.util.Args;
import java.util.Random;

class ErdosRenyiGenerator {
    private final int numNodes;
    private final double edgeConnectionProbability;
    private final Random random;

    ErdosRenyiGenerator(int nodes, double p) {
        this(nodes, p, new Random());
    }

    ErdosRenyiGenerator(int nodes, double p, Random random) {
        Args.gt(nodes, 0);
        Args.inRangeII(Double.valueOf(p), 0.0, 1.0);
        Args.notNull((Object)random);
        this.numNodes = nodes;
        this.edgeConnectionProbability = p;
        this.random = random;
    }

    Graph generate(Graph graph) {
        Node[] nodes;
        for (Node n1 : nodes = graph.newNodes(this.numNodes)) {
            for (Node n2 : nodes) {
                if (!(this.random.nextDouble() < this.edgeConnectionProbability)) continue;
                graph.newEdge(n1, n2);
            }
        }
        return graph;
    }
}

